/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.requirement.AbstractVerifiedRequirementException;
import org.squashtest.tm.exception.requirement.RequirementAlreadyVerifiedException;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeWalker;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;

@Service(value="squashtest.tm.service.VerifyingTestCaseManagerService")
@Transactional
public class VerifyingTestCaseManagerServiceImpl
implements VerifyingTestCaseManagerService {
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private RequirementVersionCoverageDao requirementVersionCoverageDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao;

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public Map<String, Collection<?>> addVerifyingTestCasesToRequirementVersion(List<Long> testCaseLibraryNodeIds, long requirementVersionId) {
        this.permissionEvaluationService.checkPermission(testCaseLibraryNodeIds, Permissions.READ.name(), TestCaseLibraryNode.class.getName());
        List<TestCaseLibraryNode> nodes = this.testCaseLibraryNodeDao.findAllByIds(testCaseLibraryNodeIds);
        List<TestCase> testCases = new TestCaseNodeWalker().walk(nodes);
        List ids = IdentifiedUtil.extractIds(testCases);
        Collection<Object> rejections = Collections.emptyList();
        if (!testCases.isEmpty()) {
            rejections = this.doAddVerifyingTestCasesToRequirementVersion(testCases, requirementVersionId);
        }
        HashMap result = new HashMap(2);
        result.put("IDS", ids);
        result.put("REJECTION", rejections);
        return result;
    }

    private Collection<AbstractVerifiedRequirementException> doAddVerifyingTestCasesToRequirementVersion(List<TestCase> testCases, long requirementVersionId) {
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        return this.doAddVerifyingTestCasesToRequirementVersion(testCases, requirementVersion);
    }

    private Collection<AbstractVerifiedRequirementException> doAddVerifyingTestCasesToRequirementVersion(List<TestCase> testCases, RequirementVersion requirementVersion) {
        ArrayList<AbstractVerifiedRequirementException> rejections = new ArrayList<AbstractVerifiedRequirementException>(testCases.size());
        Iterator<TestCase> iterator = testCases.iterator();
        while (iterator.hasNext()) {
            TestCase testCase = iterator.next();
            try {
                RequirementVersionCoverage coverage = new RequirementVersionCoverage(requirementVersion, testCase);
                this.requirementVersionCoverageDao.persist(coverage);
            }
            catch (RequirementAlreadyVerifiedException ex) {
                rejections.add((AbstractVerifiedRequirementException)ex);
                iterator.remove();
            }
        }
        this.testCaseImportanceManagerService.changeImportanceIfRelationsAddedToReq(testCases, requirementVersion);
        return rejections;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifyingTestCasesFromRequirementVersion(List<Long> testCasesIds, long requirementVersionId) {
        List testCases = this.testCaseDao.findAllByIds(testCasesIds);
        if (!testCases.isEmpty()) {
            this.requirementVersionCoverageDao.checkIfReqVersionIsLinkable(requirementVersionId);
            List coveragesToDelete = this.requirementVersionCoverageDao.byRequirementVersionAndTestCases(testCasesIds, requirementVersionId);
            this.requirementVersionCoverageDao.delete(coveragesToDelete);
            this.testCaseImportanceManagerService.changeImportanceIfRelationsRemovedFromReq(testCasesIds, requirementVersionId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'LINK') or hasRole('ROLE_ADMIN')")
    public void removeVerifyingTestCaseFromRequirementVersion(long testCaseId, long requirementVersionId) {
        RequirementVersionCoverage coverage = this.requirementVersionCoverageDao.byRequirementVersionAndTestCase(requirementVersionId, testCaseId);
        coverage.checkCanRemoveTestCaseFromRequirementVersion();
        this.requirementVersionCoverageDao.delete(List.of(coverage.getId()));
        this.testCaseImportanceManagerService.changeImportanceIfRelationsRemovedFromReq(Arrays.asList(testCaseId), requirementVersionId);
    }

    @Override
    @Transactional(readOnly=true)
    public PagedCollectionHolder<List<TestCase>> findAllByRequirementVersion(long requirementVersionId, PagingAndSorting pagingAndSorting) {
        List verifiers = this.testCaseDao.findAllByVerifiedRequirementVersion(requirementVersionId, pagingAndSorting);
        long verifiersCount = this.testCaseDao.countByVerifiedRequirementVersion(requirementVersionId);
        return new PagingBackedPagedCollectionHolder((Paging)pagingAndSorting, verifiersCount, (Collection)verifiers);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TestCase> findAllByRequirementVersion(long requirementVersionId) {
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting("Project.name", true);
        return (List)this.findAllByRequirementVersion(requirementVersionId, (PagingAndSorting)pas).getPagedItems();
    }
}

