/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.testautomation.resultimport.FailureDetailImportService;

@Service
public class FailureDetailImportServiceImpl
implements FailureDetailImportService {
    private final PluginFinderService pluginFinderService;
    private final FailureDetailDao failureDetailDao;

    @Inject
    public FailureDetailImportServiceImpl(PluginFinderService pluginFinderService, FailureDetailDao failureDetailDao) {
        this.pluginFinderService = pluginFinderService;
        this.failureDetailDao = failureDetailDao;
    }

    @Override
    public void addFailureDetails(Map<Execution, TestDto> createdExecutionMap, PartialErrorDto partialErrors) {
        ArrayList<FailureDetail> failureDetailsToSave = new ArrayList<FailureDetail>();
        for (Map.Entry<Execution, TestDto> entry : createdExecutionMap.entrySet()) {
            this.processFailureDetailsForExecution(partialErrors, entry, failureDetailsToSave);
        }
        if (!failureDetailsToSave.isEmpty()) {
            this.failureDetailDao.saveAll(failureDetailsToSave);
        }
    }

    private void processFailureDetailsForExecution(PartialErrorDto partialErrors, Map.Entry<Execution, TestDto> entry, List<FailureDetail> failureDetailsToSave) {
        Execution execution = entry.getKey();
        TestDto testDto = entry.getValue();
        List<String> failureDetailMessagesFromRequest = testDto.getFailureDetails();
        if (failureDetailMessagesFromRequest == null || failureDetailMessagesFromRequest.isEmpty()) {
            return;
        }
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Adding failure details is only available for Squash Premium or Ultimate licenses.");
            return;
        }
        this.addFailureDetail(partialErrors, failureDetailMessagesFromRequest, execution, failureDetailsToSave);
    }

    private void addFailureDetail(PartialErrorDto partialErrors, List<String> failureDetailMessagesFromRequest, Execution execution, List<FailureDetail> failureDetailsToSave) {
        for (String failureDetailMessageFromRequest : failureDetailMessagesFromRequest) {
            if (StringUtils.isBlank((CharSequence)failureDetailMessageFromRequest)) {
                partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "Failure detail message cannot be empty");
                continue;
            }
            FailureDetail failureDetail = this.findOrCreateFailureDetailsForExecution(failureDetailMessageFromRequest, execution, failureDetailsToSave);
            failureDetail.addExecutionExtender(execution.getAutomatedExecutionExtender());
        }
    }

    private FailureDetail findOrCreateFailureDetailsForExecution(String failureDetailMessageFromRequest, Execution execution, List<FailureDetail> failureDetailsToSave) {
        Optional<FailureDetail> alreadyInFailureDetailsToSave = failureDetailsToSave.stream().filter(fd -> fd.getMessage().equals(failureDetailMessageFromRequest) && fd.getTestPlanItem().getId().equals(execution.getTestPlanItem().getId())).findFirst();
        if (alreadyInFailureDetailsToSave.isPresent()) {
            return alreadyInFailureDetailsToSave.get();
        }
        Optional<FailureDetail> failureDetailFromDatabase = execution.getTestPlanItem().getFailureDetailList().stream().filter(fd -> fd.getMessage().equals(failureDetailMessageFromRequest)).findFirst();
        FailureDetail result = failureDetailFromDatabase.orElseGet(() -> new FailureDetail(failureDetailMessageFromRequest, UserContextHolder.getUsername(), new Date(), execution.getTestPlanItem()));
        failureDetailsToSave.add(result);
        return result;
    }
}

