/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.loaders.common;

import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NonUniqueResultException;
import java.util.Collections;
import java.util.List;
import org.squashtest.tm.service.internal.repository.loaders.common.DefaultOptionHolder;
import org.squashtest.tm.service.internal.repository.loaders.common.MultipleLoader;
import org.squashtest.tm.service.internal.repository.loaders.common.SingleLoader;

public interface Loader<TYPE, KEY, OPTIONS>
extends SingleLoader<TYPE, KEY, OPTIONS>,
MultipleLoader<TYPE, KEY, OPTIONS>,
DefaultOptionHolder<OPTIONS> {
    @Override
    default public TYPE load(KEY id, OPTIONS options) {
        TYPE load = this.load((KEY)Collections.singleton(id), options);
        if (load.isEmpty()) {
            throw new EntityNotFoundException();
        }
        if (load.size() > 1) {
            throw new NonUniqueResultException();
        }
        return (TYPE)load.get(0);
    }

    default public TYPE load(KEY id) {
        return this.load(id, this.defaultOptions());
    }

    default public List<TYPE> load(List<KEY> ids) {
        return this.load((KEY)ids, this.defaultOptions());
    }
}

