/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomInfoListDao;
import org.squashtest.tm.service.internal.repository.InfoListDao;

@Repository
public class InfoListDaoImpl
implements CustomInfoListDao {
    @Inject
    @Lazy
    private InfoListDao infoListDao;
    @Inject
    DSLContext dsl;
    @PersistenceContext
    private EntityManager em;

    @Override
    public boolean isUsedByOneOrMoreProject(long infoListId) {
        Query query = this.em.createNamedQuery("infoList.findProjectUsingInfoList");
        query.setParameter("id", (Object)infoListId);
        return !query.getResultList().isEmpty();
    }

    @Override
    public void unbindFromProject(long infoListId) {
        InfoList defaultReqCatList = this.infoListDao.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setReqCatListToDefault", defaultReqCatList);
        InfoList defaultTcNatList = this.infoListDao.findByCode(SystemInfoListCode.TEST_CASE_NATURE.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setTcNatListToDefault", defaultTcNatList);
        InfoList defaultTcTypeList = this.infoListDao.findByCode(SystemInfoListCode.TEST_CASE_TYPE.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setTcTypeListToDefault", defaultTcTypeList);
    }

    private void execUpdateQuery(long infoListId, String queryName, Object defaultParam) {
        Query query = this.em.createNamedQuery(queryName);
        query.setParameter("default", defaultParam);
        query.setParameter("id", (Object)infoListId);
        query.executeUpdate();
    }

    @Override
    public List<InfoList> findAllInfoListSystem() {
        List<String> codes = Arrays.stream(SystemInfoListCode.values()).map(SystemInfoListCode::getCode).toList();
        return this.em.createQuery("select il from InfoList il where il.code in :codes", InfoList.class).setParameter("codes", codes).getResultList();
    }

    @Override
    public Map<InfoListProjectBindingType, InfoListInfo> findAllUsedInfoListCodeByProjectId(Long projectId) {
        SelectConditionStep haveReq = DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep haveTc = DSL.selectOne().from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        Field infoListType = DSL.field((String)"INFO_LIST_TYPE", String.class);
        return this.getInfoListCodeAndKind(projectId, InfoListProjectBindingType.REQUIREMENT_CATEGORY, (Field<Long>)Tables.PROJECT.REQ_CATEGORIES_LIST, (SelectConditionStep<Record1<Integer>>)haveReq).unionAll(this.getInfoListCodeAndKind(projectId, InfoListProjectBindingType.TEST_CASE_NATURE, (Field<Long>)Tables.PROJECT.TC_NATURES_LIST, (SelectConditionStep<Record1<Integer>>)haveTc)).unionAll(this.getInfoListCodeAndKind(projectId, InfoListProjectBindingType.TEST_CASE_TYPE, (Field<Long>)Tables.PROJECT.TC_TYPES_LIST, (SelectConditionStep<Record1<Integer>>)haveTc)).stream().collect(Collectors.toMap(r -> InfoListProjectBindingType.valueOf((String)((String)r.get(infoListType))), r -> new InfoListInfo((String)r.get((Field)Tables.INFO_LIST.LABEL), (String)r.get((Field)Tables.INFO_LIST.CODE))));
    }

    private SelectHavingStep<Record3<String, String, String>> getInfoListCodeAndKind(Long projectId, InfoListProjectBindingType kind, Field<Long> projectJoinField, SelectConditionStep<Record1<Integer>> usedQuery) {
        return this.dsl.select((SelectField)DSL.val((String)kind.name()).as("INFO_LIST_TYPE"), (SelectField)Tables.INFO_LIST.CODE, (SelectField)Tables.INFO_LIST.LABEL).from((TableLike)Tables.PROJECT).join((TableLike)Tables.INFO_LIST).on(projectJoinField.eq((Field)Tables.INFO_LIST.INFO_LIST_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(DSL.exists(usedQuery));
    }

    public record InfoListInfo(String label, String code) {
    }
}

