/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ActionTestStep;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.AttachmentListHolderDto;
import org.squashtest.tm.service.internal.display.dto.CufHolderDto;
import org.squashtest.tm.service.internal.display.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.display.dto.execution.ActionStepExecView;
import org.squashtest.tm.service.internal.display.dto.testcase.AbstractTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordFragmentValueDto;
import org.squashtest.tm.service.internal.display.dto.testcase.CalledTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.KeywordTestStepDto;
import org.squashtest.tm.service.internal.repository.display.ActionWordDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestStepDisplayDao;

@Repository
public class TestStepDisplayDaoImpl
implements TestStepDisplayDao {
    public static final String ACTION_STEP_TEST_CASE_ID = "ACTION_STEP_TEST_CASE_ID";
    public static final String ACTION_STEP_TEST_CASE_NAME = "ACTION_STEP_TEST_CASE_NAME";
    public static final String ACTION_STEP_TEST_CASE_REFERENCE = "ACTION_STEP_TEST_CASE_REFERENCE";
    private static final TestCase CALLED_TEST_CASE = Tables.TEST_CASE.as("CALLED_TEST_CASE");
    private static final TestCaseLibraryNode CALLED_TEST_CASE_LIBRARY_NODE = Tables.TEST_CASE_LIBRARY_NODE.as("CALLED_TEST_CASE_LIBRARY_NODE");
    private DSLContext dsl;
    private AttachmentDisplayDao attachmentDisplayDao;
    private CustomFieldValueDisplayDao customFieldValueDisplayDao;
    private ActionWordDisplayDao actionWordDisplayDao;

    public TestStepDisplayDaoImpl(DSLContext dsl, AttachmentDisplayDao attachmentDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActionWordDisplayDao actionWordDisplayDao) {
        this.dsl = dsl;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.actionWordDisplayDao = actionWordDisplayDao;
    }

    @Override
    public List<AbstractTestStepDto> getTestStepsByTestCase(Long testCaseId) {
        List<AbstractTestStepDto> testSteps = this.fetchTestStepsByTestCase(testCaseId);
        return this.appendDependantData(testSteps);
    }

    @Override
    public ActionStepExecView findOneActionStepExecView(long executionId, long stepId) {
        ActionStepExecView view = this.fetchActionStepExecView(stepId);
        this.appendCustomFieldValues(Collections.singletonList(view));
        this.appendAttachments(Collections.singletonList(view));
        return view;
    }

    private ActionStepExecView fetchActionStepExecView(long stepId) {
        return (ActionStepExecView)this.dsl.select((SelectField)ActionTestStep.ACTION_TEST_STEP.TEST_STEP_ID.as("ID"), (SelectField)ActionTestStep.ACTION_TEST_STEP.ACTION, (SelectField)ActionTestStep.ACTION_TEST_STEP.EXPECTED_RESULT, (SelectField)ActionTestStep.ACTION_TEST_STEP.ATTACHMENT_LIST_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ACTION_STEP_TEST_CASE_ID), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as(ACTION_STEP_TEST_CASE_NAME), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.TEST_CASE.REFERENCE.as(ACTION_STEP_TEST_CASE_REFERENCE)).from((TableLike)ActionTestStep.ACTION_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)ActionTestStep.ACTION_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).where(ActionTestStep.ACTION_TEST_STEP.TEST_STEP_ID.eq((Object)stepId)).fetchOneInto(ActionStepExecView.class);
    }

    @Override
    public List<AbstractTestStepDto> getTestSteps(Set<Long> testStepIds) {
        List<AbstractTestStepDto> testSteps = this.fetchTestSteps(testStepIds);
        return this.appendDependantData(testSteps);
    }

    private List<AbstractTestStepDto> appendDependantData(List<AbstractTestStepDto> testSteps) {
        List<KeywordTestStepDto> keywordSteps;
        List<CalledTestStepDto> callSteps;
        Map<String, List<AbstractTestStepDto>> stepsByKind = testSteps.stream().collect(Collectors.groupingBy(AbstractTestStepDto::getKind));
        List<ActionTestStepDto> actionSteps = ((List)stepsByKind.getOrDefault("action-step", new ArrayList())).stream().map(ActionTestStepDto.class::cast).toList();
        if (!actionSteps.isEmpty()) {
            this.appendAttachments(actionSteps);
            this.appendCustomFieldValues(actionSteps);
        }
        if (!(callSteps = ((List)stepsByKind.getOrDefault("call-step", new ArrayList())).stream().map(CalledTestStepDto.class::cast).toList()).isEmpty()) {
            this.appendCalledSteps(callSteps);
        }
        if (!(keywordSteps = ((List)stepsByKind.getOrDefault("keyword-step", new ArrayList())).stream().map(KeywordTestStepDto.class::cast).toList()).isEmpty()) {
            this.appendAction(keywordSteps);
        }
        return testSteps;
    }

    private void appendAction(List<KeywordTestStepDto> keywordSteps) {
        List<Long> keywordStepIds = keywordSteps.stream().map(KeywordTestStepDto::getId).toList();
        List<ActionWordFragmentValueDto> fragmentDtoList = this.actionWordDisplayDao.findActionWordFragmentValues(keywordStepIds);
        keywordSteps.forEach(keywordStep -> {
            List<ActionWordFragmentValueDto> fragmentList = fragmentDtoList.stream().filter(fragmentDto -> keywordStep.getId().equals(fragmentDto.getKeywordStepId())).toList();
            keywordStep.setAction(this.buildActionForStep(fragmentList));
            keywordStep.setStyledAction(this.buildStyledActionForStep(fragmentList));
        });
    }

    private String buildStyledActionForStep(List<ActionWordFragmentValueDto> fragmentList) {
        return fragmentList.stream().map(ActionWordFragmentValueDto::getStyledAction).collect(Collectors.joining());
    }

    private String buildActionForStep(List<ActionWordFragmentValueDto> fragmentList) {
        return fragmentList.stream().map(ActionWordFragmentValueDto::getUnstyledAction).collect(Collectors.joining());
    }

    private void appendCalledSteps(List<CalledTestStepDto> callSteps) {
        Set calledTestCaseId = callSteps.stream().map(CalledTestStepDto::getCalledTcId).collect(Collectors.toSet());
        Multimap<Long, AbstractTestStepDto> stepMap = this.fetchTestSteps(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(calledTestCaseId));
        callSteps.forEach(callStep -> callStep.addCalledTestCaseSteps(stepMap.get((Object)callStep.getCalledTcId())));
    }

    private void appendCustomFieldValues(List<? extends CufHolderDto> cufHolders) {
        List<Long> stepsIds = cufHolders.stream().map(CufHolderDto::getId).toList();
        ListMultimap<Long, CustomFieldValueDto> customFieldValues = this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.TEST_STEP, stepsIds);
        cufHolders.forEach(actionStep -> {
            List customFieldValue = customFieldValues.get((Object)actionStep.getId());
            actionStep.setCustomFieldValues(customFieldValue);
        });
    }

    private void appendAttachments(List<? extends AttachmentListHolderDto> actionSteps) {
        Set<Long> attachmentListIds = actionSteps.stream().map(AttachmentListHolderDto::getAttachmentList).map(AttachmentListDto::getId).collect(Collectors.toSet());
        Map attachmentsLists = this.attachmentDisplayDao.findAttachmentListByIds(attachmentListIds).stream().collect(Collectors.toMap(AttachmentListDto::getId, Function.identity()));
        actionSteps.forEach(actionTestStepDto -> {
            Long id = actionTestStepDto.getAttachmentListId();
            AttachmentListDto attachmentList = (AttachmentListDto)attachmentsLists.get(id);
            actionTestStepDto.addAttachments(attachmentList.getAttachments());
        });
    }

    private List<AbstractTestStepDto> fetchTestSteps(Set<Long> testStepIds) {
        if (testStepIds.isEmpty()) {
            return new ArrayList<AbstractTestStepDto>();
        }
        Multimap<Long, AbstractTestStepDto> dtoMap = this.fetchTestSteps(Tables.TEST_CASE_STEPS.STEP_ID.in(testStepIds));
        return new ArrayList<AbstractTestStepDto>(dtoMap.values());
    }

    private List<AbstractTestStepDto> fetchTestStepsByTestCase(Long testCaseId) {
        Multimap<Long, AbstractTestStepDto> dtoMap = this.fetchTestSteps(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(Collections.singletonList(testCaseId)));
        return new ArrayList<AbstractTestStepDto>(dtoMap.get((Object)testCaseId));
    }

    private Multimap<Long, AbstractTestStepDto> fetchTestSteps(Condition condition) {
        Table keyWordTestStepTable = DSL.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID, (SelectField)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID, (SelectField)Tables.KEYWORD_TEST_STEP.KEYWORD, (SelectField)Tables.KEYWORD_TEST_STEP.DATATABLE, (SelectField)Tables.KEYWORD_TEST_STEP.DOCSTRING, (SelectField)Tables.KEYWORD_TEST_STEP.COMMENT, (SelectField)Tables.ACTION_WORD.PROJECT_ID, (SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.ACTION_WORD).on(Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD.ACTION_WORD_ID)).innerJoin((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).on(Tables.ACTION_WORD.ACTION_WORD_ID.eq((Field)Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_ID)).where(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)"ACTION_WORD")).asTable();
        SelectOnConditionStep baseSelect = this.dsl.select((SelectField)Tables.TEST_CASE_STEPS.STEP_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)ActionTestStep.ACTION_TEST_STEP.ACTION, (SelectField)ActionTestStep.ACTION_TEST_STEP.EXPECTED_RESULT, (SelectField)ActionTestStep.ACTION_TEST_STEP.ATTACHMENT_LIST_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_DATASET, (SelectField)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES, (SelectField)TestStepDisplayDaoImpl.CALLED_TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.DATASET.NAME, (SelectField)keyWordTestStepTable.field("TEST_STEP_ID"), (SelectField)keyWordTestStepTable.field("ACTION_WORD_ID"), (SelectField)keyWordTestStepTable.field("KEYWORD"), (SelectField)keyWordTestStepTable.field("DATATABLE"), (SelectField)keyWordTestStepTable.field("DOCSTRING"), (SelectField)keyWordTestStepTable.field("COMMENT"), (SelectField)keyWordTestStepTable.field("PROJECT_ID"), (SelectField)keyWordTestStepTable.field("AWLN_ID")).from((TableLike)Tables.TEST_CASE_STEPS).leftJoin((TableLike)ActionTestStep.ACTION_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)ActionTestStep.ACTION_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)CALLED_TEST_CASE).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)TestStepDisplayDaoImpl.CALLED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.CALL_TEST_STEP.CALLED_DATASET.eq((Field)Tables.DATASET.DATASET_ID)).leftJoin((TableLike)CALLED_TEST_CASE_LIBRARY_NODE).on(TestStepDisplayDaoImpl.CALLED_TEST_CASE.TCLN_ID.eq((Field)TestStepDisplayDaoImpl.CALLED_TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)keyWordTestStepTable).on(Tables.TEST_CASE_STEPS.STEP_ID.eq(keyWordTestStepTable.field("TEST_STEP_ID", Long.class)));
        List testStepDtos = baseSelect.where(condition).orderBy((OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetch(record -> {
            Long calledTestCaseId = (Long)record.get((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID);
            Long keywordTestStepId = (Long)record.get(DSL.field((String)"TEST_STEP_ID", Long.class));
            if (Objects.nonNull(calledTestCaseId)) {
                return this.createCallStep(record, calledTestCaseId);
            }
            if (Objects.nonNull(keywordTestStepId)) {
                return this.createKeywordStep(record);
            }
            return this.createActionStep(record);
        });
        ArrayListMultimap dtoMap = ArrayListMultimap.create();
        testStepDtos.forEach(testStepDto -> {
            boolean bl = dtoMap.put((Object)testStepDto.getTestCaseId(), testStepDto);
        });
        return dtoMap;
    }

    private AbstractTestStepDto createActionStep(Record record) {
        ActionTestStepDto actionTestStepDto = new ActionTestStepDto();
        this.setBaseAttributes(record, actionTestStepDto);
        actionTestStepDto.setAction((String)record.get((Field)ActionTestStep.ACTION_TEST_STEP.ACTION));
        actionTestStepDto.setExpectedResult((String)record.get((Field)ActionTestStep.ACTION_TEST_STEP.EXPECTED_RESULT));
        actionTestStepDto.setAttachmentListId((Long)record.get((Field)ActionTestStep.ACTION_TEST_STEP.ATTACHMENT_LIST_ID));
        return actionTestStepDto;
    }

    private CalledTestStepDto createCallStep(Record record, Long calledTestCaseId) {
        CalledTestStepDto calledTestStepDto = new CalledTestStepDto();
        this.setBaseAttributes(record, calledTestStepDto);
        calledTestStepDto.setCalledTcName((String)record.get((Field)TestStepDisplayDaoImpl.CALLED_TEST_CASE_LIBRARY_NODE.NAME));
        calledTestStepDto.setCalledTcId(calledTestCaseId);
        calledTestStepDto.setCalledDatasetId((Long)record.get((Field)Tables.CALL_TEST_STEP.CALLED_DATASET));
        calledTestStepDto.setDelegateParam((Boolean)record.get((Field)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES));
        calledTestStepDto.setCalledDatasetName((String)record.get((Field)Tables.DATASET.NAME));
        return calledTestStepDto;
    }

    private AbstractTestStepDto createKeywordStep(Record record) {
        KeywordTestStepDto keywordTestStepDto = new KeywordTestStepDto();
        this.setBaseAttributes(record, keywordTestStepDto);
        keywordTestStepDto.setActionWordId((Long)record.get(DSL.field((String)"ACTION_WORD_ID", Long.class)));
        keywordTestStepDto.setKeyword((String)record.get(DSL.field((String)"KEYWORD", String.class)));
        keywordTestStepDto.setDatatable((String)record.get(DSL.field((String)"DATATABLE", String.class)));
        keywordTestStepDto.setDocstring((String)record.get(DSL.field((String)"DOCSTRING", String.class)));
        keywordTestStepDto.setComment((String)record.get(DSL.field((String)"COMMENT", String.class)));
        keywordTestStepDto.setActionWordProjectId((Long)record.get(DSL.field((String)"PROJECT_ID", Long.class)));
        keywordTestStepDto.setActionWordLibraryNodeId((Long)record.get(DSL.field((String)"AWLN_ID", Long.class)));
        return keywordTestStepDto;
    }

    private void setBaseAttributes(Record record, AbstractTestStepDto stepDto) {
        stepDto.setId((Long)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ID));
        stepDto.setStepOrder((Integer)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ORDER));
        stepDto.setTestCaseId((Long)record.get((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID));
    }
}

