/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.RequirementNature;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CustomField;
import org.squashtest.tm.jooq.domain.tables.CustomFieldBinding;
import org.squashtest.tm.jooq.domain.tables.CustomFieldValue;
import org.squashtest.tm.jooq.domain.tables.CustomFieldValueOption;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.display.RequirementSearchDisplayDao;

@Repository
public class RequirementSearchDisplayDaoImpl
implements RequirementSearchDisplayDao {
    private static final String REQ_MILESTONE_LOCKED_ALIAS = "REQ_MILESTONE_LOCKED";
    private static final String REQUIREMENT_SEARCH = "requirement-search";
    private static final String TEST_CASE_LIST = "TEST_CASE_LIST";
    private static final String SPRINT_LIST = "SPRINT_LIST";
    private Requirement innerRequirement = Tables.REQUIREMENT.as("INNER_REQUIREMENT");
    private RequirementVersion innerVersions = Tables.REQUIREMENT_VERSION.as("INNER_VERSIONS");
    private Field<Long> innerRequirementId;
    private String versionCountAlias;
    private Field<Integer> versionsCount;
    SelectHavingStep<Record2<Long, Integer>> innerVersionSelect;
    private DSLContext jooq;
    private Table<Record> baseTable;
    private GroupField[] groupByFields;

    public RequirementSearchDisplayDaoImpl(DSLContext jooq) {
        this.innerRequirementId = this.innerRequirement.RLN_ID.as("INNER_REQUIREMENT_ID");
        this.versionCountAlias = "VERSIONS_COUNT";
        this.versionsCount = DSL.countDistinct((Field)this.innerVersions.RES_ID).as(this.versionCountAlias);
        this.innerVersionSelect = DSL.select(this.innerRequirementId, this.versionsCount).from((TableLike)this.innerRequirement).innerJoin((TableLike)this.innerVersions).on(this.innerRequirement.RLN_ID.eq((Field)this.innerVersions.REQUIREMENT_ID)).groupBy(new GroupField[]{this.innerRequirementId});
        this.baseTable = Tables.REQUIREMENT_VERSION.innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin(this.innerVersionSelect).on(this.innerRequirementId.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID));
        this.groupByFields = new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.RESOURCE.RES_ID, Tables.REQUIREMENT.RLN_ID, Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.PROJECT.PROJECT_ID, this.innerRequirementId, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID};
        this.jooq = jooq;
    }

    @Override
    public GridResponse getRows(List<Long> requirementVersionIds, GridRequest gridRequest) {
        GridResponse gridResponse = new GridResponse();
        SelectSelectStep selectBaseColumns = this.jooq.select(this.getFirstColumnsResults());
        List<String> simplifiedColumnDisplayGridIds = gridRequest.getSimplifiedColumnDisplayGridIds();
        this.appendCountDistinctFields((SelectSelectStep<Record>)selectBaseColumns, simplifiedColumnDisplayGridIds);
        this.appendCufFields((SelectSelectStep<Record>)selectBaseColumns, simplifiedColumnDisplayGridIds);
        selectBaseColumns.from(this.baseTable).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).groupBy(this.groupByFields).stream().forEach(recordData -> {
            DataRow dataRow = this.convertRecordIntoDataRow((Record)recordData);
            gridResponse.addDataRow(dataRow);
        });
        return gridResponse;
    }

    private SelectField<?>[] getFirstColumnsResults() {
        return new SelectField[]{Tables.REQUIREMENT_VERSION.RES_ID.as("ID"), Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.REQUIREMENT_VERSION.CATEGORY, Tables.REQUIREMENT_VERSION.VERSION_NUMBER, Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, Tables.RESOURCE.NAME, Tables.RESOURCE.CREATED_BY, Tables.RESOURCE.LAST_MODIFIED_BY, Tables.RESOURCE.LAST_MODIFIED_ON, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, Tables.RESOURCE.CREATED_ON, Tables.PROJECT.NAME.as("PROJECT_NAME"), DSL.groupConcat((Field)Tables.MILESTONE.LABEL).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_LABELS"), DSL.groupConcat((Field)Tables.MILESTONE.STATUS).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_STATUS"), DSL.groupConcat((Field)Tables.MILESTONE.END_DATE).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_END_DATE"), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField(TEST_CASE_LIST), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).from((TableLike)Tables.SPRINT_REQ_VERSION).where(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).asField(SPRINT_LIST), DSL.selectCount().from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.RESOURCE.ATTACHMENT_LIST_ID)).asField("ATTACHMENTS"), DSL.min(this.versionsCount).as(this.versionCountAlias), DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Object)RequirementNature.HIGH_LEVEL.toString()).otherwise((Object)RequirementNature.STANDARD.toString()).as("NATURE"), DSL.when((Condition)Tables.RESOURCE.DESCRIPTION.eq((Object)""), (Object)false).otherwise((Object)true).as("DESCRIPTION"), DSL.when((Condition)DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.RLN_RELATIONSHIP).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID))), (Object)true).otherwise((Object)false).as("HAS_PARENT"), DSL.selectCount().from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).asField("CHILD_OF_REQUIREMENT"), DSL.selectCount().from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).asField("LINKED_STANDARD_REQUIREMENT"), DSL.when((Condition)DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION_LINK).where(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID))), (Object)true).otherwise((Object)false).as("HAS_LINK_TYPE"), DSL.when((Condition)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.isNotNull(), (Object)true).otherwise((Object)false).as("REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT")};
    }

    private void appendCountDistinctFields(SelectSelectStep<Record> selectBaseColumns, List<String> simplifiedColumnDisplayGridIds) {
        if (!simplifiedColumnDisplayGridIds.contains(REQUIREMENT_SEARCH)) {
            selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).from((TableLike)Tables.MILESTONE_REQ_VERSION).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asField("MILESTONES"), DSL.select((SelectField)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID)).from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name())).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asField(REQ_MILESTONE_LOCKED_ALIAS), DSL.select((SelectField)DSL.countDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).asField("COVERAGES")});
        } else {
            selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.value(null).as("MILESTONES"), DSL.value(null).as(REQ_MILESTONE_LOCKED_ALIAS), DSL.value(null).as("COVERAGES")});
        }
    }

    private void appendCufFields(SelectSelectStep<Record> selectBaseColumns, List<String> simplifiedColumnDisplayGridIds) {
        List cufIds = this.jooq.selectDistinct((SelectField)CustomField.CUSTOM_FIELD.CF_ID).from((TableLike)CustomField.CUSTOM_FIELD).innerJoin((TableLike)CustomFieldBinding.CUSTOM_FIELD_BINDING).on(CustomField.CUSTOM_FIELD.CF_ID.eq((Field)CustomFieldBinding.CUSTOM_FIELD_BINDING.CF_ID)).where(CustomFieldBinding.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)EntityType.REQUIREMENT_VERSION.toString())).fetchInto(Long.class);
        if (!simplifiedColumnDisplayGridIds.contains(REQUIREMENT_SEARCH)) {
            for (Long cufId : cufIds) {
                selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.select((SelectField)DSL.when((Condition)CustomFieldValue.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)String.valueOf(InputType.TAG)), (Field)DSL.groupConcat((Field)CustomFieldValueOption.CUSTOM_FIELD_VALUE_OPTION.LABEL).orderBy(new OrderField[]{CustomFieldValueOption.CUSTOM_FIELD_VALUE_OPTION.POSITION}).separator(", ")).otherwise((Field)CustomFieldValue.CUSTOM_FIELD_VALUE.VALUE)).from((TableLike)CustomFieldValue.CUSTOM_FIELD_VALUE).leftOuterJoin((TableLike)CustomFieldValueOption.CUSTOM_FIELD_VALUE_OPTION).on(CustomFieldValue.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)CustomFieldValueOption.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(CustomFieldValue.CUSTOM_FIELD_VALUE.CF_ID.eq((Object)cufId)).and(CustomFieldValue.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).and(CustomFieldValue.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)EntityType.REQUIREMENT_VERSION.toString())).groupBy(new GroupField[]{CustomFieldValue.CUSTOM_FIELD_VALUE.FIELD_TYPE, CustomFieldValue.CUSTOM_FIELD_VALUE.VALUE}).asField("cuf|" + String.valueOf(cufId))});
            }
        } else {
            for (Long cufId : cufIds) {
                selectBaseColumns.select(new SelectFieldOrAsterisk[]{DSL.value(null).as("cuf|" + String.valueOf(cufId))});
            }
        }
    }

    private DataRow convertRecordIntoDataRow(Record record) {
        DataRow dataRow = new DataRow();
        dataRow.setId(record.get("ID").toString());
        dataRow.setProjectId((Long)record.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID));
        Map rawData = record.intoMap();
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry entry : rawData.entrySet()) {
            data.put(this.convertField((String)entry.getKey()), entry.getValue());
        }
        dataRow.setData(data);
        return dataRow;
    }

    private String convertField(String fieldName) {
        if (fieldName.startsWith("cuf|")) {
            return fieldName;
        }
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        return (String)converter.convert((Object)fieldName);
    }
}

