/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.PromptDto;
import org.squashtest.tm.service.internal.display.dto.PromptSetAdminViewDto;
import org.squashtest.tm.service.internal.repository.display.PromptSetDisplayDao;

@Repository
public class PromptSetDisplayDaoImpl
implements PromptSetDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public PromptSetAdminViewDto getPromptSetById(Long promptSetId) {
        PromptSetAdminViewDto dto = (PromptSetAdminViewDto)this.dsl.select((SelectField)Tables.PROMPT_SET.PROMPT_SET_ID.as("ID"), (SelectField)Tables.PROMPT_SET.NAME, (SelectField)Tables.PROMPT_SET.DESCRIPTION, (SelectField)Tables.AI_USAGE.USAGE.as("AI_USAGE"), (SelectField)Tables.PROMPT_SET.CREATED_ON, (SelectField)Tables.PROMPT_SET.CREATED_BY, (SelectField)Tables.PROMPT_SET.LAST_MODIFIED_ON, (SelectField)Tables.PROMPT_SET.LAST_MODIFIED_BY).from((TableLike)Tables.PROMPT_SET).innerJoin((TableLike)Tables.AI_USAGE).on(Tables.PROMPT_SET.AI_USAGE_ID.eq((Field)Tables.AI_USAGE.AI_USAGE_ID)).where(Tables.PROMPT_SET.PROMPT_SET_ID.eq((Object)promptSetId)).fetchOneInto(PromptSetAdminViewDto.class);
        Objects.requireNonNull(dto).setPrompts(this.getPromptsByPromptSetId(promptSetId));
        return dto;
    }

    private List<PromptDto> getPromptsByPromptSetId(Long promptSetId) {
        return this.dsl.select((SelectField)Tables.PROMPT.PROMPT_ID.as("ID"), (SelectField)Tables.PROMPT.NAME, (SelectField)Tables.PROMPT.SYSTEM_PROMPT_TEMPLATE, (SelectField)Tables.PROMPT.USER_PROMPT_TEMPLATE).from((TableLike)Tables.PROMPT).where(Tables.PROMPT.PROMPT_SET_ID.eq((Object)promptSetId)).groupBy(new GroupField[]{Tables.PROMPT.PROMPT_ID}).fetchInto(PromptDto.class);
    }
}

