/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record8;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.InfoListDto;
import org.squashtest.tm.service.internal.display.dto.InfoListItemAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.InfoListItemDto;
import org.squashtest.tm.service.internal.repository.display.InfoListDisplayDao;

@Repository
public class InfoListDisplayDaoImpl
implements InfoListDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<InfoListDto> findAllWithItems() {
        ArrayList<InfoListDto> infoListDtos = new ArrayList<InfoListDto>();
        Map record = this.dsl.select((SelectField)Tables.INFO_LIST.LABEL, (SelectField)Tables.INFO_LIST.CODE, (SelectField)Tables.INFO_LIST.DESCRIPTION, (SelectField)Tables.INFO_LIST.INFO_LIST_ID, (SelectField)Tables.INFO_LIST_ITEM.LABEL, (SelectField)Tables.INFO_LIST_ITEM.CODE, (SelectField)Tables.INFO_LIST_ITEM.IS_DEFAULT, (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME, (SelectField)Tables.INFO_LIST_ITEM.ITEM_ID, (SelectField)Tables.INFO_LIST_ITEM.ITEM_TYPE).from((TableLike)Tables.INFO_LIST).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST.INFO_LIST_ID.eq((Field)Tables.INFO_LIST_ITEM.LIST_ID)).orderBy((OrderField)Tables.INFO_LIST.INFO_LIST_ID, (OrderField)Tables.INFO_LIST_ITEM.ITEM_INDEX).fetch().intoGroups(Arrays.asList(Tables.INFO_LIST.LABEL, Tables.INFO_LIST.CODE, Tables.INFO_LIST.DESCRIPTION, Tables.INFO_LIST.INFO_LIST_ID).toArray(new Field[0]));
        record.entrySet().stream().forEach(entry -> {
            InfoListDto infoList = new InfoListDto();
            infoList.setLabel((String)((Record)entry.getKey()).get((Field)Tables.INFO_LIST.LABEL));
            infoList.setId((Long)((Record)entry.getKey()).get((Field)Tables.INFO_LIST.INFO_LIST_ID));
            infoList.setDescription((String)((Record)entry.getKey()).get((Field)Tables.INFO_LIST.DESCRIPTION));
            infoList.setCode((String)((Record)entry.getKey()).get((Field)Tables.INFO_LIST.CODE));
            infoListDtos.add(infoList);
            ((Result)entry.getValue()).stream().forEach(value -> {
                InfoListItemDto item = new InfoListItemDto();
                item.setLabel((String)value.get((Field)Tables.INFO_LIST_ITEM.LABEL));
                item.setCode((String)value.get((Field)Tables.INFO_LIST_ITEM.CODE));
                item.setIconName((String)value.get((Field)Tables.INFO_LIST_ITEM.ICON_NAME));
                item.setId((Long)value.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID));
                item.setDefault((Boolean)value.get((Field)Tables.INFO_LIST_ITEM.IS_DEFAULT));
                if ("SYS".equals(value.get((Field)Tables.INFO_LIST_ITEM.ITEM_TYPE))) {
                    item.setSystem(true);
                }
                infoList.getItems().add(item);
            });
        });
        return infoListDtos;
    }

    @Override
    public InfoListAdminViewDto getInfoListById(long infoListId) {
        InfoListAdminViewDto dto = (InfoListAdminViewDto)((Record8)this.dsl.select((SelectField)Tables.INFO_LIST.INFO_LIST_ID.as("ID"), (SelectField)Tables.INFO_LIST.CODE, (SelectField)Tables.INFO_LIST.LABEL, (SelectField)Tables.INFO_LIST.DESCRIPTION, (SelectField)Tables.INFO_LIST.CREATED_BY, (SelectField)Tables.INFO_LIST.CREATED_ON, (SelectField)Tables.INFO_LIST.LAST_MODIFIED_BY, (SelectField)Tables.INFO_LIST.LAST_MODIFIED_ON).from((TableLike)Tables.INFO_LIST).where(Tables.INFO_LIST.INFO_LIST_ID.eq((Object)infoListId)).fetchOne()).into(InfoListAdminViewDto.class);
        dto.setItems(this.getInfoListItemsByListId(infoListId));
        return dto;
    }

    private List<InfoListItemAdminViewDto> getInfoListItemsByListId(long infoListId) {
        return this.dsl.select((SelectField)Tables.INFO_LIST_ITEM.ITEM_ID.as("ID"), (SelectField)Tables.INFO_LIST_ITEM.CODE, (SelectField)Tables.INFO_LIST_ITEM.COLOUR, (SelectField)Tables.INFO_LIST_ITEM.LABEL, (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME, (SelectField)Tables.INFO_LIST_ITEM.ITEM_INDEX, (SelectField)Tables.INFO_LIST_ITEM.IS_DEFAULT, (SelectField)DSL.field((Condition)Tables.INFO_LIST_ITEM.ITEM_TYPE.eq((Object)"SYS")).as("SYSTEM")).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.LIST_ID.eq((Object)infoListId)).groupBy(new GroupField[]{Tables.INFO_LIST_ITEM.ITEM_ID}).orderBy((OrderField)Tables.INFO_LIST_ITEM.ITEM_INDEX).fetchInto(InfoListItemAdminViewDto.class);
    }
}

