/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.display.AutomationTesterRequestDisplayDao;

@Repository
public class AutomationTesterRequestDisplayDaoImpl
implements AutomationTesterRequestDisplayDao {
    private final DSLContext dsl;

    public AutomationTesterRequestDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public int countGlobalAutomationRequests(List<Long> projectIds) {
        Integer count = (Integer)this.baseRequest(projectIds).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public int countReadyForTransmissionAutomRequests(List<Long> projectIds) {
        Integer count = (Integer)this.baseRequest(projectIds).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.READY_TO_TRANSMIT.name())).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public int countToBeValidatedAutomRequests(List<Long> projectIds) {
        Integer count = (Integer)this.baseRequest(projectIds).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in((Object[])new String[]{AutomationRequestStatus.WORK_IN_PROGRESS.name(), AutomationRequestStatus.REJECTED.name(), AutomationRequestStatus.SUSPENDED.name()})).fetchOneInto(Integer.TYPE);
        return count != null ? count : 0;
    }

    @Override
    public List<String> getLastModifyingUserLoginsForTesterView(List<Long> projectIds, List<String> requestStatus) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).where(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.in(requestStatus)).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY);
    }

    private SelectConditionStep<?> baseRequest(List<Long> projectIds) {
        return this.dsl.selectCount().from((TableLike)Tables.AUTOMATION_REQUEST).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.AUTOMATION_REQUEST.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.AUTOMATION_REQUEST.PROJECT_ID.in(projectIds).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)"Y")).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NATIVE.name())));
    }
}

