/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.InfoListPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.InfoListPivotDao;

@Service
public class InfoListPivotExporterServiceImpl
implements InfoListPivotExporterService {
    private final InfoListPivotDao infoListPivotDao;
    private final PivotFileManager pivotFileManager;

    public InfoListPivotExporterServiceImpl(InfoListPivotDao infoListPivotDao, PivotFileManager pivotFileManager) {
        this.infoListPivotDao = infoListPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateInfoListsJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        if (!this.infoListPivotDao.hasCustomInfoListBindingByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleInfoLists((JsonGenerator)jsonGenerator, projectId, pivotMetaDataModel), JsonImportFile.INFO_LISTS, archive);
        this.provideSystemInfoList(pivotMetaDataModel.getInfoListCodeByBindingType(), InfoListProjectBindingType.REQUIREMENT_CATEGORY);
        this.provideSystemInfoList(pivotMetaDataModel.getInfoListCodeByBindingType(), InfoListProjectBindingType.TEST_CASE_NATURE);
        this.provideSystemInfoList(pivotMetaDataModel.getInfoListCodeByBindingType(), InfoListProjectBindingType.TEST_CASE_TYPE);
    }

    private void handleInfoLists(JsonGenerator jsonGenerator, Long projectId, PivotMetaDataModel pivotMetaDataModel) {
        this.infoListPivotDao.getCustomInfoListByProjectId(projectId, infoListPivot -> {
            pivotMetaDataModel.addInfoListCodeByBindingType(infoListPivot.getPivotId(), infoListPivot.getCode());
            this.pivotFileManager.writePivotObject(infoListPivot, jsonGenerator, JsonImportFile.INFO_LISTS);
        });
    }

    private void provideSystemInfoList(Map<InfoListProjectBindingType, String> infoListCodesByBindingType, InfoListProjectBindingType bindingType) {
        infoListCodesByBindingType.computeIfAbsent(bindingType, k -> bindingType.getSystemInfoListCode().getCode());
    }
}

