/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.environmentvariable;

import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableBinding;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.domain.environmentvariable.SingleSelectEnvironmentVariable;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingValueService;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableBindingDao;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;

@Service
@Transactional
public class EnvironmentVariableBindingValueServiceImpl
implements EnvironmentVariableBindingValueService {
    private final ProjectDisplayDao projectDisplayDao;
    private final EnvironmentVariableBindingDao environmentVariableBindingDao;
    private final EnvironmentVariableDao environmentVariableDao;

    public EnvironmentVariableBindingValueServiceImpl(ProjectDisplayDao projectDisplayDao, EnvironmentVariableBindingDao environmentVariableBindingDao, EnvironmentVariableDao environmentVariableDao) {
        this.projectDisplayDao = projectDisplayDao;
        this.environmentVariableBindingDao = environmentVariableBindingDao;
        this.environmentVariableDao = environmentVariableDao;
    }

    @Override
    public void editEnvironmentVariableValue(Long bindingId, String value) {
        EnvironmentVariableBinding binding = (EnvironmentVariableBinding)this.environmentVariableBindingDao.getReferenceById(bindingId);
        this.checkValueIsValidOption(binding.getEnvironmentVariable().getId(), value);
        binding.updateValue(value);
    }

    private void checkValueIsValidOption(Long environmentVariableId, String value) {
        SingleSelectEnvironmentVariable environmentVariable = this.environmentVariableDao.findSingleSelectEnvironmentVariableById(environmentVariableId);
        if (environmentVariable != null) {
            List<String> values = environmentVariable.getOptions().stream().map(EnvironmentVariableOption::getLabel).toList();
            if (StringUtils.hasText((String)value) && !values.contains(value)) {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String resetDefaultValue(Long bindingId, String entityType) {
        EnvironmentVariableBinding binding = (EnvironmentVariableBinding)this.environmentVariableBindingDao.getReferenceById(bindingId);
        if (EVBindableEntity.PROJECT.name().equals(entityType)) {
            this.setProjectValueFromExistingServerValue(binding);
        }
        return binding.getValue();
    }

    @Override
    public void setProjectValueFromExistingServerValue(EnvironmentVariableBinding binding) {
        EnvironmentVariableBinding serverBinding;
        Long testAutomationServerId = this.projectDisplayDao.getTaServerIdByProjectId(binding.getEntityId());
        if (Objects.nonNull(testAutomationServerId) && Objects.nonNull(serverBinding = this.environmentVariableBindingDao.findByEntityIdTypeAndEvId(testAutomationServerId, EVBindableEntity.TEST_AUTOMATION_SERVER, binding.getEnvironmentVariable().getId()))) {
            binding.setValue(serverBinding.getValue());
        }
    }

    @Override
    public void reinitializeEnvironmentVariableValuesByValueAndEvId(List<String> values, Long environmentVariableId) {
        this.findAndReplaceBindingValues(environmentVariableId, values, "");
    }

    @Override
    public void replaceAllExistingValuesByEvId(Long environmentVariableId, String oldValue, String newValue) {
        this.findAndReplaceBindingValues(environmentVariableId, Collections.singletonList(oldValue), newValue);
    }

    private void findAndReplaceBindingValues(Long environmentVariableId, List<String> oldValues, String newValue) {
        List<EnvironmentVariableBinding> environmentVariableBindings = this.environmentVariableBindingDao.findAllByEvIdAndValues(environmentVariableId, oldValues);
        environmentVariableBindings.forEach(binding -> binding.setValue(newValue));
    }
}

