/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.display.search.TestCaseThroughRequirementSearchService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.search.TestCaseThroughRequirementGrid;
import org.squashtest.tm.service.internal.display.search.RequirementSearchServiceImpl;

@Service
@Transactional(readOnly=true)
public class TestCaseThroughRequirementSearchServiceImpl
implements TestCaseThroughRequirementSearchService {
    private final DSLContext dslContext;
    private final RequirementSearchServiceImpl requirementSearchService;

    public TestCaseThroughRequirementSearchServiceImpl(DSLContext dslContext, RequirementSearchServiceImpl requirementSearchService) {
        this.dslContext = dslContext;
        this.requirementSearchService = requirementSearchService;
    }

    @Override
    public ResearchResult search(GridRequest request) {
        Map<EntityType, List<Long>> entityReferenceFromScope = this.requirementSearchService.getEntityReferenceFromScope(request);
        TestCaseThroughRequirementGrid testCaseThroughRequirementGrid = new TestCaseThroughRequirementGrid(entityReferenceFromScope);
        GridResponse gridResponse = testCaseThroughRequirementGrid.getRows(request, this.dslContext);
        List<Long> testcaseIds = gridResponse.getDataRows().stream().mapToLong(row -> Long.parseLong(row.getId())).boxed().toList();
        return new ResearchResult(testcaseIds, gridResponse.getCount());
    }
}

