/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;

public class RemoteSynchronisationDto {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteSynchronisationDto.class);
    private long id;
    private String name;
    private boolean isEnabled;
    private long serverId;
    private String serverName;
    private long projectId;
    private String projectName;
    private String perimeter;
    private String remoteSelectType;
    private String remoteSelectValue;
    private SynchronisationStatus status;
    private Date lastSyncDate;
    private Date lastSuccessfulSyncDate;
    private String syncErrorLogFilePath;
    private Integer synchronizedRequirementsCount;
    private Integer unprocessedRequirementsCount;
    private Integer synchronizedSprintTicketsCount;
    private Integer unprocessedSprintTicketsCount;

    public RemoteSynchronisationDto(RemoteSynchronisation remoteSync) {
        this.id = remoteSync.getId();
        this.name = remoteSync.getName();
        this.isEnabled = remoteSync.isSynchronisationEnable();
        this.serverId = remoteSync.getServer().getId();
        this.serverName = remoteSync.getServer().getName();
        this.projectId = remoteSync.getProject().getId();
        this.projectName = remoteSync.getProject().getName();
        this.perimeter = this.getStringOption(remoteSync, "perimeter");
        this.remoteSelectType = remoteSync.getSelectType();
        this.remoteSelectValue = remoteSync.getSelectValue();
        this.status = remoteSync.getSynchronisationStatus();
        this.lastSyncDate = remoteSync.getLastSyncDate();
        this.lastSuccessfulSyncDate = remoteSync.getLastSuccessfulSyncDate();
        this.synchronizedRequirementsCount = this.getIntegerOption(remoteSync, "synchronizedRequirementsCount");
        this.unprocessedRequirementsCount = this.getIntegerOption(remoteSync, "unprocessedRequirementsCount");
        this.synchronizedSprintTicketsCount = this.getIntegerOption(remoteSync, "synchronizedSprintTicketsCount");
        this.unprocessedSprintTicketsCount = this.getIntegerOption(remoteSync, "unprocessedSprintTicketsCount");
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPerimeter() {
        return this.perimeter;
    }

    public void setPerimeter(String perimeter) {
        this.perimeter = perimeter;
    }

    public String getRemoteSelectType() {
        return this.remoteSelectType;
    }

    public void setRemoteSelectType(String remoteSelectType) {
        this.remoteSelectType = remoteSelectType;
    }

    public String getRemoteSelectValue() {
        return this.remoteSelectValue;
    }

    public void setRemoteSelectValue(String remoteSelectValue) {
        this.remoteSelectValue = remoteSelectValue;
    }

    public SynchronisationStatus getStatus() {
        return this.status;
    }

    public void setStatus(SynchronisationStatus status) {
        this.status = status;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public Date getLastSuccessfulSyncDate() {
        return this.lastSuccessfulSyncDate;
    }

    public void setLastSuccessfulSyncDate(Date lastSuccessfulSyncDate) {
        this.lastSuccessfulSyncDate = lastSuccessfulSyncDate;
    }

    public Integer getSynchronizedRequirementsCount() {
        return this.synchronizedRequirementsCount;
    }

    public Integer getUnprocessedRequirementsCount() {
        return this.unprocessedRequirementsCount;
    }

    public Integer getSynchronizedSprintTicketsCount() {
        return this.synchronizedSprintTicketsCount;
    }

    public Integer getUnprocessedSprintTicketsCount() {
        return this.unprocessedSprintTicketsCount;
    }

    private Integer getIntegerOption(RemoteSynchronisation remoteSynchronisation, String optionKey) {
        JsonNode synchronisationOption = this.getSynchronisationOption(remoteSynchronisation, optionKey);
        return synchronisationOption != null ? Integer.valueOf(synchronisationOption.asInt()) : null;
    }

    private String getStringOption(RemoteSynchronisation remoteSynchronisation, String optionKey) {
        JsonNode synchronisationOption = this.getSynchronisationOption(remoteSynchronisation, optionKey);
        return synchronisationOption != null ? synchronisationOption.asText() : null;
    }

    private JsonNode getSynchronisationOption(RemoteSynchronisation remoteSynchronisation, String optionKey) {
        try {
            if (remoteSynchronisation.getOptions() != null) {
                JsonNode optionsNode = new ObjectMapper().readTree(remoteSynchronisation.getOptions());
                return optionsNode.get(optionKey);
            }
            return null;
        }
        catch (IOException ioException) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("Could not deserialize perimeter for synchronisation %d", remoteSynchronisation.getId()), new Object[0]);
            }
            throw new IllegalArgumentException(ioException);
        }
    }

    public String getSyncErrorLogFilePath() {
        return this.syncErrorLogFilePath;
    }

    public void setSyncErrorLogFilePath(String syncErrorLogFilePath) {
        this.syncErrorLogFilePath = syncErrorLogFilePath;
    }
}

