/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import java.util.Map;
import java.util.Set;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.campaign.AbstractSuccessRateCalculator;

@Component
@Scope(value="prototype")
public class SprintReqTestPlanItemSuccessRateCalculator
extends AbstractSuccessRateCalculator {
    public SprintReqTestPlanItemSuccessRateCalculator(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected Map<Long, Float> createRateByDataRowIdMap(Set<Long> testPlanItemIds) {
        Field executionId = this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).orderBy((OrderField)Tables.EXECUTION.EXECUTION_ORDER.desc()).limit((Number)1).asField("EXECUTION_ID");
        CommonTableExpression executionCTE = DSL.name((String)"LAST_EXEC").fields("TEST_PLAN_ITEM_ID", "EXECUTION_ID").as((ResultQuery)this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)executionId).from((TableLike)Tables.TEST_PLAN_ITEM).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanItemIds)));
        Field successRate = DSL.sum((Field)DSL.when((Condition)Tables.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)ExecutionStatus.SUCCESS.name()), (Object)1)).cast(Float.class).mul((Number)100).div(DSL.when((Condition)DSL.count().eq((Object)0), (Object)1).otherwise((Field)DSL.count())).as("SUCCESS_RATE");
        Field testPlanItemId = executionCTE.field("TEST_PLAN_ITEM_ID", Long.class);
        return this.dslContext.with(new CommonTableExpression[]{executionCTE}).select((SelectField)testPlanItemId, (SelectField)successRate).from((TableLike)executionCTE).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(executionCTE.field("EXECUTION_ID", Long.class))).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).groupBy(new GroupField[]{testPlanItemId}).orderBy((OrderField)testPlanItemId).fetchMap(testPlanItemId, successRate);
    }
}

