/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectOrderByStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

public abstract class AbstractExecutionDeletionHandler
extends AbstractJdbcDeletionHandler {
    protected AbstractExecutionDeletionHandler(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
    }

    protected abstract Condition getPredicate();

    protected abstract Table<Record> joinToExecution();

    private Table<Record> joinToAutomatedExecutionExtender() {
        return this.joinToExecution().innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID));
    }

    private Table<Record> joinToAutomatedExecutionExtenderFailureDetail() {
        return this.joinToExecution().innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID));
    }

    private Table<Record> joinToExecutionDfv() {
        return this.joinToExecution().innerJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID).and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION.name())));
    }

    private Table<Record> joinToExecutionStep() {
        return this.joinToExecution().innerJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID));
    }

    private Table<Record> joinToExecutionStepDfv() {
        return this.joinToExecutionStep().innerJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID).and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)DenormalizedFieldHolderType.EXECUTION_STEP.name())));
    }

    private Table<Record> joinToDenormalizedEnvironmentVariable() {
        return this.joinToAutomatedExecutionExtender().innerJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).on(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID));
    }

    private Table<Record> joinToDenormalizedEnvironmentTag() {
        return this.joinToAutomatedExecutionExtender().innerJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID));
    }

    protected SelectOrderByStep<Record3<Long, String, String>> selectExecutionCustomFieldValues() {
        return this.makeSelectCustomFieldValues(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, BindableEntity.EXECUTION_STEP).union(this.makeSelectCustomFieldValues(Tables.EXECUTION.EXECUTION_ID, BindableEntity.EXECUTION));
    }

    protected SelectOrderByStep<Record3<Long, String, String>> selectExecutionAttachmentLists() {
        return this.makeSelectAttachmentList(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID).union(this.makeSelectAttachmentList(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.ATTACHMENT_LIST_ID));
    }

    protected void storeExecutionsToDeleteIntoWorkingTable() {
        this.addDenormalizedCustomFieldValues();
        this.addDenormalizedEnvironmentVariables();
        this.addDenormalizedEnvironmentTags();
        this.addExecutionSteps();
        this.addIssueLists();
        this.addExecutions();
        this.addAutomatedExecutionExtenderFailureDetails();
    }

    private void addDenormalizedCustomFieldValues() {
        this.workingTables.addEntity(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID).from(this.joinToExecutionStepDfv()).where(this.getPredicate()).union((Select)this.makeSelectClause(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID).from(this.joinToExecutionDfv()).where(this.getPredicate())));
    }

    private void addDenormalizedEnvironmentVariables() {
        this.workingTables.addEntity(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID).from(this.joinToDenormalizedEnvironmentVariable()).where(this.getPredicate()));
    }

    private void addDenormalizedEnvironmentTags() {
        this.workingTables.addEntity(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID, () -> this.makeSelectClause(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID).from(this.joinToDenormalizedEnvironmentTag()).where(this.getPredicate()));
    }

    private void addExecutionSteps() {
        this.workingTables.addEntity(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, () -> this.makeSelectClause(Tables.EXECUTION_STEP.EXECUTION_STEP_ID).from(this.joinToExecutionStep()).where(this.getPredicate()));
    }

    private void addExecutions() {
        this.workingTables.addEntity(Tables.EXECUTION.EXECUTION_ID, () -> this.makeSelectClause(Tables.EXECUTION.EXECUTION_ID).from(this.joinToExecution()).where(this.getPredicate()));
    }

    private void addAutomatedExecutionExtenderFailureDetails() {
        this.workingTables.addEntity(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, () -> this.makeSelectClause(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID).from(this.joinToAutomatedExecutionExtenderFailureDetail()).where(this.getPredicate()));
    }

    private void addIssueLists() {
        this.workingTables.addEntity(Tables.ISSUE_LIST.ISSUE_LIST_ID, () -> this.makeSelectClause(Tables.ISSUE_LIST.ISSUE_LIST_ID).from((TableLike)Tables.ISSUE_LIST).innerJoin(this.joinToExecution()).on(Tables.EXECUTION.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).where(this.getPredicate()).union((Select)this.makeSelectClause(Tables.ISSUE_LIST.ISSUE_LIST_ID).from((TableLike)Tables.ISSUE_LIST).innerJoin(this.joinToExecutionStep()).on(Tables.EXECUTION_STEP.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).where(this.getPredicate())));
    }

    protected void performExecutionDeletions() {
        this.deleteAutomatedExecutionFailureDetails();
        this.deleteDenormalizedCustomFieldValues();
        this.deleteDenormalizedEnvironmentVariables();
        this.deleteDenormalizedEnvironmentTags();
        this.deleteExecutionSteps();
        this.deleteKeywordExecution();
        this.deleteExecutions();
        this.deleteIssueLists();
    }

    private void deleteAutomatedExecutionFailureDetails() {
        this.workingTables.delete(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID);
    }

    private void deleteDenormalizedCustomFieldValues() {
        this.workingTables.delete(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID);
        this.workingTables.delete(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID, Tables.DENORMALIZED_FIELD_VALUE.DFV_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_FIELD_VALUE);
    }

    private void deleteDenormalizedEnvironmentVariables() {
        this.workingTables.delete(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID, Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE);
    }

    private void deleteDenormalizedEnvironmentTags() {
        this.workingTables.delete(Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID, Tables.DENORMALIZED_ENVIRONMENT_TAG.DET_ID);
        this.logDelete((Table<?>)Tables.DENORMALIZED_ENVIRONMENT_TAG);
    }

    private void deleteExecutionSteps() {
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION_STEP.EXECUTION_STEP_ID, Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
        this.logDelete((Table<?>)Tables.EXECUTION_STEP);
    }

    private void deleteKeywordExecution() {
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.KEYWORD_EXECUTION.EXECUTION_ID);
        this.logDelete((Table<?>)Tables.KEYWORD_EXECUTION);
    }

    private void deleteExecutions() {
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.SCRIPTED_EXECUTION.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.SESSION_NOTE.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION.EXECUTION_ID);
        this.workingTables.delete(Tables.EXECUTION.EXECUTION_ID, Tables.EXECUTION.EXECUTION_ID);
        this.logDelete((Table<?>)Tables.EXECUTION);
    }

    private void deleteIssueLists() {
        this.workingTables.delete(Tables.ISSUE_LIST.ISSUE_LIST_ID, Tables.ISSUE.ISSUE_LIST_ID);
        this.workingTables.delete(Tables.ISSUE_LIST.ISSUE_LIST_ID, Tables.ISSUE_LIST.ISSUE_LIST_ID);
        this.logDelete((Table<?>)Tables.ISSUE_LIST);
    }
}

