/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier.copyloading;

import java.util.Map;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingEntities;
import org.squashtest.tm.service.internal.repository.EntityDao;

@Transactional
public abstract class AbstractCopyLoadingEntities<CONTAINER, NODE extends TreeNode>
implements CopyLoadingEntities<CONTAINER, NODE> {
    protected final Class<CONTAINER> containerClass;
    protected final Class<NODE> nodeClass;
    protected final Map<EntityType, EntityDao<?>> daoProviderMap;
    protected final ClipboardPayload clipboardPayload;

    protected AbstractCopyLoadingEntities(Class<CONTAINER> containerClass, Class<NODE> nodeClass, Map<EntityType, EntityDao<?>> daoProviderMap, ClipboardPayload clipboardPayload) {
        this.containerClass = containerClass;
        this.nodeClass = nodeClass;
        this.daoProviderMap = daoProviderMap;
        this.clipboardPayload = clipboardPayload;
    }

    protected <E> EntityDao<E> getDaoFromNodeClass(String clazzSimpleName, Map<EntityType, EntityDao<?>> daoProviderMap) {
        EntityType entityType = EntityType.fromSimpleName((String)clazzSimpleName);
        if (daoProviderMap.containsKey(entityType)) {
            return daoProviderMap.get(entityType);
        }
        throw new IllegalArgumentException(String.format("No DAO found for node class: %s", clazzSimpleName));
    }
}

