/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.copier.TestCaseWorkspaceStrategyCopierService;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingBasicEntities;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingRequirementToTestCase;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;

@Service
@Transactional
public class TestCaseWorkspaceStrategyCopierServiceImpl
implements TestCaseWorkspaceStrategyCopierService {
    private final StrategyCopierService strategyCopierService;
    private final Map<EntityType, EntityDao<?>> daoProviderMap;
    private final RequirementDao requirementDao;
    private final CustomTestCaseDao testCaseDao;
    private final TestCaseLibraryDao testCaseLibraryDao;
    private final TestCaseFolderDao testCaseFolderDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;

    public TestCaseWorkspaceStrategyCopierServiceImpl(StrategyCopierService strategyCopierService, RequirementDao requirementDao, CustomTestCaseDao testCaseDao, TestCaseLibraryDao testCaseLibraryDao, TestCaseFolderDao testCaseFolderDao, ActiveMilestoneHolder activeMilestoneHolder) {
        this.strategyCopierService = strategyCopierService;
        this.requirementDao = requirementDao;
        this.testCaseDao = testCaseDao;
        this.testCaseLibraryDao = testCaseLibraryDao;
        this.testCaseFolderDao = testCaseFolderDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.daoProviderMap = this.getDaoProviderMap();
    }

    private Map<EntityType, EntityDao<?>> getDaoProviderMap() {
        return Map.of(EntityType.REQUIREMENT, this.requirementDao, EntityType.TEST_CASE_LIBRARY, this.testCaseLibraryDao, EntityType.TEST_CASE_FOLDER, this.testCaseFolderDao, EntityType.TEST_CASE, this.testCaseDao);
    }

    @Override
    public Map<NodeType, List<Long>> verifyPermission(ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.strategyCopierService.getNodeIdsByNodeTypeToPaste(clipboardPayload);
        this.strategyCopierService.verifyPermission(nodePastes);
        return nodePastes;
    }

    @Override
    public void copyRequirementsToTestCaseLibrary(Long destinationId, ClipboardPayload clipboardPayload, ReqToTestCaseConfiguration configuration) {
        NodeCopierDto nodeCopierDto = this.getNodeCopierDto(configuration);
        nodeCopierDto.setTestCaseKind(configuration.getTestCaseKindAsString());
        CopyLoadingRequirementToTestCase<TestCaseLibrary> copyLoadingEntities = new CopyLoadingRequirementToTestCase<TestCaseLibrary>(TestCaseLibrary.class, this.daoProviderMap, clipboardPayload, this.requirementDao, this.activeMilestoneHolder, nodeCopierDto);
        this.strategyCopierService.copyNodeToContainer(destinationId, copyLoadingEntities, nodeCopierDto);
    }

    @Override
    public void copyRequirementsToTestCaseFolder(Long destinationId, ClipboardPayload clipboardPayload, ReqToTestCaseConfiguration configuration) {
        NodeCopierDto nodeCopierDto = this.getNodeCopierDto(configuration);
        CopyLoadingRequirementToTestCase<TestCaseFolder> copyLoadingEntities = new CopyLoadingRequirementToTestCase<TestCaseFolder>(TestCaseFolder.class, this.daoProviderMap, clipboardPayload, this.requirementDao, this.activeMilestoneHolder, nodeCopierDto);
        this.strategyCopierService.copyNodeToContainer(destinationId, copyLoadingEntities, nodeCopierDto);
    }

    @Override
    public void copyNode(Long destinationId, Class<?> destinationClazz, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes) {
        this.copyNodeToContainer(destinationId, clipboardPayload, nodePastes, destinationClazz);
    }

    private <C> void copyNodeToContainer(Long destinationId, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes, Class<C> containerClass) {
        nodePastes.forEach((nodeType, nodeIds) -> {
            switch (nodeType) {
                case TEST_CASE_FOLDER: {
                    this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities(containerClass, TestCaseFolder.class, this.daoProviderMap, clipboardPayload));
                    break;
                }
                case TEST_CASE: {
                    this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities(containerClass, TestCase.class, this.daoProviderMap, clipboardPayload));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Node type %s is not supported for copy and paste in a test case folder".formatted(nodeType));
                }
            }
        });
    }

    private NodeCopierDto getNodeCopierDto(ReqToTestCaseConfiguration configuration) {
        NodeCopierDto nodeCopierDto = new NodeCopierDto();
        nodeCopierDto.setTestCaseKind(configuration.getTestCaseKindAsString());
        return nodeCopierDto;
    }
}

