/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.copier.BoundEntityCopy;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.testcase.NatureTypeChainFixer;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;

public class NodeCopierVisitor
implements NodeVisitor {
    private static final String UNCHECKED = "unchecked";
    private final EntityManager entityManager;
    private final AttachmentManagerService attachmentManagerService;
    private final MilestoneMembershipManager milestoneMembershipManager;
    private NodeContainer<? extends TreeNode> destination;
    private final String copySuffix;
    private final Map<String, Map<Long, Long>> pairingIdsSourceCopyNode;
    private final NodeCopierDto nodeCopierDto;
    private final List<BoundEntityCopy> boundEntityCopies = new ArrayList<BoundEntityCopy>();
    private final List<BoundEntityCopy> boundEntityCopiesProjectChanged = new ArrayList<BoundEntityCopy>();
    private final Map<BindableEntity, List<BoundEntity>> boundEntityCreation = new HashMap<BindableEntity, List<BoundEntity>>();
    private boolean projectChanged = false;

    public NodeCopierVisitor(EntityManager entityManager, AttachmentManagerService attachmentManagerService, MilestoneMembershipManager milestoneMembershipManager, NodeContainer<? extends TreeNode> destination, String copySuffix, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode, NodeCopierDto nodeCopierDto) {
        this.entityManager = entityManager;
        this.attachmentManagerService = attachmentManagerService;
        this.milestoneMembershipManager = milestoneMembershipManager;
        this.destination = destination;
        this.copySuffix = copySuffix;
        this.pairingIdsSourceCopyNode = pairingIdsSourceCopyNode;
        this.nodeCopierDto = nodeCopierDto;
    }

    public void setDestination(NodeContainer<? extends TreeNode> destination) {
        this.destination = destination;
    }

    public void setProjectChanged(boolean projectChanged) {
        this.projectChanged = projectChanged;
    }

    public List<BoundEntityCopy> getBoundEntityCopies() {
        return this.boundEntityCopies;
    }

    public List<BoundEntityCopy> getBoundEntityCopiesProjectChanged() {
        return this.boundEntityCopiesProjectChanged;
    }

    public Map<BindableEntity, List<BoundEntity>> getBoundEntityCreation() {
        return this.boundEntityCreation;
    }

    public void performCopy(TreeNode node) {
        node.accept((NodeVisitor)this);
    }

    public void visit(Campaign source) {
        Campaign copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Campaign)copy).setDescription(arg_0));
        this.migrateMilestonesIfProjectChanged((MilestoneHolder)copy);
        this.entityManager.persist((Object)copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(Iteration source) {
        Iteration copy = this.copyNode(source, this.destination);
        this.addCustomFieldIteration(source, copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Iteration)copy).setDescription(arg_0));
        copy.migrateTestPlan(this.destination.getProject().getCampaignLibrary());
        this.entityManager.persist((Object)copy);
    }

    public void visit(TestSuite source) {
        TestSuite copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((TestSuite)copy).setDescription(arg_0));
        this.addTestPlanToTestSuiteCopy((Iteration)this.destination, source, copy);
        this.entityManager.persist((Object)copy);
    }

    private void addTestPlanToTestSuiteCopy(Iteration iteration, TestSuite source, TestSuite copy) {
        List<TestPlanItem> copyOfTestPlan = source.getTestPlanItems().stream().filter(testPlanItem -> !testPlanItem.isTestCaseDeleted()).map(testPlanItem -> testPlanItem.createCopy(iteration.getTestPlan())).toList();
        iteration.getTestPlan().addTransientItems(copyOfTestPlan);
        copy.bindTestPlanItems(copyOfTestPlan, iteration);
    }

    public void visit(Sprint source) {
        Sprint copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((Sprint)copy).setDescription(arg_0));
        if (this.projectChanged) {
            copy.migrateTestPlans();
        }
        this.entityManager.persist((Object)copy);
    }

    public void visit(SprintGroup source) {
        SprintGroup copy = this.copyNode(source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((SprintGroup)copy).setDescription(arg_0));
        this.entityManager.persist((Object)copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(Requirement source) {
        if (!Objects.nonNull(this.nodeCopierDto.getTestCaseKind())) {
            throw new UnsupportedOperationException("Copy of Requirement is not supported");
        }
        this.copyRequirementToTestCase(source, this.nodeCopierDto);
    }

    private void copyRequirementToTestCase(Requirement source, NodeCopierDto nodeCopierDto) {
        TestCase testCase = this.createTestCaseFromRequirement(source, nodeCopierDto);
        this.addNodeToContainer(testCase, this.destination);
        NatureTypeChainFixer.fix(testCase);
        this.entityManager.persist((Object)testCase);
        this.entityManager.persist((Object)new RequirementVersionCoverage(source, testCase));
        if (Objects.nonNull(nodeCopierDto.getActiveMilestone())) {
            this.milestoneMembershipManager.bindTestCaseToMilestones(testCase.getId(), Collections.singletonList(nodeCopierDto.getActiveMilestone().getId()));
        }
        if (!source.getContent().isEmpty()) {
            TestCaseFolder testCaseFolder = this.createTestCaseFolderFromRequirement(source);
            this.addNodeToContainer(testCaseFolder, this.destination);
            new NatureTypeChainFixer().fix(testCaseFolder);
            this.entityManager.persist((Object)testCaseFolder);
            this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), testCaseFolder.getId());
        }
    }

    private TestCase createTestCaseFromRequirement(Requirement source, NodeCopierDto nodeCopierDto) {
        TestCase testCase = TestCase.createFromRequirement((Requirement)source, (String)nodeCopierDto.getTestCaseKind());
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)testCase, source.getDescription(), arg_0 -> ((TestCase)testCase).setDescription(arg_0));
        this.addCustomFieldCreation((BoundEntity)testCase);
        return testCase;
    }

    private TestCaseFolder createTestCaseFolderFromRequirement(Requirement source) {
        TestCaseFolder testCaseFolder = TestCaseFolder.createFromRequirement((Requirement)source);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)testCaseFolder, source.getDescription(), arg_0 -> ((TestCaseFolder)testCaseFolder).setDescription(arg_0));
        this.addCustomFieldCreation((BoundEntity)testCaseFolder);
        return testCaseFolder;
    }

    public void visit(HighLevelRequirement source) {
        if (!Objects.nonNull(this.nodeCopierDto.getTestCaseKind())) {
            throw new UnsupportedOperationException("Copy of HighLevelRequirement is not supported");
        }
        this.copyRequirementToTestCase((Requirement)source, this.nodeCopierDto);
    }

    public void visit(TestCase source) {
        TestCase copy = this.copyNode(source, this.destination);
        this.handleNatureType(copy);
        this.handleCustomFieldAttachment(source, copy);
        this.migrateMilestonesIfProjectChanged((MilestoneHolder)copy);
        this.updateAutomationParams(copy);
        this.updateAutomationRequests(copy);
        this.entityManager.persist((Object)copy);
        this.copyCoverage(source, copy);
    }

    private void updateAutomationParams(TestCase copy) {
        if (!this.projectChanged) {
            return;
        }
        AutomatedTest copyAT = copy.getAutomatedTest();
        if (Objects.isNull(copyAT)) {
            return;
        }
        TestAutomationProject newTAProject = copy.getProject().findTestAutomationProjectByJob(copyAT.getProject());
        if (Objects.isNull(newTAProject)) {
            copy.removeAutomatedScript();
        } else {
            copy.setAutomatedTest(new AutomatedTest(copyAT.getName(), newTAProject));
        }
    }

    private void updateAutomationRequests(TestCase copy) {
        if (!this.projectChanged) {
            return;
        }
        AutomationRequest request = copy.getAutomationRequest();
        if (Objects.isNull(request)) {
            return;
        }
        Project project = copy.getProject();
        AutomationRequestLibrary formerLibrary = request.getLibrary();
        AutomationRequestLibrary newLibrary = project.getAutomationRequestLibrary();
        formerLibrary.removeContent(request);
        newLibrary.addContent(request);
        request.notifyAssociatedWithProject(project);
    }

    private void handleNatureType(TestCase copy) {
        this.infoListFixer(copy.getNature(), copy.getProject().getTestCaseNatures(), arg_0 -> ((TestCase)copy).setNature(arg_0));
        this.infoListFixer(copy.getType(), copy.getProject().getTestCaseTypes(), arg_0 -> ((TestCase)copy).setType(arg_0));
    }

    private void handleCustomFieldAttachment(TestCase source, TestCase copy) {
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> ((TestCase)copy).setDescription(arg_0));
        this.updateRichText(source.getAttachmentList(), copy.getAttachmentList(), source.getPrerequisite(), arg_0 -> ((TestCase)copy).setPrerequisite(arg_0));
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        if (source.getActionSteps().size() == copy.getActionSteps().size()) {
            int i = 0;
            while (i < source.getActionSteps().size()) {
                ActionTestStep sourceStep = (ActionTestStep)source.getActionSteps().get(i);
                ActionTestStep copyStep = (ActionTestStep)copy.getActionSteps().get(i);
                this.handleCustomFieldAttachment(sourceStep, copyStep);
                ++i;
            }
        }
    }

    private void handleCustomFieldAttachment(ActionTestStep source, ActionTestStep copy) {
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getAction(), arg_0 -> ((ActionTestStep)copy).setAction(arg_0));
        this.updateRichText(source.getAttachmentList(), copy.getAttachmentList(), source.getExpectedResult(), arg_0 -> ((ActionTestStep)copy).setExpectedResult(arg_0));
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
    }

    private void copyCoverage(TestCase source, TestCase copy) {
        List copies = source.createRequirementVersionCoveragesForCopy(copy);
        for (RequirementVersionCoverage coverage : copies) {
            this.entityManager.persist((Object)coverage);
        }
    }

    public <ENTITY extends LibraryNode> void visitFolder(Folder<ENTITY> source) {
        Folder<ENTITY> copy = this.copyNode((ENTITY)source, this.destination);
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        this.handleAttachment((AttachmentHolder)source, (AttachmentHolder)copy, source.getDescription(), arg_0 -> copy.setDescription(arg_0));
        this.entityManager.persist(copy);
        this.pairingIdsSourceCopyNode.computeIfAbsent(source.getClass().getSimpleName(), k -> new HashMap()).put(source.getId(), copy.getId());
    }

    public void visit(CampaignFolder source) {
        this.visitFolder((Folder)source);
    }

    public void visit(RequirementFolder source) {
        this.visitFolder((Folder)source);
    }

    public void visit(TestCaseFolder source) {
        this.visitFolder((Folder)source);
    }

    private <ENTITY extends TreeNode & Copiable> ENTITY copyNode(ENTITY source, NodeContainer<? extends TreeNode> destination) {
        TreeNode copyNode = (TreeNode)((Copiable)source).createCopy();
        return (ENTITY)this.addNodeToContainer(copyNode, destination);
    }

    private <ENTITY extends TreeNode & Copiable> ENTITY addNodeToContainer(ENTITY copyNode, NodeContainer<? extends TreeNode> destination) {
        NodeContainer<? extends TreeNode> container = destination;
        this.renameIfNeeded(copyNode, (NodeContainer<ENTITY>)container);
        container.addContentWithoutSet(copyNode);
        return copyNode;
    }

    protected <ENTITY extends TreeNode & Copiable> void renameIfNeeded(ENTITY copy, NodeContainer<ENTITY> destination) {
        String name = ((Copiable)copy).getName();
        if (destination.isContentNameAvailable(name)) {
            return;
        }
        String newName = LibraryUtils.generateUniqueCopyName(destination.getContentNames(), name, 255, this.copySuffix);
        ((Copiable)copy).setName(newName);
    }

    private void infoListFixer(InfoListItem currentItem, InfoList infoListTarget, Consumer<InfoListItem> setter) {
        if (Objects.isNull(currentItem) || !infoListTarget.contains(currentItem)) {
            setter.accept(infoListTarget.getDefaultItem());
        }
    }

    private void addCustomFieldCreation(BoundEntity boundEntity) {
        this.boundEntityCreation.computeIfAbsent(boundEntity.getBoundEntityType(), k -> new ArrayList()).add(boundEntity);
    }

    private void addCustomField(BoundEntity source, BoundEntity copy) {
        if (this.projectChanged) {
            this.boundEntityCopiesProjectChanged.add(new BoundEntityCopy(source.getId(), copy));
        } else {
            this.boundEntityCopies.add(new BoundEntityCopy(source.getId(), copy));
        }
    }

    private void addCustomFieldIteration(Iteration source, Iteration copy) {
        this.addCustomField((BoundEntity)source, (BoundEntity)copy);
        copy.getTestSuites().forEach(testSuiteCopy -> {
            TestSuite testSuiteSource = source.getTestSuiteByName(testSuiteCopy.getName());
            this.addCustomField((BoundEntity)testSuiteSource, (BoundEntity)testSuiteCopy);
        });
    }

    protected void handleAttachment(AttachmentHolder source, AttachmentHolder copy, String richText, Consumer<String> consumer) {
        this.entityManager.persist((Object)copy.getAttachmentList());
        this.attachmentManagerService.copyContentsOnExternalRepository(copy);
        this.updateRichText(source.getAttachmentList(), copy.getAttachmentList(), richText, consumer);
    }

    private void updateRichText(AttachmentList sourceList, AttachmentList copyList, String richText, Consumer<String> consumer) {
        if (StringUtils.isBlank((CharSequence)richText)) {
            return;
        }
        String updatedDescription = this.attachmentManagerService.handleRichTextAttachments(sourceList, copyList, richText);
        if (!richText.equals(updatedDescription)) {
            consumer.accept(updatedDescription);
        }
    }

    private void migrateMilestonesIfProjectChanged(MilestoneHolder member) {
        if (this.projectChanged) {
            List milestonesProject = this.destination.getProject().getMilestones();
            member.getMilestones().removeIf(m -> !milestonesProject.contains(m));
        }
    }
}

