/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.CampaignWorkspaceStrategyCopierService;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingBasicEntities;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingTestSuite;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;

@Service
@Transactional
public class CampaignWorkspaceStrategyCopierServiceImpl
implements CampaignWorkspaceStrategyCopierService {
    private final StrategyCopierService strategyCopierService;
    private final Map<EntityType, EntityDao<?>> daoProviderMap;
    private final CampaignLibraryDao campaignLibraryDao;
    private final CampaignFolderDao campaignFolderDao;
    private final CampaignDao campaignDao;
    private final IterationDao iterationDao;
    private final SprintDao sprintDao;
    private final TestSuiteDao testSuiteDao;
    private final HibernateSprintGroupDao sprintGroupDao;

    public CampaignWorkspaceStrategyCopierServiceImpl(StrategyCopierService strategyCopierService, CampaignLibraryDao campaignLibraryDao, CampaignFolderDao campaignFolderDao, CampaignDao campaignDao, IterationDao iterationDao, SprintDao sprintDao, TestSuiteDao testSuiteDao, HibernateSprintGroupDao sprintGroupDao) {
        this.strategyCopierService = strategyCopierService;
        this.campaignLibraryDao = campaignLibraryDao;
        this.campaignFolderDao = campaignFolderDao;
        this.campaignDao = campaignDao;
        this.iterationDao = iterationDao;
        this.sprintDao = sprintDao;
        this.testSuiteDao = testSuiteDao;
        this.sprintGroupDao = sprintGroupDao;
        this.daoProviderMap = this.getDaoProviderMap();
    }

    private Map<EntityType, EntityDao<?>> getDaoProviderMap() {
        return Map.of(EntityType.CAMPAIGN_LIBRARY, this.campaignLibraryDao, EntityType.CAMPAIGN_FOLDER, this.campaignFolderDao, EntityType.CAMPAIGN, this.campaignDao, EntityType.ITERATION, this.iterationDao, EntityType.SPRINT, this.sprintDao, EntityType.SPRINT_GROUP, this.sprintGroupDao);
    }

    @Override
    public NodeType verifyPermissionAndGetNodePaste(ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.strategyCopierService.getNodeIdsByNodeTypeToPaste(clipboardPayload);
        if (nodePastes.size() > 1) {
            throw new IllegalArgumentException("Only one type of node can be copied at a time");
        }
        this.strategyCopierService.verifyPermission(nodePastes);
        return (NodeType)nodePastes.keySet().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No node type found to paste"));
    }

    @Override
    public void copyNodeToCampaign(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        if (!NodeType.ITERATION.equals((Object)nodePaste)) {
            throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign", nodePaste.getTypeName()));
        }
        this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities<Campaign, Iteration>(Campaign.class, Iteration.class, this.daoProviderMap, clipboardPayload));
    }

    @Override
    public void copyNodeToIteration(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        if (!NodeType.TEST_SUITE.equals((Object)nodePaste)) {
            throw new IllegalArgumentException(String.format("Cannot paste %s in an iteration", nodePaste.getTypeName()));
        }
        this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingTestSuite(this.testSuiteDao, this.daoProviderMap, clipboardPayload));
    }

    @Override
    public void copyNodeToSpringGroup(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        Class<Sprint> nodeClass = switch (nodePaste) {
            case NodeType.SPRINT -> Sprint.class;
            case NodeType.CAMPAIGN_FOLDER -> CampaignFolder.class;
            default -> throw new IllegalArgumentException(String.format("Cannot paste %s in a sprint group", nodePaste.getTypeName()));
        };
        this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities<SprintGroup, Sprint>(SprintGroup.class, nodeClass, this.daoProviderMap, clipboardPayload));
    }

    @Override
    public void copyNodeToCampaignFolder(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        Class<Sprint> nodeClass = switch (nodePaste) {
            case NodeType.SPRINT -> Sprint.class;
            case NodeType.SPRINT_GROUP -> SprintGroup.class;
            case NodeType.CAMPAIGN -> Campaign.class;
            case NodeType.CAMPAIGN_FOLDER -> CampaignFolder.class;
            default -> throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign folder", nodePaste.getTypeName()));
        };
        this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities<CampaignFolder, Sprint>(CampaignFolder.class, nodeClass, this.daoProviderMap, clipboardPayload));
    }

    @Override
    public void copyNodeToCampaignLibrary(Long destinationId, ClipboardPayload clipboardPayload, NodeType nodePaste) {
        Class<Sprint> nodeClass = switch (nodePaste) {
            case NodeType.SPRINT -> Sprint.class;
            case NodeType.SPRINT_GROUP -> SprintGroup.class;
            case NodeType.CAMPAIGN -> Campaign.class;
            case NodeType.CAMPAIGN_FOLDER -> CampaignFolder.class;
            default -> throw new IllegalArgumentException(String.format("Cannot paste %s in a campaign library", nodePaste.getTypeName()));
        };
        this.strategyCopierService.copyNodeToContainer(destinationId, new CopyLoadingBasicEntities<CampaignLibrary, Sprint>(CampaignLibrary.class, nodeClass, this.daoProviderMap, clipboardPayload));
    }
}

