/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.tm.service.TestSuiteTestPlanManagerService")
@Transactional
public class TestSuiteTestPlanManagerServiceImpl
implements TestSuiteTestPlanManagerService {
    private static final String HAS_LINK_PERMISSION_ID = "hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK') ";
    @Inject
    private IterationTestPlanManagerService delegateIterationTestPlanManagerService;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy")
    private ObjectIdentityRetrievalStrategy objIdRetrievalStrategy;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private UserDao userDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private TestPlanItemDao testPlanItemDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'READ')  or hasRole('ROLE_ADMIN')")
    public TestSuite findTestSuite(long testSuiteId) {
        return (TestSuite)this.testSuiteDao.getReferenceById(testSuiteId);
    }

    @Override
    @CheckBlockingMilestones(entityType=TestSuite.class)
    public void bindTestPlanToMultipleSuites(@Ids List<Long> suiteIds, List<Long> itemTestPlanIds) {
        this.permissionService.checkPermission(suiteIds, Permissions.LINK.name(), TestSuite.class.getName());
        List testSuites = this.testSuiteDao.loadForItemAddition(suiteIds);
        for (TestSuite suite : testSuites) {
            suite.bindTestPlanItemsById(itemTestPlanIds);
        }
    }

    private void bindTestPlanObj(TestSuite testSuite, List<TestPlanItem> testPlanItems) {
        testSuite.bindTestPlanItems(testPlanItems);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite.getIteration());
    }

    private void unbindTestPlanObj(TestSuite testSuite, List<TestPlanItem> itemTestPlans) {
        testSuite.unBindTestPlan(itemTestPlans);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite.getIteration());
    }

    private void unbindTestPlanToMultipleSuites(List<Long> unboundTestSuiteIds, List<Long> itpIds) {
        List unboundTestSuites = this.testSuiteDao.findAllById(unboundTestSuiteIds);
        List testPlanItems = this.testPlanItemDao.findAllById(itpIds);
        for (TestSuite suite : unboundTestSuites) {
            this.unbindTestPlanObj(suite, testPlanItems);
        }
    }

    @Override
    public void unbindAllTestPlansFromTestPlanItem(List<Long> itemIds) {
        List items = this.testPlanItemDao.findAllById(itemIds);
        this.permissionService.checkPermission(items, Permissions.LINK.name());
        HashSet affectedTestSuites = new HashSet();
        items.forEach(item -> {
            boolean bl = affectedTestSuites.addAll(item.getTestSuites().stream().map(TestSuite::getId).collect(Collectors.toSet()));
        });
        this.unbindTestPlanToMultipleSuites(new ArrayList<Long>(affectedTestSuites), itemIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void changeTestPlanPosition(@Id long suiteId, int newIndex, List<Long> itemIds) {
        TestSuite suite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        List<Long> list = itemIds;
        long l = suiteId;
        TestSuiteDao testSuiteDao = this.testSuiteDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testSuiteDao, (Object)Conversions.longObject((long)l), list);
        Object[] objectArray = new Object[]{this, testSuiteDao, Conversions.longObject((long)l), list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure1 testSuiteTestPlanManagerServiceImpl$AjcClosure1 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure1(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        suite.reorderTestPlan(newIndex, items);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public CreatedTestPlanItems addTestCasesToIterationAndTestSuite(List<Long> testCaseIds, @Id long suiteId) {
        return this.addTestCasesToIterationAndTestSuiteUnsecured(testCaseIds, suiteId);
    }

    @Override
    public CreatedTestPlanItems addTestCasesToIterationAndTestSuiteUnsecured(List<Long> testCaseIds, long suiteId) {
        TestSuite testSuite = this.testSuiteDao.loadForItemAddition(suiteId);
        Iteration iteration = testSuite.getIteration();
        List<TestPlanItem> itemTestPlans = this.delegateIterationTestPlanManagerService.addTestPlanItemsToIteration(testCaseIds, iteration);
        this.bindTestPlanObj(testSuite, itemTestPlans);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        return new CreatedTestPlanItems(itemTestPlans);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void detachTestPlanFromTestSuite(List<Long> testPlanIds, @Id long suiteId) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        List testPlanItems = this.testPlanItemDao.findAllById(testPlanIds);
        this.unbindTestPlanObj(testSuite, testPlanItems);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void detachTestPlanFromTestSuiteAndRemoveFromIteration(List<Long> testPlanIds, @Id long suiteId) {
        Long iterationId = this.testSuiteDao.findIterationIdByTestSuiteId(suiteId);
        this.delegateIterationTestPlanManagerService.removeTestPlansFromIterationWithoutException(testPlanIds, iterationId);
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
    }

    @Override
    public List<User> findAssignableUserForTestPlan(long testSuiteId) {
        List<String> loginList;
        TestSuite testSuite = (TestSuite)this.testSuiteDao.findById(testSuiteId).get();
        ArrayList<ObjectIdentity> entityRefs = new ArrayList<ObjectIdentity>();
        ObjectIdentity oid = this.objIdRetrievalStrategy.getObjectIdentity((Object)testSuite);
        entityRefs.add(oid);
        List<String> list = loginList = this.aclService.findUsersWithExecutePermission(entityRefs);
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure3 testSuiteTestPlanManagerServiceImpl$AjcClosure3 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure3(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> getLastExecutionStatuses(Collection<Long> itemTestPlanIds) {
        return this.delegateIterationTestPlanManagerService.getLastExecutionStatuses(itemTestPlanIds);
    }

    static {
        TestSuiteTestPlanManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findTestPlanPartition_aroundBody0(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, TestSuiteDao testSuiteDao, long l, List list, JoinPoint joinPoint) {
        return testSuiteDao.findTestPlanPartition(l, list);
    }

    static final /* synthetic */ List findUsersByLoginIn_aroundBody2(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestSuiteTestPlanManagerServiceImpl.java", TestSuiteTestPlanManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findTestPlanPartition", "org.squashtest.tm.service.internal.repository.TestSuiteDao", "long:java.util.List", "arg0:arg1", "", "java.util.List"), 158);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findUsersByLoginIn", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "arg0", "", "java.util.List"), 227);
    }
}

