/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.BaseLocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.LocalKnownIssueFinderHelper;

@Repository
@Transactional(readOnly=true)
public class SprintReqVersionKnownIssueFinder
extends BaseLocalKnownIssueFinder<Record4<Long, Long, String, String>> {
    public SprintReqVersionKnownIssueFinder(DSLContext dsl) {
        super(dsl);
    }

    @Override
    protected SelectHavingStep<Record4<Long, Long, String, String>> selectKnownIssues(long sprintReqVersionId) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.ISSUE.BUGTRACKER_ID, (SelectField)Tables.ISSUE.REMOTE_ISSUE_ID, (SelectField)DSL.groupConcatDistinct((Field)Tables.EXECUTION.EXECUTION_ID)).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.PROJECT.CL_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).and(Tables.ISSUE.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.ISSUE.BUGTRACKER_ID, Tables.ISSUE.REMOTE_ISSUE_ID});
    }

    @Override
    public int countKnownIssues(Long sprintReqVersionId) {
        return this.selectKnownIssues(sprintReqVersionId).fetch().size();
    }

    @Override
    protected LocalKnownIssue buildIssueFromRecord(Record4<Long, Long, String, String> record) {
        return new LocalKnownIssue((Long)record.component1(), (Long)record.component2(), (String)record.component3(), LocalKnownIssueFinderHelper.parseLongsAndSortDesc((String)record.component4()));
    }
}

