/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction;

import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.service.internal.batchimport.DatasetValue;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;

public class DatasetParamValueInstruction
extends Instruction<DatasetTarget> {
    private final DatasetValue datasetValue;
    private ParameterTarget parameterTarget;

    public DatasetParamValueInstruction(@NotNull DatasetTarget target, @NotNull DatasetValue datasetValue) {
        super(target);
        this.datasetValue = datasetValue;
    }

    public void initParameterTarget() {
        ParameterTarget paramTarget = new ParameterTarget();
        this.setParameterOwnerPath(paramTarget);
        paramTarget.setName(this.datasetValue.getParameterName());
        this.parameterTarget = paramTarget;
    }

    private void setParameterOwnerPath(ParameterTarget parameterTarget) {
        String parameterOwnerPath = this.datasetValue.getParameterOwnerPath();
        if (StringUtils.isBlank((CharSequence)parameterOwnerPath)) {
            parameterTarget.setPath(((DatasetTarget)this.getTarget()).getTestCase().getPath());
        } else {
            parameterTarget.setPath(parameterOwnerPath);
        }
    }

    public DatasetValue getDatasetValue() {
        return this.datasetValue;
    }

    public ParameterTarget getParameterTarget() {
        return this.parameterTarget;
    }

    @Override
    protected LogTrain executeUpdate(Facility facility) {
        return facility.failsafeUpdateParameterValue((DatasetTarget)this.getTarget(), this.parameterTarget, this.datasetValue.getValue(), true);
    }

    @Override
    protected LogTrain executeDelete(Facility facility) {
        return new LogTrain();
    }

    @Override
    protected LogTrain executeCreate(Facility facility) {
        throw new UnsupportedOperationException("This operation is no longer supported ");
    }
}

