/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.CustomFieldTransator;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.RequirementFacility;
import org.squashtest.tm.service.internal.batchimport.testcase.TestCaseFacility;

@Component
@Scope(value="prototype")
public class FacilityImpl
extends AbstractEntityFacilitySupport
implements Facility {
    private static final String UNEXPECTED_ERROR_DURING_CREATION = "unexpected error occurred when creating {} in project : {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    private final RequirementFacility requirementFacility;
    private final TestCaseFacility testCaseFacility;

    public FacilityImpl(RequirementFacility requirementFacility, TestCaseFacility testCaseFacility, ValidationFacility injectedValidator, CustomFieldTransator customFieldTransator) {
        this.requirementFacility = requirementFacility;
        this.testCaseFacility = testCaseFacility;
        this.validator = injectedValidator;
        this.initializeCustomFieldTransator(customFieldTransator);
        this.requirementFacility.initializeValidator(injectedValidator);
        this.requirementFacility.initializeCustomFieldTransator(customFieldTransator);
        this.testCaseFacility.initializeValidator(injectedValidator);
        this.testCaseFacility.initializeCustomFieldTransator(customFieldTransator);
    }

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        return this.testCaseFacility.updateTestCase(instr);
    }

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        return this.testCaseFacility.deleteTestCase(target);
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        return this.testCaseFacility.updateActionStep(target, testStep, cufValues);
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo, ActionTestStep actionStepBackup) {
        return this.testCaseFacility.updateCallStep(target, testStep, calledTestCase, paramInfo, actionStepBackup);
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        return this.testCaseFacility.deleteTestStep(target);
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        return this.testCaseFacility.updateParameter(target, param);
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        return this.testCaseFacility.deleteParameter(target);
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        return this.testCaseFacility.failsafeUpdateParameterValue(dataset, param, value, isUpdate);
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        return this.testCaseFacility.deleteDataset(dataset);
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        return this.requirementFacility.deleteRequirementVersion(instr);
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementFacility.deleteRequirementLink(instr);
    }

    @Override
    public void createTestCases(List<TestCaseInstruction> instructions, Project project) {
        this.validator.createTestCases(instructions, project);
        List<TestCaseInstruction> validTestCases = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.testCaseFacility.createTestCases(validTestCases, project);
        }
        catch (Exception ex) {
            validTestCases.forEach(i -> {
                this.addUnexpectedError((Instruction<?>)i, ex);
                this.validator.getModel().setNotExists((TestCaseTarget)i.getTarget());
            });
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"test cases", project.getName(), ex});
        }
    }

    @Override
    public void createParameters(List<ParameterInstruction> instructions, Project project) {
        this.validator.createParameters(instructions, project);
        List<ParameterInstruction> validParameters = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.testCaseFacility.createParameters(validParameters);
        }
        catch (Exception ex) {
            validParameters.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"parameters", project.getName(), ex});
        }
    }

    @Override
    public void createDatasets(List<DatasetInstruction> instructions, Project project) {
        this.validator.createDatasets(instructions, project);
        List<DatasetInstruction> validDatasets = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.testCaseFacility.createDatasets(validDatasets);
            this.validator.getModel().addDatasets(validDatasets.stream().map(Instruction::getTarget).toList());
        }
        catch (Exception ex) {
            validDatasets.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"datasets", project.getName(), ex});
        }
    }

    protected void addUnexpectedError(Instruction<?> instruction, Throwable ex) {
        instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unexpectederror", null, ex.getClass().getName());
    }

    @Override
    public void addActionSteps(List<ActionStepInstruction> instructions, Project project) {
        this.validator.addActionSteps(instructions, project);
        List<ActionStepInstruction> validSteps = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.testCaseFacility.addActionSteps(validSteps, project);
        }
        catch (Exception ex) {
            validSteps.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"action steps", project.getName(), ex});
        }
    }

    @Override
    public void addCallSteps(List<CallStepInstruction> instructions, Project project) {
        this.testCaseFacility.addCallSteps(instructions, project);
    }

    @Override
    public void addDatasetParametersValues(List<DatasetParamValueInstruction> instructions, Project project) {
        this.validator.addDatasetParametersValues(instructions, project);
        List<DatasetParamValueInstruction> validParametersValues = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.testCaseFacility.addDatasetParametersValues(validParametersValues);
        }
        catch (Exception ex) {
            validParametersValues.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"parameter values", project.getName(), ex});
        }
    }

    @Override
    public void createRequirementVersions(List<RequirementVersionInstruction> instructions, Project project) {
        this.validator.createRequirementVersions(instructions, project);
        ArrayList<RequirementVersionInstruction> createRequirementInstructions = new ArrayList<RequirementVersionInstruction>();
        ArrayList<RequirementVersionInstruction> addVersionInstructions = new ArrayList<RequirementVersionInstruction>();
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(instruction -> {
            RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
            Long reqId = this.validator.getModel().getRequirementId(target);
            if (reqId == null) {
                createRequirementInstructions.add((RequirementVersionInstruction)instruction);
            } else {
                addVersionInstructions.add((RequirementVersionInstruction)instruction);
            }
        });
        try {
            this.requirementFacility.createRequirementVersions(createRequirementInstructions, addVersionInstructions, project);
        }
        catch (Exception ex) {
            instructions.stream().filter(e -> !e.hasCriticalErrors()).forEach(i -> {
                this.addUnexpectedError((Instruction<?>)i, ex);
                this.validator.getModel().setNotExists((RequirementVersionTarget)i.getTarget());
            });
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"requirement versions", project.getName(), ex});
        }
    }

    @Override
    public void createCoverages(List<CoverageInstruction> coverageInstructions, Project project) {
        this.validator.createCoverages(coverageInstructions, project);
        List<CoverageInstruction> validCoverages = coverageInstructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.requirementFacility.createCoverages(validCoverages);
        }
        catch (Exception ex) {
            validCoverages.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"coverages", project.getName(), ex});
        }
    }

    @Override
    public void updateRequirementVersions(List<RequirementVersionInstruction> updateInstructions, Project project) {
        this.validator.updateRequirementVersions(updateInstructions, project);
        List<RequirementVersionInstruction> validInstructions = updateInstructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.requirementFacility.updateRequirementVersions(validInstructions, project);
        }
        catch (Exception ex) {
            updateInstructions.stream().filter(e -> !e.hasCriticalErrors()).forEach(i -> {
                this.addUnexpectedError((Instruction<?>)i, ex);
                this.validator.getModel().setNotExists((RequirementVersionTarget)i.getTarget());
            });
            LOGGER.error("Excel import : unexpected error while importing ", new Object[]{"requirement versions", project.getName(), ex});
        }
    }

    @Override
    public void createOrUpdateRequirementLinks(List<RequirementLinkInstruction> requirementLinkInstructions, Project project) {
        this.validator.createOrUpdateRequirementLinks(requirementLinkInstructions, project);
        List<RequirementLinkInstruction> validLinks = requirementLinkInstructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.requirementFacility.createOrUpdateLinks(validLinks);
        }
        catch (Exception ex) {
            validLinks.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"links", project.getName(), ex});
        }
    }

    @Override
    public void createOrUpdateLinkedLowLevelRequirements(List<LinkedLowLevelRequirementInstruction> instructions) {
        this.validator.createOrUpdateLinkedLowLevelRequirements(instructions);
        List<LinkedLowLevelRequirementInstruction> validInstructions = instructions.stream().filter(i -> !i.hasCriticalErrors()).toList();
        try {
            this.requirementFacility.createOrUpdateLinkedLowLevelRequirements(validInstructions);
        }
        catch (Exception ex) {
            validInstructions.forEach(i -> this.addUnexpectedError((Instruction<?>)i, ex));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"linked low level requirements", ex});
        }
    }
}

