/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntityVisitor;
import org.squashtest.tm.domain.actionword.ActionWordTreeLibraryNode;
import org.squashtest.tm.domain.bdd.ActionWord;

public class ActionWordLibraryNodeBuilder
implements ActionWordTreeEntityVisitor {
    private ActionWordLibraryNode builtNode = new ActionWordLibraryNode();
    private ActionWordLibraryNode parentNode;
    private ActionWordTreeEntity treeEntity;
    private boolean tokenCaseInsensitivity;

    public ActionWordLibraryNodeBuilder(ActionWordLibraryNode parentNode, ActionWordTreeEntity treeEntity, boolean tokenCaseInsensitivity) {
        this.parentNode = parentNode;
        this.treeEntity = treeEntity;
        this.tokenCaseInsensitivity = tokenCaseInsensitivity;
    }

    public ActionWordLibraryNode build() {
        this.nameBuiltNode();
        this.linkEntity();
        this.linkToParent();
        this.treeEntity.accept((ActionWordTreeEntityVisitor)this);
        return this.builtNode;
    }

    private void nameBuiltNode() {
        this.builtNode.setName(this.treeEntity.getName());
    }

    private void linkEntity() {
        this.builtNode.setEntity(this.treeEntity);
    }

    private void linkToParent() {
        this.parentNode.addChild((ActionWordTreeLibraryNode)this.builtNode, this.tokenCaseInsensitivity);
        this.builtNode.setLibrary(this.parentNode.getLibrary());
    }

    public void visit(ActionWordLibrary actionWordLibrary) {
        this.builtNode.setEntityType(ActionWordTreeDefinition.LIBRARY);
    }

    public void visit(ActionWord actionWord) {
        this.linkToProject();
        this.builtNode.setName(actionWord.createWord());
        this.builtNode.setEntityType(ActionWordTreeDefinition.ACTION_WORD);
    }

    private void linkToProject() {
        this.treeEntity.setProject(this.parentNode.getLibrary().getProject());
    }
}

