/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import jakarta.inject.Inject;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.domain.users.preferences.WorkspaceDashboardContentValues;
import org.squashtest.tm.service.internal.repository.PartyPreferenceDao;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squashtest.tm.service.PartyPreferenceService")
@Transactional
public class PartyPreferenceServiceImpl
implements PartyPreferenceService {
    @Inject
    UserAccountService userAccountService;
    @Inject
    private PartyPreferenceDao partyPreferenceDao;

    @Override
    public PartyPreference findPreference(Party party, String preferenceKey) {
        return this.partyPreferenceDao.findByPartyAndPreferenceKey(party, preferenceKey);
    }

    @Override
    public Map<String, String> findPreferences(Party party) {
        return this.partyPreferenceDao.findAllPreferencesForParty(party);
    }

    @Override
    public PartyPreference findPreferenceForCurrentUser(String preferenceKey) {
        User party = this.userAccountService.findCurrentUser();
        return this.partyPreferenceDao.findByPartyAndPreferenceKey((Party)party, preferenceKey);
    }

    @Override
    public Map<String, String> findPreferencesForCurrentUser() {
        User party = this.userAccountService.findCurrentUser();
        return this.partyPreferenceDao.findAllPreferencesForParty((Party)party);
    }

    @Override
    public void addOrUpdatePreference(Party party, String preferenceKey, String preferenceValue) {
        PartyPreference pref = this.findPreference(party, preferenceKey);
        if (pref == null) {
            pref = new PartyPreference();
            pref.setParty(party);
            pref.setPreferenceKey(preferenceKey);
            pref.setPreferenceValue(preferenceValue);
            this.partyPreferenceDao.save(pref);
        } else {
            pref.setPreferenceValue(preferenceValue);
        }
    }

    @Override
    public void addOrUpdatePreferenceForCurrentUser(String preferenceKey, String preferenceValue) {
        User party = this.userAccountService.findCurrentUser();
        this.addOrUpdatePreference((Party)party, preferenceKey, preferenceValue);
    }

    @Override
    public void chooseWelcomeMessageAsHomeContentForCurrentUser() {
        String key = CorePartyPreference.HOME_WORKSPACE_CONTENT.getPreferenceKey();
        String value = WorkspaceDashboardContentValues.DEFAULT.getPreferenceValue();
        this.addOrUpdatePreferenceForCurrentUser(key, value);
    }

    @Override
    public void chooseFavoriteDashboardAsHomeContentForCurrentUser() {
        String key = CorePartyPreference.HOME_WORKSPACE_CONTENT.getPreferenceKey();
        String value = WorkspaceDashboardContentValues.DASHBOARD.getPreferenceValue();
        this.addOrUpdatePreferenceForCurrentUser(key, value);
    }

    @Override
    public void removeDashboardFromFavoritesForCurrentUser(long dashboardId) {
        Long userId = this.userAccountService.findCurrentUser().getId();
        this.partyPreferenceDao.removeFavoriteDashboardPreferenceByPartyIdAndDashboardId(userId, String.valueOf(dashboardId));
    }

    @Override
    public void removeDashboardFromFavoriteWithPreferenceKey(long dashboardId, String preferenceKey) {
        Long userId = this.userAccountService.findCurrentUser().getId();
        this.partyPreferenceDao.removeFavoriteDashboardPreferenceByPreferenceKeyAndDashboardId(userId, String.valueOf(dashboardId), preferenceKey);
    }
}

