/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.campaign.AutomatedSuiteModificationService;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.AutomatedTestSuiteDto;
import org.squashtest.tm.service.internal.dto.resultimport.ImportTestPlanItemDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.testautomation.resultimport.AttachmentImportHelper;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testautomation.AutomatedSuiteImportService;
import org.squashtest.tm.service.testautomation.resultimport.AutomatedExecutionImportService;

@Service
public class AutomatedSuiteImportServiceImpl
implements AutomatedSuiteImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteImportServiceImpl.class);
    private final PermissionEvaluationService permissionEvaluationService;
    private final AutomatedSuiteDao automatedSuiteDao;
    private final AutomatedExecutionImportService automatedExecutionImportService;
    private final AutomatedSuiteModificationService automatedSuiteModificationService;
    private final AttachmentManagerService attachmentManagerService;
    private final EntityManager entityManager;
    private final AttachmentImportHelper attachmentImportHelper;

    @Inject
    public AutomatedSuiteImportServiceImpl(PermissionEvaluationService permissionEvaluationService, AutomatedSuiteDao automatedSuiteDao, AutomatedExecutionImportService automatedExecutionImportService, AutomatedSuiteModificationService automatedSuiteModificationService, AttachmentManagerService attachmentManagerService, EntityManager entityManager, AttachmentImportHelper attachmentImportHelper) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.automatedSuiteDao = automatedSuiteDao;
        this.automatedExecutionImportService = automatedExecutionImportService;
        this.automatedSuiteModificationService = automatedSuiteModificationService;
        this.attachmentManagerService = attachmentManagerService;
        this.entityManager = entityManager;
        this.attachmentImportHelper = attachmentImportHelper;
    }

    @Override
    public Long createAutomatedSuiteAndImportExecutions(List<ImportTestPlanItemDto> testPlanItems, Iteration iteration, AutomatedTestSuiteDto automatedTestSuiteDto, PartialErrorDto partialErrors) {
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(iteration, Permissions.EXECUTE.name()));
        AutomatedSuite suiteForImportedExecutions = this.automatedSuiteDao.createNewSuite(iteration);
        this.automatedExecutionImportService.importAutomatedExecutions(suiteForImportedExecutions, testPlanItems, iteration.getProject(), partialErrors);
        this.automatedSuiteModificationService.updateExecutionStatus(suiteForImportedExecutions);
        if (automatedTestSuiteDto != null) {
            this.populateAutomatedSuiteWithImportedProperties(suiteForImportedExecutions, automatedTestSuiteDto, partialErrors);
        }
        this.entityManager.merge((Object)suiteForImportedExecutions);
        this.entityManager.flush();
        this.entityManager.clear();
        return suiteForImportedExecutions.getId();
    }

    private void populateAutomatedSuiteWithImportedProperties(AutomatedSuite automatedSuite, AutomatedTestSuiteDto automatedTestSuiteDto, PartialErrorDto partialErrors) {
        List<AttachmentDto> attachments;
        if (automatedTestSuiteDto.getStatus() != null) {
            automatedSuite.setExecutionStatus(ExecutionStatus.valueOf((String)automatedTestSuiteDto.getStatus()));
        }
        if ((attachments = automatedTestSuiteDto.getAttachments()) != null) {
            this.attachmentImportHelper.deduplicateAttachmentNames(attachments);
            for (AttachmentDto attachmentDto : attachments) {
                this.addAttachmentToAutomatedSuite(automatedSuite, partialErrors, attachmentDto);
            }
        }
    }

    private void addAttachmentToAutomatedSuite(AutomatedSuite automatedSuite, PartialErrorDto partialErrors, AttachmentDto attachmentDto) {
        if (this.attachmentImportHelper.isValidAutomatedSuiteAttachment(partialErrors, attachmentDto)) {
            UploadedData uploadedData = null;
            try {
                uploadedData = this.attachmentImportHelper.decodeBase64AttachmentContent(attachmentDto);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                partialErrors.addNewTestError(null, null, "Content of automated suite attachment '%s' is not a valid Base64 string.".formatted(attachmentDto.getName()));
                return;
            }
            try {
                this.attachmentManagerService.addAttachment(automatedSuite.getAttachmentList().getId(), (RawAttachment)uploadedData, EntityType.AUTOMATED_SUITE);
            }
            catch (IOException e) {
                partialErrors.addNewTestError(null, null, "Failed to add attachment %s to automated suite %s: %s".formatted(attachmentDto.getName(), automatedSuite.getId(), e.getMessage()));
                LOGGER.error("Failed to add attachment {} to automated suite {}", new Object[]{attachmentDto.getName(), automatedSuite.getId(), e});
            }
        }
    }
}

