/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.security.authentication.ExtraAccountInformationAuthentication;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.security.AuthenticatedMissingUserCreatorService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserAdministrationService;

@Service
public class AuthenticatedMissingUserCreatorServiceImpl
implements AuthenticatedMissingUserCreatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedMissingUserCreatorServiceImpl.class);
    @Inject
    private UserAdministrationService userAdministrationService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private UserDetailsManager userDetailsManager;

    @Override
    public void createMissingUser(Authentication principal) {
        LOGGER.debug("Will try to create user from principal if it does not exist", new Object[0]);
        try {
            this.userAccountService.checkLoginAvailability(principal.getName());
        }
        catch (LoginAlreadyExistsException ex) {
            LOGGER.debug("Authenticated principal matches an existing User, no new user will be created.", (Throwable)ex);
            return;
        }
        LOGGER.info("Authenticated principal does not match any User, a new User will be created", new Object[0]);
        this.createUserFromPrincipal(principal);
    }

    private void createUserFromPrincipal(Authentication principal) {
        try {
            this.createUserAccount(principal);
            this.createSpringSecAccount(principal);
        }
        catch (LoginAlreadyExistsException e) {
            LOGGER.warn("Something went wrong while trying to create missing authenticated user", (Throwable)e);
        }
    }

    private void createUserAccount(Authentication principal) {
        String username = principal.getName().trim();
        LOGGER.debug("creating user {}", new Object[]{username});
        org.squashtest.tm.domain.users.User user = org.squashtest.tm.domain.users.User.createFromLogin((String)username);
        if (ExtraAccountInformationAuthentication.class.isAssignableFrom(principal.getClass())) {
            this.populateExtraAccountInformationAuthentication(principal, user);
        }
        this.userAdministrationService.createUserWithoutCredentials(user, "squashtest.authz.group.tm.User");
    }

    private void populateExtraAccountInformationAuthentication(Authentication authentication, org.squashtest.tm.domain.users.User newUser) {
        LOGGER.debug("Extra account information were found in the principal : the user account will be populated with them", new Object[0]);
        ExtraAccountInformationAuthentication extra = (ExtraAccountInformationAuthentication)authentication;
        newUser.setFirstName(extra.getFirstName());
        newUser.setEmail(extra.getEmail());
        String lastName = extra.getLastName();
        if (!StringUtils.isBlank((CharSequence)lastName)) {
            newUser.setLastName(extra.getLastName());
        }
    }

    private void createSpringSecAccount(Authentication principal) {
        String username = principal.getName().trim();
        ArrayList authorities = new ArrayList();
        User springUser = new User(username, "", authorities);
        this.userDetailsManager.createUser((UserDetails)springUser);
    }
}

