/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetLibraryIdsCallback;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetParamIdsParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class HibernateRequirementDao
extends HibernateEntityDao<Requirement>
implements RequirementDao {
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String REQUIREMENT_ID = "requirementId";
    private static final String NODE_IDS = "nodeIds";
    @Inject
    DSLContext dsl;

    @Override
    public List<Long> fetchHighLevelRequirementVersionIds(List<Long> requirementVersionIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).fetchInto(Long.class);
    }

    @Override
    public List<Requirement> findChildrenRequirements(long requirementId) {
        SetIdParameter setId = new SetIdParameter(REQUIREMENT_ID, requirementId);
        return this.executeListNamedQuery("requirement.findChildrenRequirements", setId);
    }

    @Override
    public List<Long> findByRequirementVersion(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createQuery("select r.id from Requirement r\njoin r.versions versions\nwhere versions.id in (:versionIds)", Long.class).setParameter("versionIds", versionIds).getResultList();
    }

    @Override
    public List<ExportRequirementData> findRequirementToExportFromNodes(List<Long> params) {
        if (!params.isEmpty()) {
            return this.doFindRequirementToExportFromNodes(params);
        }
        return Collections.emptyList();
    }

    private List<ExportRequirementData> doFindRequirementToExportFromNodes(List<Long> params) {
        List<Requirement> rootReqs = this.findRootContentRequirement(params);
        List rootReqsIds = IdentifiedUtil.extractIds(rootReqs);
        HashSet<Long> nonRootReqNodesIds = new HashSet<Long>();
        List<Long> listReqNodeId = this.findDescendantRequirementIds(params);
        nonRootReqNodesIds.addAll(listReqNodeId);
        List<Long> listParentRequirementIds = this.findRequirementParents(params);
        nonRootReqNodesIds.addAll(listParentRequirementIds);
        nonRootReqNodesIds.addAll(params);
        nonRootReqNodesIds.removeAll(rootReqsIds);
        if (nonRootReqNodesIds.isEmpty()) {
            return this.formatExportResult(rootReqs, new ArrayList<Object[]>(0));
        }
        List<Requirement> nonRootReqs = this.findAllByIds(nonRootReqNodesIds);
        Collection<Object[]> listObject = this.addPathInfos(nonRootReqs);
        return this.formatExportResult(rootReqs, listObject);
    }

    private List<Long> findRequirementParents(List<Long> params) {
        return this.entityManager.createQuery("select reqParent.id from Requirement\nreqParent, RequirementPathEdge closure\nwhere closure.descendantId in :nodeIds\nand closure.ancestorId = reqParent.id\nand closure.depth != 0", Long.class).setParameter(NODE_IDS, params).getResultList();
    }

    @Override
    public List<Long> findDescendantRequirementIds(Collection<Long> params) {
        return this.entityManager.createQuery("select reqDescendant.id from Requirement reqDescendant, RequirementPathEdge closure\nwhere closure.ancestorId in :nodeIds\nand closure.descendantId = reqDescendant.id and closure.depth != 0", Long.class).setParameter(NODE_IDS, params).getResultList();
    }

    private Collection<Object[]> addPathInfos(List<Requirement> requirements) {
        if (!requirements.isEmpty()) {
            HashMap<Long, Object[]> exportInfosById = new HashMap<Long, Object[]>(requirements.size());
            for (Requirement requirement : requirements) {
                Object[] exportInfo = new Object[]{requirement, "", ""};
                exportInfosById.put(requirement.getId(), exportInfo);
            }
            Set requirementIds = exportInfosById.keySet();
            TypedQuery query = this.entityManager.createNamedQuery("requirement.findReqPaths", Object[].class);
            query.setParameter(REQUIREMENT_IDS, requirementIds);
            List idAndReqPaths = query.getResultList();
            this.addPathInfosToExportInfos(exportInfosById, idAndReqPaths, 2);
            query = this.entityManager.createNamedQuery("requirement.findFolderPaths", Object[].class);
            query.setParameter(REQUIREMENT_IDS, requirementIds);
            List folderPaths = query.getResultList();
            this.addPathInfosToExportInfos(exportInfosById, folderPaths, 1);
            return exportInfosById.values();
        }
        return Collections.emptyList();
    }

    public void addPathInfosToExportInfos(Map<Long, Object[]> reqAndFolderPathAndReqPathById, List<Object[]> idAndPaths, int pathInfoIndex) {
        for (Object[] idAndPath : idAndPaths) {
            Long reqId = (Long)idAndPath[0];
            String reqPath = (String)idAndPath[1];
            String escapedPath = HibernatePathService.escapePath(reqPath);
            Object[] reqAndFolderPathAndReqPath = reqAndFolderPathAndReqPathById.get(reqId);
            reqAndFolderPathAndReqPath[pathInfoIndex] = escapedPath;
        }
    }

    private List<ExportRequirementData> formatExportResult(Collection<Requirement> rootReq, Collection<Object[]> nonRootReq) {
        ArrayList<ExportRequirementData> exportList = new ArrayList<ExportRequirementData>();
        for (Requirement requirement : rootReq) {
            ExportRequirementData erd = new ExportRequirementData(requirement, "", "");
            exportList.add(erd);
        }
        for (Object[] exportReqInfos : nonRootReq) {
            Requirement requirement = (Requirement)exportReqInfos[0];
            String folderPath = (String)exportReqInfos[1];
            String requirementPath = (String)exportReqInfos[2];
            ExportRequirementData erd = new ExportRequirementData(requirement, folderPath, requirementPath);
            exportList.add(erd);
        }
        Collections.sort(exportList, new ExportRequirementDataComparator());
        return exportList;
    }

    private List<Requirement> findRootContentRequirement(List<Long> params) {
        if (!params.isEmpty()) {
            SetParamIdsParametersCallback newCallBack1 = new SetParamIdsParametersCallback(params);
            return this.executeListNamedQuery("requirement.findRootContentRequirement", newCallBack1);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExportRequirementData> findRequirementToExportFromLibrary(List<Long> libraryIds) {
        if (!libraryIds.isEmpty()) {
            SetLibraryIdsCallback newCallBack1 = new SetLibraryIdsCallback(libraryIds);
            List<Long> result = this.executeListNamedQuery("requirement.findAllRootContent", newCallBack1);
            return this.findRequirementToExportFromNodes(result);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequirementCriticality> findDistinctRequirementsCriticalitiesVerifiedByTestCases(Set<Long> testCasesIds) {
        if (testCasesIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createNamedQuery("requirementVersion.findDistinctRequirementsCriticalitiesVerifiedByTestCases", RequirementCriticality.class).setParameter("testCasesIds", testCasesIds).getResultList();
    }

    @Override
    public List<RequirementCriticality> findDistinctRequirementsCriticalities(List<Long> requirementVersionsIds) {
        if (requirementVersionsIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createNamedQuery("requirementVersion.findDistinctRequirementsCriticalities", RequirementCriticality.class).setParameter("requirementsIds", requirementVersionsIds).getResultList();
    }

    @Override
    public List<RequirementVersion> findVersions(Long requirementId) {
        return this.entityManager.createNamedQuery("requirement.findVersions", RequirementVersion.class).setParameter(REQUIREMENT_ID, (Object)requirementId).getResultList();
    }

    @Override
    public List<RequirementVersion> findVersionsForAll(List<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createNamedQuery("requirement.findVersionsForAll", RequirementVersion.class).setParameter(REQUIREMENT_IDS, requirementIds).getResultList();
    }

    @Override
    public Requirement findByContent(Requirement child) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)child);
        return (Requirement)this.executeEntityNamedQuery("requirement.findByContent", callback);
    }

    @Override
    public <T extends NodeContainer<Requirement>> T findParentOf(Long requirementId) {
        if (Objects.isNull(requirementId)) {
            return null;
        }
        NodeContainer libraryParent = (NodeContainer)this.executeEntityNamedQuery("requirement.findAllLibraryParents", new SetRequirementsIdParameterCallback(requirementId));
        if (Objects.nonNull(libraryParent)) {
            return (T)libraryParent;
        }
        NodeContainer folderParent = (NodeContainer)this.executeEntityNamedQuery("requirement.findAllFolderParents", new SetRequirementsIdParameterCallback(requirementId));
        if (Objects.nonNull(folderParent)) {
            return (T)folderParent;
        }
        NodeContainer reqParent = (NodeContainer)this.executeEntityNamedQuery("requirement.findAllRequirementParents", new SetRequirementsIdParameterCallback(requirementId));
        if (Objects.nonNull(reqParent)) {
            return (T)reqParent;
        }
        return null;
    }

    @Override
    public List<Long> findNonBoundRequirement(Collection<Long> nodeIds, Long milestoneId) {
        if (nodeIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createQuery("      select r.id\n      from Requirement r\n      where r.id in (:nodeIds)\n      and not exists (\n          select 1 from r.versions v\n          join v.milestones m\n          where m.id = :milestoneId\n      )\n", Long.class).setParameter(NODE_IDS, nodeIds).setParameter("milestoneId", (Object)milestoneId).getResultList();
    }

    @Override
    public List<Long> filterRequirementHavingManyVersions(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createNamedQuery("requirement.findRequirementHavingManyVersions", Long.class).setParameter(REQUIREMENT_IDS, requirementIds).getResultList();
    }

    @Override
    public List<Long> findAllRequirementsIdsByNodes(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createNamedQuery("requirement.findAllRequirementIdsByNodesId", Long.class).setParameter(NODE_IDS, nodeIds).getResultList();
    }

    @Override
    public List<Long> findIdsVersionsForAll(List<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createNamedQuery("requirement.findVersionsIdsForAll", Long.class).setParameter(REQUIREMENT_IDS, requirementIds).getResultList();
    }

    @Override
    public Long findNodeIdByRemoteKey(String remoteKey, String projectName) {
        return this.entityManager.createNamedQuery("requirement.findNodeIdByRemoteKey", Long.class).setParameter("key", (Object)remoteKey).setParameter("projectName", (Object)projectName).getResultStream().findFirst().orElse(null);
    }

    @Override
    public Long findNodeIdByRemoteKeyAndRemoteSyncId(String remoteKey, Long remoteSyncId) {
        return this.entityManager.createNamedQuery("requirement.findNodeIdByRemoteKeyAndSynchronisationId", Long.class).setParameter("key", (Object)remoteKey).setParameter("remoteSynchronisationId", (Object)remoteSyncId).getResultStream().findFirst().orElse(null);
    }

    @Override
    public Map<String, Long> findNodeIdsByRemoteKeys(Collection<String> remoteKeys, String projectName) {
        if (remoteKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.entityManager.createQuery("select r.id, se.remoteReqId\nfrom Requirement r\ninner join r.syncExtender se\nwhere se.remoteReqId in (:remoteKeys)\nand r.project.name = :projectName\n", Map.class).setParameter("remoteKeys", remoteKeys).setParameter("projectName", (Object)projectName).getResultStream().collect(Collectors.toMap(m -> (String)m.get("remoteReqId"), m -> (Long)m.get("id")));
    }

    @Override
    public List<Long> findAllRequirementIdsFromMilestones(Collection<Long> milestoneIds) {
        if (milestoneIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createNamedQuery("requirement.findAllRequirementIdsFromMilestones", Long.class).setParameter("milestoneIds", milestoneIds).getResultList();
    }

    @Override
    public List<Long> findAllRequirementIdsFromMilestonesAndSelectedReqIds(Collection<Long> milestoneIds, Collection<Long> requirementIds) {
        if (milestoneIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return this.entityManager.createNamedQuery("requirement.findAllRequirementVersionIdsFromMilestonesAndSelectedReqIds", Long.class).setParameter("milestoneIds", milestoneIds).setParameter(REQUIREMENT_IDS, requirementIds).getResultList();
    }

    @Override
    public Requirement findByRequirementVersionIdWithMilestone(Long requirementVersionId) {
        return this.entityManager.createQuery("select r from Requirement r join fetch r.versions v left join fetch v.milestones where v.id = :versionId", Requirement.class).setParameter("versionId", (Object)requirementVersionId).getResultStream().findFirst().orElse(null);
    }

    @Override
    public void setNativeManagementModeForSynchronizedRequirements(List<Long> remoteSynchronisationIds) {
        Set<Long> reqIds = this.findSynchronizedRequirementIds(remoteSynchronisationIds);
        if (!reqIds.isEmpty()) {
            this.dsl.update((Table)Tables.REQUIREMENT).set((Field)Tables.REQUIREMENT.MODE, (Object)ManagementMode.NATIVE.name()).where(Tables.REQUIREMENT.RLN_ID.in(reqIds)).execute();
        }
    }

    private Set<Long> findSynchronizedRequirementIds(List<Long> remoteSynchronisationIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.in(remoteSynchronisationIds)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    @Override
    public boolean isHighLevelRequirementVersion(Long requirementVersionId) {
        Long result = (Long)this.dsl.select((SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(Long.class);
        return result != null;
    }

    @Override
    public Long findRequirementIdFromVersionId(Long requirementVersionId) {
        return (Long)this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(Long.class);
    }

    @Override
    public Long findRequirementCurrentVersionIdFromRequirementId(Long highLevelRequirementId) {
        return (Long)this.dsl.select((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.eq((Object)highLevelRequirementId)).fetchOneInto(Long.class);
    }

    @Override
    public Set<Long> findRequirementCurrentVersionIdsFromRequirementIds(Collection<Long> requirementIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).fetchSet((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID);
    }

    @Override
    public boolean checkIfRequirementIsChild(Long requirementId) {
        return this.dsl.fetchExists((Select)this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.eq((Object)1)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)requirementId)));
    }

    @Override
    public Long findRequirementAncestorId(Long requirementId) {
        return (Long)this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)requirementId)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.eq((Object)1)).fetchOneInto(Long.class);
    }

    @Override
    public List<Long> findAllChildrenIdsFromRequirementId(Long requirementId) {
        return this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)requirementId)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).fetchInto(Long.class);
    }

    @Override
    public Requirement findByIdWithChildren(Long id) {
        return new EntityGraphQueryBuilder<Requirement>(this.entityManager, Requirement.class, "SELECT r FROM Requirement r WHERE r.id = :id").addAttributeNodes("children").addSubGraph("children", "syncExtender").execute(Collections.singletonMap("id", id));
    }

    @Override
    public List<Requirement> findRequirementsNodeRootAndInFolderByNodeIds(List<Long> libraryNodeIds) {
        CommonTableExpression cte = DSL.name((String)"CTE").fields("RLN_ID", "IS_FOLDER").as((ResultQuery)DSL.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull(), (Object)Boolean.TRUE).otherwise((Object)Boolean.FALSE)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(libraryNodeIds)));
        List requirementIds = this.dsl.with(new CommonTableExpression[]{cte}).select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in((Select)DSL.select((SelectField)DSL.field((String)"RLN_ID", Long.class)).from(DSL.name((String)"CTE")).where(DSL.field((String)"IS_FOLDER", Boolean.class).isTrue()))).union((Select)DSL.select((SelectField)DSL.field((String)"RLN_ID", Long.class)).from(DSL.name((String)"CTE")).where(DSL.field((String)"IS_FOLDER", Boolean.class).isFalse())).fetchInto(Long.class);
        if (requirementIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.findAllByIds(requirementIds);
    }

    @Override
    public Map<Long, List<RequirementCriticality>> findRequirementsCriticalityVerifiedByTestCases(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.entityManager.createQuery("select distinct tc.id, r.criticality\nfrom TestCase tc\njoin tc.requirementVersionCoverages rvc\njoin rvc.verifiedRequirementVersion r\nwhere tc.id in (:ids)", Object[].class).setParameter("ids", testCaseIds).getResultList().stream().collect(Collectors.groupingBy(r -> (Long)r[0], Collectors.mapping(r -> (RequirementCriticality)r[1], Collectors.toList())));
    }

    @Override
    public List<Requirement> loadNodeForTestCasePaste(Collection<Long> ids) {
        List requirements = this.entityManager.createQuery("select r from Requirement r left join fetch r.syncExtender left join fetch r.children c left join fetch c.syncExtender where r.id in :ids", Requirement.class).setParameter("ids", ids).getResultList();
        this.entityManager.createQuery("select r from Requirement r join fetch r.versions v left join fetch v.requirementVersionCoverages left join fetch v.attachmentList al left join fetch al.attachments a left join fetch a.content where r.id in :ids", Requirement.class).setParameter("ids", ids).getResultList();
        return requirements;
    }

    @Override
    public ChildEntityDtoResult loadChildForTestCasePaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select rc, r.id from Requirement r join r.children rc left join fetch rc.syncExtender where r.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            List<Requirement> list = this.loadNodeForTestCasePaste((Collection<Long>)v);
        });
    }

    @Override
    public List<Requirement> loadForNodeAddition(Collection<Long> requirementIds) {
        return this.entityManager.createQuery("select req from Requirement req\njoin fetch req.project project\njoin fetch project.requirementCategories\nleft join fetch req.syncExtender\nleft join fetch req.children children\nleft join fetch children.syncExtender\nwhere req.id in :ids", Requirement.class).setParameter("ids", requirementIds).getResultList();
    }

    @Override
    public List<Requirement> loadForVersionsAddition(Collection<Long> requirementIds) {
        return this.entityManager.createQuery("select req from Requirement req join fetch req.resource where req.id in :ids", Requirement.class).setParameter("ids", requirementIds).getResultList();
    }

    @Override
    public List<Requirement> load(Collection<Long> ids) {
        return this.entityManager.createQuery("select r\nfrom Requirement r\nleft join fetch r.syncExtender\nwhere r.id in :ids", Requirement.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public List<HighLevelRequirement> loadHighLevelRequirements(Collection<Long> ids) {
        return this.entityManager.createQuery("select r\nfrom HighLevelRequirement r\nleft join fetch r.syncExtender\nwhere r.id in :ids", HighLevelRequirement.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public Map<Long, List<Requirement>> findRecursiveContentsBySourceIds(Collection<Long> requirementIds) {
        if (requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        CommonTableExpression cte = DSL.name((String)"requirement_child").fields("SOURCE_ID", "DESCENDANT_ID").as((ResultQuery)DSL.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.in(requirementIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"requirement_child", "SOURCE_ID"}), Long.class), (SelectField)Tables.RLN_RELATIONSHIP.DESCENDANT_ID).from(DSL.name((String)"requirement_child")).innerJoin((TableLike)Tables.RLN_RELATIONSHIP).on(DSL.field((Name)DSL.name((String[])new String[]{"requirement_child", "DESCENDANT_ID"}), Long.class).eq((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID))));
        Map parentToChildIdsMap = this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"SOURCE_ID", Long.class), DSL.field((String)"DESCENDANT_ID", Long.class));
        Set<Long> allChildIds = parentToChildIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (allChildIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Requirement> allRequirements = this.load(allChildIds);
        Map requirementById = allRequirements.stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        HashMap<Long, List<Requirement>> parentByRequirements = new HashMap<Long, List<Requirement>>();
        parentToChildIdsMap.forEach((parentId, childIds) -> {
            List<Requirement> childRequirements = childIds.stream().map(requirementById::get).filter(Objects::nonNull).toList();
            if (!childRequirements.isEmpty()) {
                parentByRequirements.put((Long)parentId, childRequirements);
            }
        });
        return parentByRequirements;
    }

    private static final class ExportRequirementDataComparator
    implements Comparator<ExportRequirementData> {
        private ExportRequirementDataComparator() {
        }

        @Override
        public int compare(ExportRequirementData o1, ExportRequirementData o2) {
            int folderCompare = o1.getFolderName().compareTo(o2.getFolderName());
            if (folderCompare != 0) {
                return folderCompare;
            }
            return o1.getRequirementParentPath().compareTo(o2.getRequirementParentPath());
        }
    }

    private static final class SetRequirementsIdParameterCallback
    implements SetQueryParametersCallback {
        private Long requirementId;

        private SetRequirementsIdParameterCallback(Long requirementId) {
            this.requirementId = requirementId;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter(HibernateRequirementDao.REQUIREMENT_ID, (Object)this.requirementId);
        }
    }
}

