/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.service.internal.repository.BoundEntityDao;

@Repository
public class HibernateBoundEntityDao
implements BoundEntityDao {
    @PersistenceContext
    private EntityManager em;

    @Override
    public BoundEntity findBoundEntity(CustomFieldValue customFieldValue) {
        return this.findBoundEntity(customFieldValue.getBoundEntityId(), customFieldValue.getBoundEntityType());
    }

    @Override
    public BoundEntity findBoundEntity(Long boundEntityId, BindableEntity entityType) {
        if (entityType == BindableEntity.CUSTOM_REPORT_FOLDER) {
            Query query = this.em.createNamedQuery("BoundEntityDao.findCurrentCustomReportFoldersId");
            query.setParameter("clnId", (Object)boundEntityId);
            boundEntityId = (Long)query.getSingleResult();
        }
        Class entityClass = entityType.getReferencedClass();
        return (BoundEntity)this.em.getReference(entityClass, (Object)boundEntityId);
    }

    @Override
    public boolean hasCustomField(Long boundEntityId, BindableEntity entityType) {
        Query query = this.em.createNamedQuery("BoundEntityDao.hasCustomFields");
        query.setParameter("boundEntityId", (Object)boundEntityId);
        query.setParameter("boundEntityType", (Object)entityType);
        return (Long)query.getSingleResult() != 0L;
    }
}

