/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.service.internal.bugtracker.Pair;

public interface BugTrackerDao
extends JpaRepository<BugTracker, Long> {
    public Page<BugTracker> findAll(Pageable var1);

    public List<BugTracker> findByKind(String var1);

    @Query
    public List<BugTracker> findDistinctBugTrackersForProjects(@Param(value="projects") List<Long> var1);

    @Query(value="SELECT distinct b\nFROM BugTracker b\nLEFT JOIN Project p ON p.bugTracker = b\nWHERE p.id IN (:projectIds) OR b.kind IN (:kinds)")
    public List<BugTracker> findDistinctBugTrackersForProjectsWithJiraBt(@Param(value="projectIds") List<Long> var1, @Param(value="kinds") List<String> var2);

    public BugTracker findByName(String var1);

    @Query
    public BugTracker findByCampaignLibraryNode(@Param(value="node") CampaignLibraryNode var1);

    @Query
    public BugTracker findByExecution(@Param(value="execution") Execution var1);

    @Query
    public BugTracker findByIteration(@Param(value="iteration") Iteration var1);

    @Query
    public BugTracker findByTestSuite(@Param(value="testSuite") TestSuite var1);

    @Query
    public List<Pair<Execution, BugTracker>> findAllPairsByExecutions(@Param(value="executions") Collection<Execution> var1);

    @Query
    public BugTracker findByExecutionStep(@Param(value="step") ExecutionStep var1);

    @Query(value="delete from BugTracker bt where bt.id in :bugTrackerIds")
    @Modifying
    public void deleteAllByIds(@Param(value="bugTrackerIds") List<Long> var1);

    @Query(value="select bt from Project p join p.bugTracker bt where p.id = :projectId")
    public BugTracker findByProjectId(@Param(value="projectId") long var1);
}

