/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import java.util.List;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.QueryBuilder;
import org.squashtest.tm.service.internal.query.QueryProfile;

class SubQueryBuilder
extends QueryBuilder {
    private Expression<?> subselectProfileJoinExpression;
    private QueryFilterColumn subwhereProfileFilterExpression;

    SubQueryBuilder(QueryColumnPrototypeInstance columnInstance) {
        super(InternalQueryModel.createFor(columnInstance));
    }

    SubQueryBuilder withRootEntity(InternalEntityType type) {
        this.internalQueryModel.withRootEntity(type);
        return this;
    }

    SubQueryBuilder withRootEntity(SpecializedEntityType type) {
        InternalEntityType internalType = InternalEntityType.fromSpecializedType(type);
        this.internalQueryModel.withRootEntity(internalType);
        return this;
    }

    SubQueryBuilder asSubselectQuery() {
        this.profile = QueryProfile.SUBSELECT_QUERY;
        this.internalQueryModel.withProfile(this.profile);
        this.utils.setSubContext(this.generateContextName());
        return this;
    }

    SubQueryBuilder asSubwhereQuery() {
        this.profile = QueryProfile.SUBWHERE_QUERY;
        this.internalQueryModel.withProfile(this.profile);
        this.utils.setSubContext(this.generateContextName());
        return this;
    }

    SubQueryBuilder joinRootEntityOn(Expression<?> mainQueryPath) {
        this.subselectProfileJoinExpression = mainQueryPath;
        return this;
    }

    SubQueryBuilder filterOn(QueryFilterColumn filter) {
        this.subwhereProfileFilterExpression = filter;
        return this;
    }

    @Override
    ExtendedHibernateQuery<?> createQuery() {
        this.checkConfiguration();
        super.createQuery();
        if (this.profile == QueryProfile.SUBSELECT_QUERY) {
            this.joinWithOuterquery();
        }
        if (this.profile == QueryProfile.SUBWHERE_QUERY) {
            this.joinWithOuterquery();
            this.addSubwhereSpecifics();
        }
        return this.detachedQuery;
    }

    private void joinWithOuterquery() {
        Expression<?> outerQueryJoinPath = this.subselectProfileJoinExpression;
        EntityPathBase<?> subQueryJoinPath = this.utils.getQBean(this.internalQueryModel.getRootEntity());
        BooleanOperation joinWhere = Expressions.predicate((Operator)Ops.EQ, (Expression[])new Expression[]{outerQueryJoinPath, subQueryJoinPath});
        this.detachedQuery.where((Predicate)joinWhere);
    }

    private void addSubwhereSpecifics() {
        QueryProjectionColumn projectionColumn = this.internalQueryModel.getProjectionColumns().get(0);
        Expression<?> measureExpr = this.utils.createAsSelect((QueryColumnPrototypeInstance)projectionColumn);
        Operation operation = this.subwhereProfileFilterExpression.getOperation();
        List<Expression<?>> operands = this.utils.createOperands(this.subwhereProfileFilterExpression, operation);
        BooleanExpression predicate = this.utils.createPredicate(operation, measureExpr, projectionColumn.getDataType(), operands.toArray(new Expression[0]));
        if (this.utils.isAggregate(projectionColumn.getOperation())) {
            this.detachedQuery.having((Predicate)predicate);
        } else {
            this.detachedQuery.where((Predicate)predicate);
        }
    }

    private void checkConfiguration() {
        switch (this.profile) {
            case SUBSELECT_QUERY: {
                this.checkSubselectConfiguration();
                break;
            }
            case SUBWHERE_QUERY: {
                this.checkSubwhereConfiguration();
                break;
            }
        }
    }

    private void checkSubselectConfiguration() {
        if (this.subselectProfileJoinExpression == null) {
            throw new IllegalArgumentException("subselect queries must always provide a join with the outer query, please use joinRootEntityOn()");
        }
    }

    private void checkSubwhereConfiguration() {
        if (this.subselectProfileJoinExpression == null) {
            throw new IllegalArgumentException("subwhere queries must always provide a join with the outer query, please use joinRootEntityOn()");
        }
        if (this.subwhereProfileFilterExpression == null) {
            throw new IllegalArgumentException("subwhere queries must always provide a filter on the measure, please use filterOn()");
        }
    }

    private String generateContextName() {
        return Double.toString(Math.random()).substring(2, 5);
    }
}

