/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.internal.dto.pivotdefinition.MilestonePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomFieldPivotImporterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.MilestoneImporterService;

@Service
public class MilestoneImporterServiceImpl
extends AbstractPivotImport
implements MilestoneImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldPivotImporterService.class);
    private final AdminPivotConverterService adminPivotConverterService;
    private final MilestoneDao milestoneDao;
    private final UserDao userDao;
    @PersistenceContext
    private EntityManager entityManager;

    public MilestoneImporterServiceImpl(AdminPivotConverterService adminPivotConverterService, MilestoneDao milestoneDao, UserDao userDao) {
        super(LOGGER);
        this.adminPivotConverterService = adminPivotConverterService;
        this.milestoneDao = milestoneDao;
        this.userDao = userDao;
    }

    @Override
    public void importMilestonesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.MILESTONES, pivotFormatImport, pivotImportMetadata, "milestones", "milestone", this.getMilestoneImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<MilestonePivot> getMilestoneImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<MilestonePivot>(){

            @Override
            public Class<MilestonePivot> getPivotClazz() {
                return MilestonePivot.class;
            }

            @Override
            public void create(List<MilestonePivot> entities) {
                MilestoneImporterServiceImpl.this.createMilestones(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private boolean isDuplicateMilestone(MilestonePivot milestonePivot, Milestone existingMilestones) {
        return existingMilestones.getLabel().equals(milestonePivot.getLabel()) && DateUtils.formatIso8601Date((Date)existingMilestones.getEndDate()).equals(DateUtils.formatIso8601Date((Date)milestonePivot.getDueDate())) && existingMilestones.getStatus().equals((Object)milestonePivot.getStatus());
    }

    private void createMilestones(List<MilestonePivot> milestonePivots, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        List<String> milestoneLabels = milestonePivots.stream().map(MilestonePivot::getLabel).toList();
        List existingMilestone = this.milestoneDao.findByLabelLike(milestoneLabels);
        User currentUser = (User)this.userDao.getReferenceById(pivotImportMetadata.getCurrentUserId());
        milestonePivots.forEach(milestonePivot -> {
            Optional<Milestone> milestoneOptional = existingMilestone.stream().filter(milestone -> this.isDuplicateMilestone((MilestonePivot)milestonePivot, (Milestone)milestone)).findFirst();
            if (milestoneOptional.isPresent()) {
                MilestoneImporterServiceImpl.logMilestoneAlreadyExistsInSquash(milestonePivot, pivotFormatImport);
                pivotImportMetadata.getMilestoneIdsMap().put(milestonePivot.getPivotId(), milestoneOptional.get().getId());
            } else {
                this.createMilestone((MilestonePivot)milestonePivot, currentUser, existingMilestone, pivotFormatImport, pivotImportMetadata);
            }
        });
        milestonePivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createMilestone(MilestonePivot milestonePivot, User currentUser, List<Milestone> existingMilestone, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "milestone", milestonePivot.getPivotId(), pivotFormatImport);
        try {
            Milestone milestone = this.adminPivotConverterService.pivotToMilestone(milestonePivot, pivotImportMetadata);
            milestone.setOwner(currentUser);
            this.fixLabelClash(milestone, existingMilestone);
            this.milestoneDao.save(milestone);
            pivotImportMetadata.getMilestoneIdsMap().put(milestonePivot.getPivotId(), milestone.getId());
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "custom field", milestonePivot.getLabel(), milestonePivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "custom field", milestonePivot.getLabel(), milestonePivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private void fixLabelClash(Milestone milestone, List<Milestone> existingMilestone) {
        String newLabel = LibraryUtils.generateNonClashingName(milestone.getLabel(), existingMilestone.stream().map(Milestone::getLabel).toList(), 30);
        if (!newLabel.equals(milestone.getLabel())) {
            milestone.setLabel(newLabel);
        }
    }

    private static void logMilestoneAlreadyExistsInSquash(MilestonePivot milestonePivot, PivotFormatImport pivotFormatImport) {
        LOGGER.info("Import id {} - Milestone \"{}\" with internal id {} already exists in Squash. Import will use the existing milestone.", new Object[]{pivotFormatImport.getId(), milestonePivot.getLabel(), milestonePivot.getPivotId()});
    }
}

