/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItemDto;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEvent;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.internal.attachment.AttachmentManagerServiceImpl;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.DenormalizedValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionEventPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionNotePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionOverviewPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintReqVersionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.ContentConversionPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.TestSuiteInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.AttachmentDao;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;

@Service
public class ExecutionWorkspacePivotImporterServiceImpl
extends AbstractPivotImport
implements ExecutionWorkspacePivotImporterService {
    private static final Logger LOGGER;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final PrivateCustomFieldValueService privateCustomFieldValueService;
    private final CustomIterationModificationService customIterationModificationService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final TestPlanItemDao testPlanItemDao;
    private final RequirementVersionDao requirementVersionDao;
    private final TestCaseDao testCaseDao;
    private final TestStepDao testStepDao;
    private final CustomFieldValueDao customFieldValueDao;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final AttachmentDao attachmentDao;
    private final MilestoneDao milestoneDao;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        ExecutionWorkspacePivotImporterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ExecutionWorkspacePivotImporterService.class);
    }

    public ExecutionWorkspacePivotImporterServiceImpl(CampaignLibraryNavigationService campaignLibraryNavigationService, PrivateCustomFieldValueService privateCustomFieldValueService, CustomIterationModificationService customIterationModificationService, AttachmentPivotImportService attachmentPivotImportService, ExecutionWorkspaceConverterService executionWorkspaceConverterService, AdminPivotConverterService adminPivotConverterService, TestPlanItemDao testPlanItemDao, RequirementVersionDao requirementVersionDao, TestCaseDao testCaseDao, TestStepDao testStepDao, CustomFieldValueDao customFieldValueDao, PrivateCustomFieldValueService customFieldValueService, AttachmentDao attachmentDao, MilestoneDao milestoneDao) {
        super(LOGGER);
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.privateCustomFieldValueService = privateCustomFieldValueService;
        this.customIterationModificationService = customIterationModificationService;
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.testPlanItemDao = testPlanItemDao;
        this.requirementVersionDao = requirementVersionDao;
        this.testCaseDao = testCaseDao;
        this.testStepDao = testStepDao;
        this.customFieldValueDao = customFieldValueDao;
        this.customFieldValueService = customFieldValueService;
        this.attachmentDao = attachmentDao;
        this.milestoneDao = milestoneDao;
    }

    private <I extends InputStream, P extends AbstractPivotObject> void validateExecutionStatus(I zis, JsonImportFile jsonImportFile, Class<P> clz, BiConsumer<P, Set<ExecutionStatus>> gatherExecutionStatus, Set<ExecutionStatus> disabledExecutionStatuses, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        HashSet pivotExecutionStatus = new HashSet();
        this.parseEntities(zis, jsonImportFile, jsonImportFile.getJsonFieldKind(), clz, pivotEntity -> gatherExecutionStatus.accept(pivotEntity, pivotExecutionStatus));
        List<ExecutionStatus> executionStatusConflict = pivotExecutionStatus.stream().filter(disabledExecutionStatuses::contains).toList();
        pivotMetaDataModel.addAllExecutionStatusConflicts(executionStatusConflict);
    }

    @Override
    public <I extends InputStream> void validateExecutionStatusFromIteration(I zis, Set<ExecutionStatus> disabledExecutionStatuses, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        this.validateExecutionStatus(zis, JsonImportFile.ITERATIONS, IterationPivot.class, this::gatherExecutionStatus, disabledExecutionStatuses, pivotMetaDataModel);
    }

    @Override
    public <I extends InputStream> void validateExecutionStatusFromTestSuite(I zis, Set<ExecutionStatus> disabledExecutionStatuses, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        this.validateExecutionStatus(zis, JsonImportFile.TEST_SUITES, TestSuitePivot.class, this::gatherExecutionStatus, disabledExecutionStatuses, pivotMetaDataModel);
    }

    @Override
    public <I extends InputStream> void validateExecutionStatusFromSprint(I zis, Set<ExecutionStatus> disabledExecutionStatuses, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        this.validateExecutionStatus(zis, JsonImportFile.SPRINTS, SprintPivot.class, this::gatherExecutionStatus, disabledExecutionStatuses, pivotMetaDataModel);
    }

    @Override
    public <I extends InputStream> void validateExecutionStatusFromExecution(I zis, Set<ExecutionStatus> disabledExecutionStatuses, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        this.validateExecutionStatus(zis, JsonImportFile.EXECUTIONS, ExecutionPivot.class, this::gatherExecutionStatus, disabledExecutionStatuses, pivotMetaDataModel);
    }

    private void gatherExecutionStatus(IterationPivot iterationPivot, Set<ExecutionStatus> executionStatus) {
        iterationPivot.getTestPlanItems().forEach(testPlanItem -> {
            boolean bl = executionStatus.add(testPlanItem.getExecutionStatus());
        });
    }

    private void gatherExecutionStatus(TestSuitePivot testSuitePivot, Set<ExecutionStatus> executionStatus) {
        executionStatus.add(testSuitePivot.getStatus());
    }

    private void gatherExecutionStatus(SprintPivot sprintPivot, Set<ExecutionStatus> executionStatus) {
        sprintPivot.getSprintReqVersions().forEach(reqVersion -> reqVersion.getTestPlanItems().forEach(testPlanItem -> {
            boolean bl = executionStatus.add(testPlanItem.getExecutionStatus());
        }));
    }

    private void gatherExecutionStatus(ExecutionPivot executionPivot, Set<ExecutionStatus> executionStatus) {
        executionStatus.add(executionPivot.getStatus());
        executionPivot.getExecutionSteps().forEach(step -> {
            boolean bl = executionStatus.add(step.getStatus());
        });
    }

    @Override
    public void importCampaignsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CAMPAIGNS, pivotFormatImport, pivotImportMetadata, "campaigns", "campaign", this.getCampaignPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CampaignPivot> getCampaignPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CampaignPivot>(){

            @Override
            public Class<CampaignPivot> getPivotClazz() {
                return CampaignPivot.class;
            }

            @Override
            public void create(List<CampaignPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createCampaigns(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createCampaigns(List<CampaignPivot> campaignPivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<Campaign, Map<Long, RawValue>> customFieldByCampaign = new HashMap<Campaign, Map<Long, RawValue>>();
        Map<Long, Milestone> milestoneById = this.getMilestoneFromCampaignPivots(campaignPivots, pivotImportMetadata);
        for (CampaignPivot campaignPivot : campaignPivots) {
            this.createCampaign(campaignPivot, customFieldByCampaign, milestoneById, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
        this.customFieldValueService.initBatchCustomFieldValues(customFieldByCampaign);
        campaignPivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCampaign(CampaignPivot campaignPivot, Map<Campaign, Map<Long, RawValue>> customFieldByCampaign, Map<Long, Milestone> milestoneById, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long squashFolderTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(campaignPivot.getParentId());
        Campaign campaign = this.executionWorkspaceConverterService.pivotToCampaign(campaignPivot);
        switch (campaignPivot.getParentType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addCampaignToCampaignLibraryUnsecuredWithoutMilestone(projectIdsReferences.getCampaignLibraryId(), campaign);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addCampaignToCampaignFolderUnsecuredWithoutMilestone(squashFolderTargetId, campaign);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity has an entity type that is not handled " + String.valueOf(campaignPivot.getParentType()));
            }
        }
        pivotImportMetadata.getCampaignIdsMap().put(campaignPivot.getPivotId(), campaign.getId());
        List<TestPlanItemDto> testPlanItemDtos = this.getTestPlanItemDtos(campaignPivot.getTestPlanItems(), null, Collections.emptyMap(), EntityType.CAMPAIGN, pivotImportMetadata, pivotFormatImport);
        this.addTestPlanItemToCampaign(testPlanItemDtos, campaign);
        Map<Long, RawValue> customFields = this.handleAttachmentAuditable(campaign, campaignPivot, pivotImportMetadata, pivotFormatImport);
        this.handleMilestone(milestoneById, campaign, campaignPivot, pivotImportMetadata);
        customFieldByCampaign.put(campaign, customFields);
    }

    private void addTestPlanItemToCampaign(List<TestPlanItemDto> testPlanItemDtos, Campaign campaign) {
        testPlanItemDtos.forEach(tpi -> {
            CampaignTestPlanItem campaignTestPlanItem = new CampaignTestPlanItem(tpi.referencedTestCase(), tpi.referencedDataset());
            campaign.addToTestPlan(campaignTestPlanItem);
        });
    }

    private Map<Long, RawValue> handleAttachmentAuditable(Campaign campaign, CampaignPivot campaignPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        campaign.setReadOnlyModifyAudit(campaignPivot.getLastModifiedBy(), campaignPivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<Campaign, CampaignPivot>(campaignPivot, campaign), pivotImportMetadata, pivotFormatImport);
        String description = campaign.getDescription();
        campaign.setDescription(this.attachmentPivotImportService.updateRichText(description, campaign.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        return this.adminPivotConverterService.pivotToCustomFieldValues(campaignPivot, campaign, attachmentsConversion, pivotImportMetadata);
    }

    private Map<Long, Milestone> getMilestoneFromCampaignPivots(List<CampaignPivot> campaignPivots, PivotImportMetadata pivotImportMetadata) {
        List<Long> milestoneIds = campaignPivots.stream().flatMap(campaignPivot -> campaignPivot.getMilestones().stream()).map(pivotId -> pivotImportMetadata.getMilestoneIdsMap().get(pivotId)).filter(Objects::nonNull).toList();
        return this.milestoneDao.findAllById(milestoneIds).stream().collect(Collectors.toMap(Milestone::getId, Function.identity()));
    }

    private void handleMilestone(Map<Long, Milestone> milestoneById, Campaign campaign, CampaignPivot campaignPivot, PivotImportMetadata pivotImportMetadata) {
        campaignPivot.getMilestones().forEach(pivotId -> {
            Long milestoneId = pivotImportMetadata.getMilestoneIdsMap().get(pivotId);
            Milestone milestone = (Milestone)milestoneById.get(milestoneId);
            campaign.bindMilestone(milestone);
        });
    }

    @Override
    public void importIterationsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.ITERATIONS, pivotFormatImport, pivotImportMetadata, "iterations", "iteration", this.getIterationPivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<IterationPivot> getIterationPivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<IterationPivot>(){

            @Override
            public Class<IterationPivot> getPivotClazz() {
                return IterationPivot.class;
            }

            @Override
            public void create(List<IterationPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createIterations(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createIterations(List<IterationPivot> iterationPivots, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<Iteration, Map<Long, RawValue>> customFieldByIteration = new HashMap<Iteration, Map<Long, RawValue>>();
        List<SessionOverviewPivot> sessionOverviewPivots = iterationPivots.stream().flatMap(iterationPivot -> iterationPivot.getTestPlanItems().stream().map(TestPlanItemPivot::getSessionOverview).filter(Objects::nonNull)).toList();
        Map<Long, ContentConversionPivotHolder> attachmentByOldContentId = this.sessionOverviewAttachmentCorrection(sessionOverviewPivots, pivotImportMetadata);
        for (IterationPivot iterationPivot2 : iterationPivots) {
            this.createIteration(iterationPivot2, customFieldByIteration, attachmentByOldContentId, pivotImportMetadata, pivotFormatImport);
        }
        this.customFieldValueService.initBatchCustomFieldValues(customFieldByIteration);
        iterationPivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createIteration(IterationPivot iterationPivot, Map<Iteration, Map<Long, RawValue>> customFieldByIteration, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long squashTargetId = pivotImportMetadata.getCampaignIdsMap().get(iterationPivot.getParentId());
        Iteration iteration = this.executionWorkspaceConverterService.pivotToIteration(iterationPivot);
        this.customIterationModificationService.addIterationToCampaignUnsecured(iteration, squashTargetId, false);
        TestPlan testPlan = iteration.getTestPlan();
        pivotImportMetadata.getIterationIdsMap().put(iterationPivot.getPivotId(), iteration.getId());
        List<TestPlanItemDto> testPlanItemDtos = this.getTestPlanItemDtos(iterationPivot.getTestPlanItems(), testPlan, attachmentByOldContentId, EntityType.ITERATION, pivotImportMetadata, pivotFormatImport);
        this.addTestPlanItemToTestPlan(testPlanItemDtos, testPlan, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.handleAttachmentAuditable(iteration, iterationPivot, pivotImportMetadata, pivotFormatImport);
        customFieldByIteration.put(iteration, customFields);
    }

    private Map<Long, RawValue> handleAttachmentAuditable(Iteration iteration, IterationPivot iterationPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        iteration.setReadOnlyModifyAudit(iterationPivot.getLastModifiedBy(), iterationPivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<Iteration, IterationPivot>(iterationPivot, iteration), pivotImportMetadata, pivotFormatImport);
        String description = iteration.getDescription();
        iteration.setDescription(this.attachmentPivotImportService.updateRichText(description, iteration.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        return this.adminPivotConverterService.pivotToCustomFieldValues(iterationPivot, iteration, attachmentsConversion, pivotImportMetadata);
    }

    private void addTestPlanItemToTestPlan(List<TestPlanItemDto> testPlanItemDtos, TestPlan testPlan, PivotImportMetadata pivotImportMetadata) {
        testPlanItemDtos.forEach(tpi -> this.addTestPlanItemToTestPlan((TestPlanItemDto)tpi, testPlan, pivotImportMetadata));
    }

    private void addTestPlanItemToTestPlan(TestPlanItemDto testPlanItemDto, TestPlan testPlan, PivotImportMetadata pivotImportMetadata) {
        TestPlanItem testPlanItem = TestPlanItem.createItem((TestPlanItemDto)testPlanItemDto);
        testPlan.addItem(testPlanItem, null);
        this.entityManager.persist((Object)testPlanItem);
        testPlanItem.setUnsafeLastExecutedOn(testPlanItemDto.lastExecutedOn());
        testPlanItem.setUnsafeLastExecutedBy(testPlanItemDto.lastExecutedBy());
        testPlanItem.setReadOnlyModifyAudit(testPlanItemDto.lastModifiedBy(), testPlanItemDto.lastModifiedOn());
        pivotImportMetadata.getTestPlanItemIdsMap().put(testPlanItemDto.key(), testPlanItem.getId());
    }

    private List<TestPlanItemDto> getTestPlanItemDtos(List<TestPlanItemPivot> testPlanItemPivots, TestPlan testPlan, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, EntityType holderType, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Set testCaseIds = testPlanItemPivots.stream().map(tpi -> pivotImportMetadata.getTestCaseIdsMap().get(tpi.getTestCaseId())).collect(Collectors.toSet());
        Map testCaseByIds = this.testCaseDao.findTestCasesWithDatasetsByIds(testCaseIds);
        return testPlanItemPivots.stream().map(testPlanItemPivot -> this.getTestPlanItemDto((TestPlanItemPivot)testPlanItemPivot, testPlan, testCaseByIds, attachmentByOldContentId, holderType, pivotImportMetadata, pivotFormatImport)).toList();
    }

    private TestPlanItemDto getTestPlanItemDto(TestPlanItemPivot testPlanItemPivot, TestPlan testPlan, Map<Long, TestCase> testCaseByIds, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, EntityType holderType, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        TestCase referencedTestCase = null;
        Dataset referencedDataset = null;
        ExploratorySessionOverview sessionOverview = null;
        if (Objects.nonNull(testPlanItemPivot.getTestCaseId())) {
            Long testCaseId = pivotImportMetadata.getTestCaseIdsMap().get(testPlanItemPivot.getTestCaseId());
            referencedTestCase = testCaseByIds.get(testCaseId);
            if (testPlanItemPivot.getDatasetId() != null) {
                Long datasetId = pivotImportMetadata.getDatasetIdsMap().get(testPlanItemPivot.getDatasetId());
                referencedDataset = referencedTestCase.getDatasets().stream().filter(d -> d.getId().equals(datasetId)).findFirst().orElse(null);
            }
        }
        if (Objects.nonNull(testPlanItemPivot.getSessionOverview())) {
            sessionOverview = this.executionWorkspaceConverterService.pivotToExploratorySessionOverview(testPlanItemPivot.getSessionOverview());
            this.entityManager.persist((Object)sessionOverview);
            this.handleAttachmentsAndRichText(sessionOverview, testPlanItemPivot.getSessionOverview(), attachmentByOldContentId, holderType, pivotImportMetadata, pivotFormatImport);
        }
        return TestPlanItemDto.builder().withReferencedTestCase(referencedTestCase).withReferencedDataset(referencedDataset).withLabel(testPlanItemPivot.getTestCaseLabel()).withCreatedBy(testPlanItemPivot.getCreatedBy()).withCreatedOn(testPlanItemPivot.getCreatedOn()).withLastModifiedBy(testPlanItemPivot.getLastModifiedBy()).withLastModifiedOn(testPlanItemPivot.getLastModifiedOn()).withLastExecutedBy(testPlanItemPivot.getLastExecutedBy()).withLastExecutedOn(testPlanItemPivot.getLastExecutedOn()).withExecutionStatus(this.executionWorkspaceConverterService.getAvailableStatus(testPlanItemPivot.getExecutionStatus(), pivotImportMetadata)).withKey(testPlanItemPivot.getPivotId()).withTestPlan(testPlan).withAssignee(null).withExploratorySessionOverview(sessionOverview).build();
    }

    private void handleAttachmentsAndRichText(ExploratorySessionOverview sessionOverview, SessionOverviewPivot sessionOverviewPivot, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, EntityType holderType, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<ExploratorySessionOverview, SessionOverviewPivot>(sessionOverviewPivot, sessionOverview, holderType, attachmentByOldContentId), pivotImportMetadata, pivotFormatImport);
        String comments = sessionOverview.getComments();
        sessionOverview.setUnsafeComments(this.attachmentPivotImportService.updateRichText(comments, sessionOverview.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String charter = sessionOverview.getCharter();
        sessionOverview.setCharter(this.attachmentPivotImportService.updateRichText(charter, sessionOverview.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
    }

    @Override
    public void importTestSuitesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.TEST_SUITES, pivotFormatImport, pivotImportMetadata, "test suites", "test suite", this.getTestSuitePivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<TestSuitePivot> getTestSuitePivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<TestSuitePivot>(){

            @Override
            public Class<TestSuitePivot> getPivotClazz() {
                return TestSuitePivot.class;
            }

            @Override
            public void create(List<TestSuitePivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createTestSuites(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createTestSuites(List<TestSuitePivot> testSuitePivots, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<TestSuite, Map<Long, RawValue>> customFieldByTestSuite = new HashMap<TestSuite, Map<Long, RawValue>>();
        for (TestSuitePivot testSuitePivot : testSuitePivots) {
            this.createTestSuite(testSuitePivot, customFieldByTestSuite, pivotImportMetadata, pivotFormatImport);
        }
        this.customFieldValueService.initBatchCustomFieldValues(customFieldByTestSuite);
        testSuitePivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createTestSuite(TestSuitePivot testSuitePivot, Map<TestSuite, Map<Long, RawValue>> customFieldByTestSuite, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long squashTargetId = pivotImportMetadata.getIterationIdsMap().get(testSuitePivot.getParentId());
        TestSuite testSuite = this.executionWorkspaceConverterService.pivotToTestSuite(testSuitePivot, pivotImportMetadata);
        this.customIterationModificationService.addTestSuiteUnsecuredWithoutMilestone(squashTargetId, testSuite);
        pivotImportMetadata.getTestSuiteIdsMap().put(testSuitePivot.getPivotId(), new TestSuiteInfo(testSuite.getId(), testSuitePivot.getStatus()));
        this.bindTestPlanItemsToTestSuite(testSuitePivot.getTestPlanItemBindings(), pivotImportMetadata, testSuite);
        Map<Long, RawValue> customFields = this.handleAttachmentsAuditable(testSuite, testSuitePivot, pivotImportMetadata, pivotFormatImport);
        customFieldByTestSuite.put(testSuite, customFields);
    }

    private Map<Long, RawValue> handleAttachmentsAuditable(TestSuite testSuite, TestSuitePivot testSuitePivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        testSuite.setReadOnlyModifyAudit(testSuitePivot.getLastModifiedBy(), testSuitePivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<TestSuite, TestSuitePivot>(testSuitePivot, testSuite), pivotImportMetadata, pivotFormatImport);
        String description = testSuite.getDescription();
        testSuite.setDescription(this.attachmentPivotImportService.updateRichText(description, testSuite.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        return this.adminPivotConverterService.pivotToCustomFieldValues(testSuitePivot, testSuite, attachmentsConversion, pivotImportMetadata);
    }

    private void bindTestPlanItemsToTestSuite(List<String> testPlanItemBindings, PivotImportMetadata pivotImportMetadata, TestSuite testSuite) {
        List<Long> testPlanItemIds = testPlanItemBindings.stream().map(internalId -> pivotImportMetadata.getTestPlanItemIdsMap().get(internalId)).toList();
        testSuite.bindTestPlanItemsById(testPlanItemIds);
    }

    @Override
    public void importSprintsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.SPRINTS, pivotFormatImport, pivotImportMetadata, "sprints", "sprint", this.getSprintPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<SprintPivot> getSprintPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<SprintPivot>(){

            @Override
            public Class<SprintPivot> getPivotClazz() {
                return SprintPivot.class;
            }

            @Override
            public void create(List<SprintPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createSprints(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createSprints(List<SprintPivot> sprintPivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Set requirementVersionIds;
        Set set = requirementVersionIds = sprintPivots.stream().flatMap(sprintPivot -> sprintPivot.getSprintReqVersions().stream()).map(SprintReqVersionPivot::getRequirementVersionId).filter(Objects::nonNull).map(requirementVersionId -> pivotImportMetadata.getRequirementVersionIdsMap().get(requirementVersionId)).collect(Collectors.toSet());
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, set);
        Object[] objectArray = new Object[]{this, requirementVersionDao, set, joinPoint};
        ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1 executionWorkspacePivotImporterServiceImpl$AjcClosure1 = new ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1(objectArray);
        Map<Long, RequirementVersion> requirementVersionByIds = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(executionWorkspacePivotImporterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.toMap(Resource::getId, Function.identity()));
        HashMap<Sprint, Map<Long, RawValue>> customFieldBySprint = new HashMap<Sprint, Map<Long, RawValue>>();
        List<SessionOverviewPivot> sessionOverviewPivots = sprintPivots.stream().flatMap(sprintPivot -> sprintPivot.getSprintReqVersions().stream().flatMap(srv -> srv.getTestPlanItems().stream().map(TestPlanItemPivot::getSessionOverview).filter(Objects::nonNull))).toList();
        Map<Long, ContentConversionPivotHolder> attachmentByOldContentId = this.sessionOverviewAttachmentCorrection(sessionOverviewPivots, pivotImportMetadata);
        for (SprintPivot sprintPivot2 : sprintPivots) {
            this.createSprint(sprintPivot2, requirementVersionByIds, customFieldBySprint, attachmentByOldContentId, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
        this.customFieldValueService.initBatchCustomFieldValues(customFieldBySprint);
        sprintPivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createSprint(SprintPivot sprintPivot, Map<Long, RequirementVersion> requirementVersionByIds, Map<Sprint, Map<Long, RawValue>> customFieldBySprint, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Long squashFolderTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(sprintPivot.getParentId());
        Sprint sprint = this.executionWorkspaceConverterService.pivotToSprint(sprintPivot);
        switch (sprintPivot.getParentType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addSprintToCampaignLibrary(projectIdsReferences.getCampaignLibraryId(), sprint);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintToCampaignFolderUnsecured(squashFolderTargetId, sprint);
                break;
            }
            case SPRINT_GROUP: {
                this.campaignLibraryNavigationService.addSprintToSprintGroupUnsecured(squashFolderTargetId, sprint);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity has an entity type that is not handled " + String.valueOf(sprintPivot.getParentType()));
            }
        }
        sprintPivot.getSprintReqVersions().forEach(sprintReqVersionPivot -> this.createSprintVersion((SprintReqVersionPivot)sprintReqVersionPivot, sprint, requirementVersionByIds, attachmentByOldContentId, pivotImportMetadata, pivotFormatImport));
        pivotImportMetadata.getSprintIdsMap().put(sprintPivot.getPivotId(), sprint.getId());
        Map<Long, RawValue> customFields = this.handleAttachmentAuditable(sprint, sprintPivot, pivotImportMetadata, pivotFormatImport);
        customFieldBySprint.put(sprint, customFields);
    }

    private void createSprintVersion(SprintReqVersionPivot sprintReqVersionPivot, Sprint sprint, Map<Long, RequirementVersion> requirementVersionByIds, Map<Long, ContentConversionPivotHolder> attachmentByOldContentId, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        SprintReqVersion sprintReqVersion = this.executionWorkspaceConverterService.pivotToSprintReqVersion(sprint, sprintReqVersionPivot);
        sprintReqVersion.setRequirementVersion(requirementVersionByIds.get(pivotImportMetadata.getRequirementVersionIdsMap().get(sprintReqVersionPivot.getRequirementVersionId())));
        this.entityManager.persist((Object)sprintReqVersion);
        sprintReqVersion.setReadOnlyModifyAudit(sprintReqVersionPivot.getLastModifiedBy(), sprintReqVersionPivot.getLastModifiedOn());
        TestPlan testPlan = sprintReqVersion.getTestPlan();
        List<TestPlanItemDto> testPlanItemDtos = this.getTestPlanItemDtos(sprintReqVersionPivot.getTestPlanItems(), testPlan, attachmentByOldContentId, EntityType.SPRINT, pivotImportMetadata, pivotFormatImport);
        this.addTestPlanItemToTestPlan(testPlanItemDtos, testPlan, pivotImportMetadata);
    }

    private Map<Long, RawValue> handleAttachmentAuditable(Sprint sprint, SprintPivot sprintPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        sprint.setReadOnlyModifyAudit(sprintPivot.getLastModifiedBy(), sprintPivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<Sprint, SprintPivot>(sprintPivot, sprint), pivotImportMetadata, pivotFormatImport);
        String description = sprint.getDescription();
        sprint.setDescription(this.attachmentPivotImportService.updateRichText(description, sprint.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        return this.adminPivotConverterService.pivotToCustomFieldValues(sprintPivot, sprint, attachmentsConversion, pivotImportMetadata);
    }

    @Override
    public void importExecutionsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.EXECUTIONS, pivotFormatImport, pivotImportMetadata, "executions", "execution", this.getExecutionPivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<ExecutionPivot> getExecutionPivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<ExecutionPivot>(){

            @Override
            public Class<ExecutionPivot> getPivotClazz() {
                return ExecutionPivot.class;
            }

            @Override
            public void create(List<ExecutionPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createExecutions(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createExecutions(List<ExecutionPivot> executionPivots, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        ExecutionBatchLoad executionBatchLoad = this.getExecutionBatchLoad(executionPivots, pivotImportMetadata);
        for (ExecutionPivot executionPivot : executionPivots) {
            this.createExecution(executionPivot, executionBatchLoad, pivotImportMetadata, pivotFormatImport);
        }
        executionPivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createExecution(ExecutionPivot executionPivot, ExecutionBatchLoad executionBatchLoad, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        TestPlanItem testPlanItem = executionBatchLoad.getTestPlanItem(executionPivot, pivotImportMetadata);
        Execution execution = this.executionWorkspaceConverterService.pivotToExecution(executionPivot, pivotImportMetadata);
        execution.setUnsafeReferencedTestCase(testPlanItem.getReferencedTestCase());
        execution.setTestPlanItem(testPlanItem);
        if (execution instanceof ExploratoryExecution) {
            ExploratoryExecution exploratoryExecution = (ExploratoryExecution)execution;
            this.addSessionNote(exploratoryExecution, executionPivot, pivotImportMetadata, pivotFormatImport);
        } else {
            execution.getSteps().addAll(this.createExecutionSteps(executionPivot, executionBatchLoad, pivotImportMetadata, pivotFormatImport));
            this.entityManager.persist((Object)execution);
        }
        execution.setLastExecutedBy(executionPivot.getLastExecutedBy());
        execution.setLastExecutedOn(executionPivot.getLastExecutedOn());
        this.handleAttachmentAuditableCuf(execution, executionPivot, executionBatchLoad, pivotImportMetadata, pivotFormatImport);
    }

    private void handleAttachmentAuditableCuf(Execution execution, ExecutionPivot executionPivot, ExecutionBatchLoad executionBatchLoad, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        execution.setReadOnlyModifyAudit(executionPivot.getLastModifiedBy(), executionPivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<Execution, ExecutionPivot>(executionPivot, execution, executionBatchLoad.getAttachmentByOldContentId(executionPivot, pivotImportMetadata)), pivotImportMetadata, pivotFormatImport);
        this.updateRichText(execution, attachmentsConversion, pivotImportMetadata);
        this.createExecutionDenormalized(execution, executionPivot, executionBatchLoad.cfvIdByTestCaseIdsAndCFId(), attachmentsConversion, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(executionPivot, execution, attachmentsConversion, pivotImportMetadata);
        this.privateCustomFieldValueService.createAllCustomFieldValues((BoundEntity)execution, (GenericProject)pivotFormatImport.getProject(), customFields);
    }

    private void updateRichText(Execution execution, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        String comment = execution.getDescription();
        execution.setDescription(this.attachmentPivotImportService.updateRichText(comment, execution.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String prerequisite = execution.getPrerequisite();
        execution.setPrerequisite(this.attachmentPivotImportService.updateRichText(prerequisite, execution.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String description = execution.getTcdescription();
        execution.setTcdescription(this.attachmentPivotImportService.updateRichText(description, execution.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
    }

    private void createDenormalizedFieldValue(List<DenormalizedValuePivot> denormalizedValuePivots, Map<Long, CustomFieldValue> cfvByCFId, Long holderId, DenormalizedFieldHolderType holderType, Map<Long, Long> attachmentsConversion, AttachmentList attachmentList, PivotImportMetadata pivotImportMetadata) {
        denormalizedValuePivots.forEach(dv -> {
            String cfPivotId = dv.getCustomFieldId();
            CustomFieldValue customFieldValue = null;
            if (Objects.nonNull(cfvByCFId) && Objects.nonNull(cfPivotId)) {
                Long cfId = pivotImportMetadata.getCustomFieldIdsMap().get(cfPivotId).id();
                customFieldValue = (CustomFieldValue)cfvByCFId.get(cfId);
            }
            if (InputType.RICH_TEXT.equals((Object)dv.getInputType())) {
                String value = dv.getValue();
                dv.setValue(this.attachmentPivotImportService.updateRichText(value, attachmentList, attachmentsConversion, pivotImportMetadata));
            }
            DenormalizedFieldValue denormalizedFieldValue = this.executionWorkspaceConverterService.pivotToDenormalizedFieldValue((DenormalizedValuePivot)dv, holderId, holderType, customFieldValue);
            this.entityManager.persist((Object)denormalizedFieldValue);
        });
    }

    private void createExecutionDenormalized(Execution execution, ExecutionPivot executionPivot, Map<Long, Map<Long, CustomFieldValue>> cfvIdByTestCaseIdsAndCFId, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        TestCase referencedTestCase = execution.getReferencedTestCase();
        Map<Long, CustomFieldValue> cfvByCFId = Objects.nonNull(referencedTestCase) ? cfvIdByTestCaseIdsAndCFId.get(referencedTestCase.getId()) : null;
        this.createDenormalizedFieldValue(executionPivot.getDenormalizedValues(), cfvByCFId, execution.getId(), DenormalizedFieldHolderType.EXECUTION, attachmentsConversion, execution.getAttachmentList(), pivotImportMetadata);
    }

    private void addSessionNote(ExploratoryExecution exploratoryExecution, ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        List<ExploratoryExecutionEvent> events = executionPivot.getSessionEventPivots().stream().map(sessionEventPivot -> {
            ExploratoryExecutionEvent exploratoryExecutionEvent = this.executionWorkspaceConverterService.pivotToExploratoryExecutionEvent((SessionEventPivot)sessionEventPivot);
            exploratoryExecutionEvent.setExploratoryExecution(exploratoryExecution);
            return exploratoryExecutionEvent;
        }).toList();
        exploratoryExecution.getEvents().addAll(events);
        Map sessionNotes = executionPivot.getSessionNotePivots().stream().collect(Collectors.toMap(sessionNotePivot -> {
            SessionNote sessionNote = this.executionWorkspaceConverterService.pivotToSessionNote((SessionNotePivot)sessionNotePivot);
            sessionNote.setExecution(exploratoryExecution);
            return sessionNote;
        }, Function.identity()));
        exploratoryExecution.getSessionNotes().addAll(sessionNotes.keySet());
        this.entityManager.persist((Object)exploratoryExecution);
        sessionNotes.forEach((sessionNote, sessionNotePivot) -> this.handleAttachmentAuditable((SessionNote)sessionNote, (SessionNotePivot)sessionNotePivot, pivotImportMetadata, pivotFormatImport));
    }

    private void handleAttachmentAuditable(SessionNote sessionNote, SessionNotePivot sessionNotePivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        sessionNote.setReadOnlyModifyAudit(sessionNotePivot.getLastModifiedBy(), sessionNotePivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<SessionNote, SessionNotePivot>(sessionNotePivot, sessionNote), pivotImportMetadata, pivotFormatImport);
        String content = sessionNote.getContent();
        sessionNote.setContent(this.attachmentPivotImportService.updateRichText(content, sessionNote.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
    }

    private List<ExecutionStep> createExecutionSteps(ExecutionPivot executionPivot, ExecutionBatchLoad executionBatchLoad, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        return executionPivot.getExecutionSteps().stream().map(executionStepPivot -> this.createExecutionStep((ExecutionStepPivot)executionStepPivot, executionBatchLoad, pivotImportMetadata, pivotFormatImport)).toList();
    }

    private ExecutionStep createExecutionStep(ExecutionStepPivot executionStepPivot, ExecutionBatchLoad executionBatchLoad, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        ExecutionStep executionStep = this.executionWorkspaceConverterService.pivotToExecutionStep(executionStepPivot, pivotImportMetadata);
        if (executionStepPivot.getTestStepId() != null && executionBatchLoad.testStepsById() != null) {
            Long testStepId = pivotImportMetadata.getTestStepsIdsMap().get(executionStepPivot.getTestStepId());
            TestStep testStep = executionBatchLoad.testStepsById().get(testStepId);
            executionStep.setUnsafeReferencedTestStep(testStep);
        }
        this.entityManager.persist((Object)executionStep);
        executionStep.setLastExecutedBy(executionStepPivot.getLastExecutedBy());
        executionStep.setLastExecutedOn(executionStepPivot.getLastExecutedOn());
        this.handleAttachmentAuditableCuf(executionStep, executionStepPivot, executionBatchLoad, pivotImportMetadata, pivotFormatImport);
        return executionStep;
    }

    private void createExecutionStepDenormalized(ExecutionStep executionStep, ExecutionStepPivot executionStepPivot, ExecutionBatchLoad executionBatchLoad, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        TestStep referencedTestStep = executionStep.getReferencedTestStep();
        Map<Long, CustomFieldValue> cfvByCFId = Objects.nonNull(referencedTestStep) ? executionBatchLoad.cfvIdByTestStepIdsAndCFId().get(referencedTestStep.getId()) : null;
        this.createDenormalizedFieldValue(executionStepPivot.getDenormalizedValues(), cfvByCFId, executionStep.getId(), DenormalizedFieldHolderType.EXECUTION_STEP, attachmentsConversion, executionStep.getAttachmentList(), pivotImportMetadata);
    }

    private void handleAttachmentAuditableCuf(ExecutionStep executionStep, ExecutionStepPivot executionStepPivot, ExecutionBatchLoad executionBatchLoad, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        executionStep.setReadOnlyModifyAudit(executionStepPivot.getLastModifiedBy(), executionStepPivot.getLastModifiedOn());
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<ExecutionStep, ExecutionStepPivot>(executionStepPivot, executionStep, executionBatchLoad.getAttachmentByOldContentId(executionStepPivot, pivotImportMetadata)), pivotImportMetadata, pivotFormatImport);
        this.updateExecutionStepRichText(executionStep, attachmentsConversion, pivotImportMetadata);
        this.createExecutionStepDenormalized(executionStep, executionStepPivot, executionBatchLoad, attachmentsConversion, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(executionStepPivot, executionStep, attachmentsConversion, pivotImportMetadata);
        this.privateCustomFieldValueService.createAllCustomFieldValues((BoundEntity)executionStep, (GenericProject)pivotFormatImport.getProject(), customFields);
    }

    private void updateExecutionStepRichText(ExecutionStep executionStep, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        String action = executionStep.getAction();
        executionStep.setAction(this.attachmentPivotImportService.updateRichText(action, executionStep.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String expectedResult = executionStep.getExpectedResult();
        executionStep.setExpectedResult(this.attachmentPivotImportService.updateRichText(expectedResult, executionStep.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String comment = executionStep.getComment();
        executionStep.setComment(this.attachmentPivotImportService.updateRichText(comment, executionStep.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
    }

    private ExecutionBatchLoad getExecutionBatchLoad(List<ExecutionPivot> executionPivots, PivotImportMetadata pivotImportMetadata) {
        List<Long> testPlanItemIds;
        List<Long> list = testPlanItemIds = executionPivots.stream().map(ExecutionPivot::getTestPlanItemId).distinct().map(id -> pivotImportMetadata.getTestPlanItemIdsMap().get(id)).toList();
        TestPlanItemDao testPlanItemDao = this.testPlanItemDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testPlanItemDao, list);
        Object[] objectArray = new Object[]{this, testPlanItemDao, list, joinPoint};
        ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3 executionWorkspacePivotImporterServiceImpl$AjcClosure3 = new ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3(objectArray);
        Map<Long, TestPlanItem> testPlanItemByIds = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(executionWorkspacePivotImporterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.toMap(TestPlanItem::getId, Function.identity()));
        Set<Long> testCaseIds = testPlanItemByIds.values().stream().filter(tpi -> Objects.nonNull(tpi.getReferencedTestCase())).map(tpi -> tpi.getReferencedTestCase().getId()).collect(Collectors.toSet());
        Set<Long> testStepIds = executionPivots.stream().flatMap(executionPivot -> executionPivot.getExecutionSteps().stream().map(ExecutionStepPivot::getTestStepId).filter(Objects::nonNull).map(testStepId -> pivotImportMetadata.getTestStepsIdsMap().get(testStepId))).collect(Collectors.toSet());
        Map<Long, Map<Long, CustomFieldValue>> cfvIdByTestCaseIdsAndCFId = this.getCFVByEntityIdsAndCFId(testCaseIds, BindableEntity.TEST_CASE);
        Map<Long, Map<Long, CustomFieldValue>> cfvIdByTestStepIdsAndCFId = this.getCFVByEntityIdsAndCFId(testStepIds, BindableEntity.TEST_STEP);
        Map<Long, TestStep> testStepsById = this.testStepDao.findAllByIds(testStepIds).stream().collect(Collectors.toMap(TestStep::getId, Function.identity()));
        Map<Long, Attachment> attachmentByNewContentId = this.getAttachmentByNewContentId(executionPivots, pivotImportMetadata);
        return new ExecutionBatchLoad(testPlanItemByIds, cfvIdByTestCaseIdsAndCFId, cfvIdByTestStepIdsAndCFId, testStepsById, attachmentByNewContentId);
    }

    private Map<Long, Map<Long, CustomFieldValue>> getCFVByEntityIdsAndCFId(Set<Long> boundEntityIds, BindableEntity bindableEntity) {
        BindableEntity bindableEntity2 = bindableEntity;
        Set<Long> set = boundEntityIds;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)customFieldValueDao, set, (Object)bindableEntity2);
        Object[] objectArray = new Object[]{this, customFieldValueDao, set, bindableEntity2, joinPoint};
        ExecutionWorkspacePivotImporterServiceImpl$AjcClosure5 executionWorkspacePivotImporterServiceImpl$AjcClosure5 = new ExecutionWorkspacePivotImporterServiceImpl$AjcClosure5(objectArray);
        List customFieldValues = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(executionWorkspacePivotImporterServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        return customFieldValues.stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId, Collectors.toMap(cv -> cv.getCustomField().getId(), Function.identity())));
    }

    private Map<Long, Attachment> getAttachmentByNewContentId(List<ExecutionPivot> executionPivots, PivotImportMetadata pivotImportMetadata) {
        HashSet oldAttachmentContentIds = new HashSet();
        for (ExecutionPivot executionPivot : executionPivots) {
            executionPivot.getAttachments().stream().map(AttachmentPivot::getContentId).forEach(oldAttachmentContentIds::add);
            executionPivot.getExecutionSteps().stream().flatMap(executionStepPivot -> executionStepPivot.getAttachments().stream()).map(AttachmentPivot::getContentId).forEach(oldAttachmentContentIds::add);
        }
        if (oldAttachmentContentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Long> newAttachmentContentIds = new HashSet<Long>();
        for (Long oldAttachmentContentId : oldAttachmentContentIds) {
            ContentConversionPivotHolder contentConversionPivotHolder = pivotImportMetadata.getContentConversionByOldContentId().get(oldAttachmentContentId);
            if (contentConversionPivotHolder == null) continue;
            newAttachmentContentIds.add(contentConversionPivotHolder.newContentId());
        }
        return this.attachmentDao.findAttachmentsByContentIds(newAttachmentContentIds).stream().collect(Collectors.toMap(a -> a.getContent().getId(), Function.identity(), (existing, replacement) -> existing));
    }

    private Map<Long, ContentConversionPivotHolder> getContentConversionPivotHolderByOldAttachmentId(PivotImportMetadata pivotImportMetadata) {
        return pivotImportMetadata.getContentConversionByOldContentId().values().stream().collect(Collectors.toMap(ContentConversionPivotHolder::oldAttachmentId, Function.identity()));
    }

    private Map<Long, ContentConversionPivotHolder> sessionOverviewAttachmentCorrection(List<SessionOverviewPivot> sessionOverviewPivots, PivotImportMetadata pivotImportMetadata) {
        if (sessionOverviewPivots.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, SessionOverviewAttachmentHolder> attachmentHolderByNewAttachmentId = this.getAttachmentHolderByNewAttachmentIdFromCharter(sessionOverviewPivots, pivotImportMetadata);
        if (attachmentHolderByNewAttachmentId.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.getAttachmentByOldContentIdFromAttachmentHolder(attachmentHolderByNewAttachmentId);
    }

    private Map<Long, SessionOverviewAttachmentHolder> getAttachmentHolderByNewAttachmentIdFromCharter(List<SessionOverviewPivot> sessionOverviewPivots, PivotImportMetadata pivotImportMetadata) {
        Map<Long, ContentConversionPivotHolder> contentConversionPivotHolderByOldAttachmentId = this.getContentConversionPivotHolderByOldAttachmentId(pivotImportMetadata);
        HashMap<Long, SessionOverviewAttachmentHolder> attachmentHolderByNewAttachmentId = new HashMap<Long, SessionOverviewAttachmentHolder>();
        for (SessionOverviewPivot sessionOverviewPivot : sessionOverviewPivots) {
            Matcher matcher = AttachmentManagerServiceImpl.ATTACHMENT_LIST_URL_PATTERN.matcher(sessionOverviewPivot.getCharter());
            matcher.results().forEach(m -> {
                Long oldAttachmentId = Long.parseLong(m.group(2));
                if (contentConversionPivotHolderByOldAttachmentId.containsKey(oldAttachmentId)) {
                    ContentConversionPivotHolder holder = (ContentConversionPivotHolder)contentConversionPivotHolderByOldAttachmentId.get(oldAttachmentId);
                    attachmentHolderByNewAttachmentId.put(holder.newAttachmentId(), new SessionOverviewAttachmentHolder(holder, sessionOverviewPivot));
                }
            });
        }
        return attachmentHolderByNewAttachmentId;
    }

    private Map<Long, ContentConversionPivotHolder> getAttachmentByOldContentIdFromAttachmentHolder(Map<Long, SessionOverviewAttachmentHolder> attachmentHolderByNewAttachmentId) {
        Set attachmentIdToLoad = attachmentHolderByNewAttachmentId.values().stream().map(SessionOverviewAttachmentHolder::getNewAttachmentId).collect(Collectors.toSet());
        Map attachmentById = this.attachmentDao.findAllById(attachmentIdToLoad).stream().collect(Collectors.toMap(Attachment::getId, Function.identity()));
        HashMap<Long, ContentConversionPivotHolder> attachmentByOldContentId = new HashMap<Long, ContentConversionPivotHolder>();
        attachmentHolderByNewAttachmentId.forEach((newAttachmentId, attachmentHolder) -> {
            if (!attachmentById.containsKey(newAttachmentId)) {
                return;
            }
            Attachment attachment = (Attachment)attachmentById.get(newAttachmentId);
            List<AttachmentPivot> attachmentPivots = attachmentHolder.getAttachmentPivots();
            if (attachmentPivots.isEmpty()) {
                AttachmentPivot attachmentPivot = this.adminPivotConverterService.attachmentToPivotAttachment(attachment, attachmentHolder.getOldAttachmentId(), attachmentHolder.getOldContentId());
                attachmentHolder.getSessionOverviewPivot().addAttachment(attachmentPivot);
            }
            attachmentByOldContentId.put(attachmentHolder.getOldContentId(), new ContentConversionPivotHolder(attachmentHolder.getContentConversionPivotHolder(), attachment));
        });
        return attachmentByOldContentId;
    }

    static final /* synthetic */ List findAllById_aroundBody0(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody2(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, TestPlanItemDao testPlanItemDao, Collection collection, JoinPoint joinPoint) {
        return testPlanItemDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody4(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExecutionWorkspacePivotImporterServiceImpl.java", ExecutionWorkspacePivotImporterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 825);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.TestPlanItemDao", "java.util.Collection", "ids", "", "java.util.List"), 1332);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "entityIds:entityType", "", "java.util.List"), 1369);
    }

    private record ExecutionBatchLoad(Map<Long, TestPlanItem> testPlanItemByIds, Map<Long, Map<Long, CustomFieldValue>> cfvIdByTestCaseIdsAndCFId, Map<Long, Map<Long, CustomFieldValue>> cfvIdByTestStepIdsAndCFId, Map<Long, TestStep> testStepsById, Map<Long, Attachment> attachmentByNewContentId) {
        public TestPlanItem getTestPlanItem(ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata) {
            return this.testPlanItemByIds.get(pivotImportMetadata.getTestPlanItemIdsMap().get(executionPivot.getTestPlanItemId()));
        }

        public <P extends PivotAttachmentEntity> Map<Long, ContentConversionPivotHolder> getAttachmentByOldContentId(P pivotEntity, PivotImportMetadata pivotImportMetadata) {
            HashMap<Long, ContentConversionPivotHolder> attachmentByOldContentId = new HashMap<Long, ContentConversionPivotHolder>();
            for (AttachmentPivot attachmentPivot : pivotEntity.getAttachments()) {
                ContentConversionPivotHolder contentConversionPivotHolder;
                Long oldContentId = attachmentPivot.getContentId();
                boolean hasContentId = pivotImportMetadata.getContentConversionByOldContentId().containsKey(oldContentId);
                ContentConversionPivotHolder contentConversionPivotHolder2 = contentConversionPivotHolder = hasContentId ? pivotImportMetadata.getContentConversionByOldContentId().get(oldContentId) : null;
                if (!hasContentId || !this.attachmentByNewContentId.containsKey(contentConversionPivotHolder.newContentId())) continue;
                attachmentByOldContentId.put(oldContentId, new ContentConversionPivotHolder(contentConversionPivotHolder, this.attachmentByNewContentId.get(contentConversionPivotHolder.newContentId())));
            }
            return attachmentByOldContentId;
        }
    }

    private record SessionOverviewAttachmentHolder(ContentConversionPivotHolder contentConversionPivotHolder, SessionOverviewPivot sessionOverviewPivot) {
        public Long getOldAttachmentId() {
            return this.contentConversionPivotHolder.oldAttachmentId();
        }

        public Long getNewAttachmentId() {
            return this.contentConversionPivotHolder.newAttachmentId();
        }

        public Long getOldContentId() {
            return this.contentConversionPivotHolder.oldContentId();
        }

        public ContentConversionPivotHolder getContentConversionPivotHolder() {
            return this.contentConversionPivotHolder;
        }

        public SessionOverviewPivot getSessionOverviewPivot() {
            return this.sessionOverviewPivot;
        }

        public List<AttachmentPivot> getAttachmentPivots() {
            return this.sessionOverviewPivot.getAttachments().stream().filter(a -> Objects.equals(a.getContentId(), this.contentConversionPivotHolder.oldContentId())).toList();
        }
    }
}

