/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;

public class UserDto {
    private String username;
    private Long userId;
    private List<Long> teamIds = new ArrayList<Long>();
    private boolean isAdmin;

    public UserDto() {
    }

    public UserDto(String username, Long userId, List<Long> teamIds, boolean isAdmin) {
        this.username = username;
        this.userId = userId;
        this.teamIds = teamIds;
        this.isAdmin = isAdmin;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<Long> getTeamIds() {
        return this.teamIds;
    }

    public void setTeamIds(List<Long> teamIds) {
        this.teamIds = teamIds;
    }

    public List<Long> getPartyIds() {
        ArrayList<Long> partyIds = new ArrayList<Long>(this.teamIds);
        partyIds.add(this.userId);
        return partyIds;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public static UserDto fromUser(User user) {
        return new UserDto(user.getLogin(), user.getId(), user.getTeams().stream().map(Party::getId).toList(), "squashtest.authz.group.core.Admin".equals(user.getGroup().getQualifiedName()));
    }
}

