/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.testcase.QRequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class RequirementVersionVerifyingTestCaseCountFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_TCCOUNT_WITH_INDIRECT"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        QRequirement linkedLowLevelReq = new QRequirement("linkedLowLevelReq");
        QRequirementVersion version = new QRequirementVersion("version");
        QRequirement requirement = new QRequirement("requirement");
        QRequirementVersionCoverage coverage = new QRequirementVersionCoverage("coverage");
        QRequirementVersionCoverage directCoverage = new QRequirementVersionCoverage("directCoverage");
        QRequirementVersionCoverage indirectCoverage = new QRequirementVersionCoverage("indirectCoverage");
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)version)).join((EntityPath)version.requirement, (Path)requirement)).leftJoin((CollectionExpression)version.requirementVersionCoverages, (Path)directCoverage)).leftJoin((EntityPath)linkedLowLevelReq)).on((Predicate)requirement.id.eq((Expression)linkedLowLevelReq.highLevelRequirement.id))).leftJoin((CollectionExpression)linkedLowLevelReq.resource.requirementVersionCoverages, (Path)indirectCoverage)).leftJoin((EntityPath)coverage)).on((Predicate)directCoverage.verifyingTestCase.id.eq((Expression)coverage.verifyingTestCase.id).and((Predicate)indirectCoverage.verifyingTestCase.id.eq((Expression)coverage.verifyingTestCase.id)))).where((Predicate)version.id.eq((Expression)QRequirementVersion.requirementVersion.id))).groupBy((Expression)version.id);
        this.appendHavingClause((HibernateQuery<Integer>)subquery, directCoverage.verifyingTestCase, indirectCoverage.verifyingTestCase, coverage.verifyingTestCase, filter);
        query.where((Predicate)subquery.exists());
    }

    private void appendHavingClause(HibernateQuery<Integer> subquery, QTestCase directTestCase, QTestCase indirectTestCase, QTestCase duplicatedTestCase, GridFilterValue filter) {
        int min = Integer.parseInt(filter.getValues().get(0));
        NumberExpression verifyingTestCaseCount = directTestCase.id.countDistinct().add((Expression)indirectTestCase.id.countDistinct()).subtract((Expression)duplicatedTestCase.id.countDistinct());
        switch (filter.getOperation()) {
            case "BETWEEN": {
                int max = Integer.parseInt(filter.getValues().get(1));
                subquery.having((Predicate)verifyingTestCaseCount.between((Number)min, (Number)max));
                break;
            }
            case "GREATER": {
                subquery.having((Predicate)verifyingTestCaseCount.gt((Number)min));
                break;
            }
            case "GREATER_EQUAL": {
                subquery.having((Predicate)verifyingTestCaseCount.goe((Number)min));
                break;
            }
            case "LOWER": {
                subquery.having((Predicate)verifyingTestCaseCount.lt((Number)min));
                break;
            }
            case "LOWER_EQUAL": {
                subquery.having((Predicate)verifyingTestCaseCount.loe((Number)min));
                break;
            }
            case "EQUALS": {
                subquery.having((Predicate)verifyingTestCaseCount.eq((Object)min));
                break;
            }
            case "NOT_EQUALS": {
                subquery.having((Predicate)verifyingTestCaseCount.ne((Object)min));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation");
            }
        }
    }
}

