/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier.copyloading;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.copier.copyloading.AbstractCopyLoadingEntities;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

public class CopyLoadingRequirementToTestCase<CONTAINER extends NodeContainer<TestCaseLibraryNode>>
extends AbstractCopyLoadingEntities<CONTAINER, Requirement> {
    private final RequirementDao requirementDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final NodeCopierDto nodeCopierDto;

    public CopyLoadingRequirementToTestCase(Class<CONTAINER> containerClass, Map<EntityType, EntityDao<?>> daoProviderMap, ClipboardPayload clipboardPayload, RequirementDao requirementDao, ActiveMilestoneHolder activeMilestoneHolder, NodeCopierDto nodeCopierDto) {
        super(containerClass, Requirement.class, daoProviderMap, clipboardPayload);
        this.requirementDao = requirementDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.nodeCopierDto = nodeCopierDto;
    }

    @Override
    public CONTAINER loadContainer(long id) {
        this.activeMilestoneHolder.getActiveMilestone().ifPresent(this.nodeCopierDto::setActiveMilestone);
        EntityDao dao = this.getDaoFromNodeClass(this.containerClass.getSimpleName(), this.daoProviderMap);
        return (CONTAINER)((NodeContainer)dao.loadContainerForPaste(id));
    }

    @Override
    public List<Requirement> loadNodes(List<Long> ids) {
        return this.requirementDao.loadNodeForTestCasePaste(ids);
    }

    @Override
    public List<? extends NodeContainer<TreeNode>> loadChildContainer(String simpleClassName, Collection<Long> ids) {
        this.activeMilestoneHolder.getActiveMilestone().ifPresent(this.nodeCopierDto::setActiveMilestone);
        EntityDao dao = this.getDaoFromNodeClass(TestCaseFolder.class.getSimpleName(), this.daoProviderMap);
        return dao.loadContainersForPaste(ids);
    }

    @Override
    public ChildEntityDtoResult loadChildNode(String simpleClassName, Collection<Long> ids, int offset) {
        return this.requirementDao.loadChildForTestCasePaste(ids, StrategyCopierService.MAX_BATCH_SIZE, offset, this.clipboardPayload);
    }

    @Override
    public ClipboardPayload getClipboardPayload() {
        return this.clipboardPayload;
    }
}

