/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportData;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public class FolderNode {
    private final String name;
    private final String path;
    private final Map<String, FolderNode> children;
    private final List<TestCaseImportData> contents = new ArrayList<TestCaseImportData>();

    public FolderNode(String name, String path) {
        this.name = name;
        this.path = path;
        this.children = new HashMap<String, FolderNode>();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, FolderNode> getChildren() {
        return this.children;
    }

    public void addChild(FolderNode child) {
        this.children.put(child.getName(), child);
    }

    public FolderNode getChild(String name) {
        return this.children.get(name);
    }

    public void addContents(List<TestCaseImportData> importData) {
        this.contents.addAll(importData);
    }

    public List<TestCaseImportData> getContents() {
        return this.contents;
    }

    public TestCaseFolder convertToSquashFolder() {
        TestCaseFolder testCaseFolder = new TestCaseFolder();
        testCaseFolder.setName(this.getName());
        testCaseFolder.setDescription("");
        this.addContentsInSquashFolder(testCaseFolder);
        for (FolderNode child : this.getChildren().values()) {
            TestCaseFolder childTestCaseFolder = child.convertToSquashFolder();
            testCaseFolder.addContent((TestCaseLibraryNode)childTestCaseFolder);
        }
        return testCaseFolder;
    }

    private void addContentsInSquashFolder(TestCaseFolder testCaseFolder) {
        if (this.contents.isEmpty()) {
            return;
        }
        HashSet existingNames = new HashSet();
        this.contents.forEach(content -> {
            TestCase testCase = content.getTestCase();
            this.resolveNameConflict(existingNames, testCase);
            testCaseFolder.addContent((TestCaseLibraryNode)testCase);
            existingNames.add(testCase.getName());
        });
    }

    private void resolveNameConflict(Set<String> existingNames, TestCase testCase) {
        String currentName = testCase.getName();
        String uniqueName = LibraryUtils.generateNonClashingName(currentName, existingNames, 255);
        if (!uniqueName.equals(currentName)) {
            testCase.setName(uniqueName);
        }
    }

    public List<TestCaseImportData> collectAllTestCaseImportData() {
        ArrayList<TestCaseImportData> result = this.contents.isEmpty() ? new ArrayList<TestCaseImportData>() : new ArrayList<TestCaseImportData>(this.contents);
        for (FolderNode child : this.getChildren().values()) {
            result.addAll(child.collectAllTestCaseImportData());
        }
        return result;
    }

    public FolderNode getChildOrCreate(String part, String path) {
        FolderNode child = this.getChild(part);
        if (child == null) {
            child = new FolderNode(part, path);
            this.addChild(child);
        }
        return child;
    }
}

