/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.ImportRequirementFinder;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;

public class ImportedRequirementTree {
    private static final String TARGET_NOT_LOADED = "Imported requirement not loaded";
    private final Map<RequirementTarget, ImportedRequirementNode> nodes = new HashMap<RequirementTarget, ImportedRequirementNode>();
    private final Map<ImportedRequirementNode, Set<ImportedRequirementNode>> missingNodes = new HashMap<ImportedRequirementNode, Set<ImportedRequirementNode>>();

    public void updateVersionStatus(RequirementVersionTarget version, TargetStatus status) {
        ImportedRequirementNode requirement = this.getNode(version.getRequirement());
        if (requirement == null) {
            throw new IllegalStateException(TARGET_NOT_LOADED);
        }
        requirement.updateVersionStatus(version.getVersion(), status);
    }

    public void addVersion(RequirementVersionTarget version, TargetStatus status) {
        ImportedRequirementNode requirement = this.getNode(version.getRequirement());
        requirement.addVersion(version.getVersion(), status);
    }

    public void updateStatus(RequirementTarget requirementTarget, TargetStatus status) {
        ImportedRequirementNode node = this.getNode(requirementTarget);
        if (node == null) {
            throw new IllegalStateException(TARGET_NOT_LOADED);
        }
        node.updateStatus(status);
    }

    public boolean targetNotLoaded(RequirementTarget target) {
        ImportedRequirementNode req = this.getNode(target);
        return req == null;
    }

    public boolean targetNotLoaded(RequirementVersionTarget target) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        if (req == null) {
            return true;
        }
        return !req.versionAlreadyLoaded(target.getVersion());
    }

    public TargetStatus getStatus(RequirementTarget target) {
        ImportedRequirementNode requirement = this.getNode(target);
        if (requirement != null) {
            return requirement.getStatus();
        }
        return TargetStatus.NOT_EXISTS;
    }

    public TargetStatus getStatus(RequirementVersionTarget target) {
        ImportedRequirementNode requirement = this.getNode(target.getRequirement());
        return requirement.getVersionStatus(target.getVersion());
    }

    private void addNode(ImportedRequirementNode node) {
        this.nodes.put(node.getTarget(), node);
    }

    public void setNotExists(RequirementVersionTarget target) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        if (req != null) {
            req.setNotExists(target.getVersion());
        }
    }

    public Long getNodeId(RequirementTarget requirement) {
        ImportedRequirementNode reqNode = this.getNode(requirement);
        if (reqNode != null && reqNode.getStatus().getStatus() == Existence.EXISTS) {
            return reqNode.getStatus().getId();
        }
        return null;
    }

    public Long getNodeId(RequirementVersionTarget version) {
        return this.getNodeId(version.getRequirement());
    }

    public void bindMilestone(RequirementVersionTarget target, String milestone) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        req.bindMilestoneToVersion(target.getVersion(), milestone);
    }

    public void bindMilestone(RequirementVersionTarget target, List<String> milestones) {
        for (String milestone : milestones) {
            this.bindMilestone(target, milestone);
        }
    }

    public boolean isMilestoneUsedByOneVersion(RequirementVersionTarget target, String milestone) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        return req.isMilestoneUsedByOneVersion(milestone);
    }

    public boolean isMilestoneLocked(RequirementVersionTarget target) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        return req.isVersionMilestoneLocked(target.getVersion());
    }

    public void milestoneLock(RequirementVersionTarget target) {
        ImportedRequirementNode req = this.getNode(target.getRequirement());
        req.setVersionMilestoneLocked(target.getVersion());
    }

    public boolean isRequirementFolder(RequirementVersionTarget target) {
        return this.isRequirementFolder(target.getRequirement());
    }

    public boolean isRequirementFolder(RequirementTarget target) {
        ImportedRequirementNode req = this.getNode(target);
        if (req != null) {
            return req.isRequirementFolder() && req.getStatus().getStatus() != Existence.NOT_EXISTS;
        }
        return false;
    }

    public ImportedRequirementNode getNode(RequirementTarget target) {
        return this.nodes.get(target);
    }

    public boolean isHighLevelRequirement(RequirementTarget target) {
        ImportedRequirementNode node = this.getNode(target);
        if (node == null) {
            throw new IllegalStateException(TARGET_NOT_LOADED);
        }
        return node.isHighLevelRequirement();
    }

    public boolean isRequirementChild(RequirementTarget target) {
        ImportedRequirementNode node = this.getNode(target);
        if (node == null) {
            throw new IllegalStateException(TARGET_NOT_LOADED);
        }
        return node.isRequirementChild();
    }

    public void addNodes(Set<RequirementTarget> targets, ImportRequirementFinder finder, String project, Long requirementLibraryId) {
        this.resetMissingNodes();
        ImportedRequirementNode root = ImportedRequirementNode.createRequirementLibraryNode(project, requirementLibraryId);
        this.addNode(root);
        for (RequirementTarget target : targets) {
            ImportedRequirementNode targetNode = this.getRequirementNode(target, finder);
            if (targetNode.exist()) continue;
            this.findFirstExistingParent(finder, root, targetNode);
        }
    }

    private void findFirstExistingParent(ImportRequirementFinder finder, ImportedRequirementNode root, ImportedRequirementNode targetNode) {
        String[] parts = PathUtils.splitPath((String)targetNode.getTarget().getPath());
        List paths = PathUtils.scanPath((String)targetNode.getTarget().getPath());
        ImportedRequirementNode current = targetNode;
        int i = parts.length - 2;
        while (i >= 0) {
            if (i == 0) {
                root.addContent(current);
                this.addMissingNode(root, current);
                return;
            }
            ImportedRequirementNode parent = this.findParent(current, (String)paths.get(i), finder);
            parent.addContent(current);
            if (parent.exist()) {
                this.addMissingNode(parent, current);
                return;
            }
            current = parent;
            --i;
        }
    }

    private ImportedRequirementNode getRequirementNode(RequirementTarget target, ImportRequirementFinder finder) {
        ImportedRequirementNode node = this.getNode(target);
        if (node != null) {
            return node;
        }
        node = finder.searchRequirementNode(target);
        if (node == null) {
            node = ImportedRequirementNode.createRequirementNode(target, new TargetStatus(Existence.NOT_EXISTS));
        }
        this.addNode(node);
        return node;
    }

    private void addMissingNode(ImportedRequirementNode parent, ImportedRequirementNode child) {
        this.missingNodes.computeIfAbsent(parent, k -> new HashSet()).add(child);
    }

    private void resetMissingNodes() {
        this.missingNodes.clear();
    }

    private ImportedRequirementNode findParent(ImportedRequirementNode child, String parentPath, ImportRequirementFinder finder) {
        RequirementTarget target = finder.searchParentTarget(parentPath, child);
        if (target != null) {
            ImportedRequirementNode node = this.getRequirementNode(target, finder);
            child.fix();
            return node;
        }
        if (child.isRequirementFolder()) {
            return this.getFolderParent(parentPath, finder);
        }
        ImportedRequirementNode requirementNode = ImportedRequirementTree.findRequirementParent(child, parentPath, finder);
        if (requirementNode != null) {
            return requirementNode;
        }
        return this.getFolderParent(parentPath, finder);
    }

    private static ImportedRequirementNode findRequirementParent(ImportedRequirementNode child, String parentPath, ImportRequirementFinder finder) {
        if (child.isSynchronized() && !child.isImportingSynchronizedReq()) {
            return finder.searchSynchronizedRequirementParent(parentPath, child.getRemoteSynchronisationId());
        }
        if (child.isImportingSynchronizedReq()) {
            return finder.searchImportedSynchronizedRequirementParent(parentPath, child.getRemoteSynchronisationId());
        }
        return finder.searchBasicRequirementParent(parentPath);
    }

    private ImportedRequirementNode getFolderParent(String parentPath, ImportRequirementFinder finder) {
        RequirementTarget target = new RequirementTarget(parentPath);
        ImportedRequirementNode folder = this.getNode(target);
        if (folder != null) {
            return folder;
        }
        folder = finder.searchFolderParent(target);
        if (folder == null) {
            folder = ImportedRequirementNode.createRequirementFolderNode(target, new TargetStatus(Existence.NOT_EXISTS));
        }
        this.addNode(folder);
        return folder;
    }

    public void addNodes(Set<RequirementTarget> targets, ImportRequirementFinder finder) {
        for (RequirementTarget target : targets) {
            ImportedRequirementNode node = finder.searchRequirementNode(target);
            if (node == null) {
                node = ImportedRequirementNode.createRequirementNode(target, new TargetStatus(Existence.NOT_EXISTS));
            }
            this.addNode(node);
        }
    }

    public Map<ImportedRequirementNode, Set<ImportedRequirementNode>> collectMissingNode() {
        return this.missingNodes;
    }

    public void fixVersion(RequirementVersionTarget target) {
        ImportedRequirementNode node = this.getNode(target.getRequirement());
        int versionNumber = node.fixVersion();
        Integer deprecated = target.getVersion();
        if (deprecated != null && (deprecated <= 0 || deprecated > versionNumber)) {
            node.deleteVersion(deprecated);
        }
        target.setVersion(versionNumber);
        this.addVersion(target, new TargetStatus(Existence.NOT_EXISTS));
    }

    public boolean existPriorVersion(RequirementVersionTarget target) {
        ImportedRequirementNode node = this.getNode(target.getRequirement());
        return node.existPriorVersion(target.getVersion());
    }

    public Long getVersionId(RequirementTarget requirement, int version) {
        ImportedRequirementNode reqNode = this.getNode(requirement);
        if (reqNode != null && reqNode.getStatus().getStatus() == Existence.EXISTS) {
            return reqNode.getVersionId(version);
        }
        return null;
    }
}

