/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.candidate;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AnalysisStatus;
import org.squashtest.tm.domain.testautomation.TestCandidateAnalysis;
import org.squashtest.tm.domain.testcase.TestAutomationCandidate;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.dto.testautomation.AlreadyDecidedTestCandidatesDto;
import org.squashtest.tm.service.internal.dto.testautomation.CandidateApproveRequestDto;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationEvent;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationInitResponse;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationProjectAnalysisStatusDto;
import org.squashtest.tm.service.internal.dto.testautomation.TestCandidateAnalysisDto;
import org.squashtest.tm.service.internal.repository.TestAutomationCandidateDao;
import org.squashtest.tm.service.internal.repository.TestCandidateAnalysisDao;
import org.squashtest.tm.service.internal.repository.display.TestCandidateAnalysisDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.testautomation.candidate.AnalysisContext;
import org.squashtest.tm.service.internal.testautomation.candidate.ExecutionStatistics;
import org.squashtest.tm.service.internal.testautomation.candidate.ProjectTestCasesExecutionsData;
import org.squashtest.tm.service.internal.testautomation.candidate.TestAutomationScoringProcessor;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.sse.ServerEventService;
import org.squashtest.tm.service.testautomation.candidate.TestAutomationCandidateService;

@Service
@Transactional
public class TestAutomationCandidateServiceImpl
implements TestAutomationCandidateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationCandidateServiceImpl.class);
    private static final String TEST_AUTOMATION_CANDIDATES_TASKS_ENDPOINT = "/backend/test-automation-candidates/tasks/";
    private static final int BATCH_SIZE = 500;
    @PersistenceContext
    private EntityManager entityManager;
    private final TestAutomationCandidateDao testAutomationCandidateDao;
    private final TestCandidateAnalysisDao testCandidateAnalysisDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ServerEventService serverEventService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final TestAutomationScoringProcessor testAutomationScoringProcessor;
    private final TestCandidateAnalysisDisplayDao testCandidateAnalysisDisplayDao;
    private final ProjectFinder projectFinder;

    public TestAutomationCandidateServiceImpl(TestAutomationCandidateDao testAutomationCandidateDao, TestCandidateAnalysisDao testCandidateAnalysisDao, PermissionEvaluationService permissionEvaluationService, ServerEventService serverEventService, ApplicationEventPublisher applicationEventPublisher, TestAutomationScoringProcessor testAutomationScoringProcessor, TestCandidateAnalysisDisplayDao testCandidateAnalysisDisplayDao, ProjectFinder projectFinder) {
        this.testAutomationCandidateDao = testAutomationCandidateDao;
        this.testCandidateAnalysisDao = testCandidateAnalysisDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.serverEventService = serverEventService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.testAutomationScoringProcessor = testAutomationScoringProcessor;
        this.testCandidateAnalysisDisplayDao = testCandidateAnalysisDisplayDao;
        this.projectFinder = projectFinder;
    }

    @Override
    @Transactional
    public TestAutomationInitResponse initiateTestAutomationScoring(List<Long> projectIds) {
        LOGGER.info("Initiating test automation scoring for projects: {}", new Object[]{projectIds});
        int totalTestCases = this.testAutomationCandidateDao.countEligibleTestCasesByProjectIds(projectIds);
        if (!this.hasPermissionOnProjects(projectIds)) {
            LOGGER.error("Test automation access denied for projects: {}", new Object[]{projectIds});
            throw new AccessDeniedException("No permission to manage test automation for all provided projects");
        }
        String currentUser = UserContextHolder.getUsername();
        TestCandidateAnalysis analysis = this.createTestCandidateAnalysis(projectIds, totalTestCases, currentUser);
        analysis = (TestCandidateAnalysis)this.testCandidateAnalysisDao.save(analysis);
        String statusUrl = TEST_AUTOMATION_CANDIDATES_TASKS_ENDPOINT + String.valueOf(analysis.getId());
        if (totalTestCases > 0) {
            LOGGER.trace("Publishing test automation event for analysis {} with {} test cases", new Object[]{analysis.getId(), totalTestCases});
            TestAutomationEvent event = new TestAutomationEvent(projectIds, analysis.getId(), currentUser);
            this.applicationEventPublisher.publishEvent((Object)event);
        } else {
            LOGGER.debug("No test cases to process, marking analysis {} as completed", new Object[]{analysis.getId()});
            analysis.setStatus(AnalysisStatus.COMPLETED);
            analysis.setTerminatedOn(new Date());
            this.testCandidateAnalysisDao.save(analysis);
            TestCandidateAnalysisDto progressDto = this.createProgressDtoFromAnalysis(analysis, 0);
            this.serverEventService.sendLastEvent(analysis.getId().toString(), progressDto);
        }
        LOGGER.info("Test automation scoring initiated successfully for analysis {}", new Object[]{analysis.getId()});
        return new TestAutomationInitResponse(analysis.getId(), statusUrl, totalTestCases, currentUser);
    }

    @Override
    @Transactional
    public void processTestCasesAsync(List<Long> projectIds, Long analysisId, String evaluatedBy) {
        LOGGER.debug("Starting async processing for analysis {} with projects: {}", new Object[]{analysisId, projectIds});
        TestCandidateAnalysis analysis = (TestCandidateAnalysis)this.testCandidateAnalysisDao.findById(analysisId).orElseThrow();
        try {
            Map<Long, List<Long>> testCaseIdsByProject = this.testAutomationCandidateDao.findEligibleTestCaseIdsByProjectIds(projectIds);
            int totalTestCases = testCaseIdsByProject.values().stream().mapToInt(List::size).sum();
            if (totalTestCases == 0) {
                LOGGER.debug("No eligible test cases found for analysis {}, completing task", new Object[]{analysisId});
                this.completeAnalysis(analysis);
                return;
            }
            LOGGER.info("Processing {} test cases for analysis {}", new Object[]{totalTestCases, analysisId});
            this.createTestAutomationCandidates(testCaseIdsByProject, analysis, evaluatedBy);
            LOGGER.debug("Successfully completed async processing for analysis {}", new Object[]{analysisId});
            this.completeAnalysis(analysis);
        }
        catch (Exception e) {
            LOGGER.error("Error during async processing for analysis {}: {}", new Object[]{analysisId, e.getMessage(), e});
            analysis.setStatus(AnalysisStatus.FAILED);
            analysis.setTerminatedOn(new Date());
            this.testCandidateAnalysisDao.save(analysis);
            TestCandidateAnalysisDto progressDto = this.createProgressDtoFromAnalysis(analysis, analysis.getNbOfProcessedTestCases());
            this.serverEventService.sendLastEvent(analysisId.toString(), progressDto);
            throw e;
        }
    }

    @Override
    public TestCandidateAnalysisDto getLastUserAnalysis() {
        String currentUser = UserContextHolder.getUsername();
        LOGGER.debug("Retrieving test candidate analyses for user: {}", new Object[]{currentUser});
        TestCandidateAnalysis analysis = this.testCandidateAnalysisDao.findLastByCreatedBy(currentUser);
        if (analysis == null) {
            return null;
        }
        List projectNames = analysis.getProjectNames();
        return TestCandidateAnalysisDto.builder().withAnalysisId(analysis.getId()).withProjectNames(projectNames).withNbTotalCandidates(analysis.getNbOfTotalTestCases()).withNbProcessedCandidates(analysis.getNbOfProcessedTestCases()).withStatus(analysis.getStatus()).withEvaluatedBy(analysis.getCreatedBy()).withCreatedOn(analysis.getCreatedOn()).withTerminatedOn(analysis.getTerminatedOn()).build();
    }

    @Override
    public List<AlreadyDecidedTestCandidatesDto> approveUndecidedCandidates(List<CandidateApproveRequestDto> candidates) {
        List<Long> testCaseIds = candidates.stream().map(CandidateApproveRequestDto::testCaseId).toList();
        if (this.hasNoPermissionOnTestCases(testCaseIds)) {
            throw new AccessDeniedException("No permission to approve automation candidates on some test cases");
        }
        List<AlreadyDecidedTestCandidatesDto> alreadyDecidedTestCandidates = this.testAutomationCandidateDao.findAlreadyDecidedTests(testCaseIds);
        Set alreadyApprovedIds = alreadyDecidedTestCandidates.stream().map(AlreadyDecidedTestCandidatesDto::testCaseId).collect(Collectors.toSet());
        Map<Long, Integer> manualPriorityByTcId = candidates.stream().filter(req -> !alreadyApprovedIds.contains(req.testCaseId())).filter(req -> req.priority() != null).collect(Collectors.toMap(CandidateApproveRequestDto::testCaseId, CandidateApproveRequestDto::priority));
        List<Long> toApproveTestCaseIds = candidates.stream().map(CandidateApproveRequestDto::testCaseId).filter(id -> !alreadyApprovedIds.contains(id)).toList();
        if (toApproveTestCaseIds.isEmpty()) {
            LOGGER.debug("No undecided candidates to approve", new Object[0]);
            return alreadyDecidedTestCandidates;
        }
        List<TestAutomationCandidate> candidatesToApprove = this.testAutomationCandidateDao.findCandidatesWithRelations(toApproveTestCaseIds);
        String decidedBy = UserContextHolder.getUsername();
        Date now = new Date();
        HibernateConfig.enableBatch(this.entityManager, 50);
        try {
            for (TestAutomationCandidate candidate : candidatesToApprove) {
                TestCase tc = candidate.getTestCase();
                int decidedPriority = manualPriorityByTcId.getOrDefault(tc.getId(), candidate.getPriorityScore());
                if (tc.getProject().isAllowAutomationWorkflow()) {
                    AutomationRequest ar = this.getOrCreateAutomationRequest(tc);
                    ar.setAutomationPriority(Integer.valueOf(decidedPriority));
                    tc.setAutomatable(TestCaseAutomatable.Y);
                }
                this.approve(candidate, decidedBy, now, decidedPriority);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
        finally {
            HibernateConfig.disableBatch(this.entityManager);
        }
        return alreadyDecidedTestCandidates;
    }

    @Override
    public void resetDecidedSuggestion(TestCaseAutomatable testCaseAutomatable, long testCaseId) {
        if (testCaseAutomatable != TestCaseAutomatable.M) {
            return;
        }
        this.testAutomationCandidateDao.findCandidateByTestCaseId(testCaseId).ifPresent(candidate -> {
            candidate.setSuggestionStatus(TestAutomationCandidate.SuggestionStatus.SUGGESTED);
            candidate.setDecidedBy(null);
            candidate.setDecidedOn(null);
            candidate.setDecidedPriority(null);
        });
    }

    @Override
    public List<Long> findReadableProjectIdsForAutomationHelper() {
        return this.projectFinder.findAllReadableIdsForAutomationHelper();
    }

    @Override
    public List<TestAutomationProjectAnalysisStatusDto> findAnalysisStatusForProjects() {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationHelper();
        return this.testCandidateAnalysisDisplayDao.findAnalysisStatusByProjectIds(readableProjectIds);
    }

    @Override
    public List<AlreadyDecidedTestCandidatesDto> rejectUndecidedCandidates(List<Long> testCaseIds) {
        if (this.hasNoPermissionOnTestCases(testCaseIds)) {
            throw new AccessDeniedException("No permission to reject automation candidates on some test cases");
        }
        List<AlreadyDecidedTestCandidatesDto> alreadyDecidedTestCandidates = this.testAutomationCandidateDao.findAlreadyDecidedTests(testCaseIds);
        Set alreadyRejectedIds = alreadyDecidedTestCandidates.stream().map(AlreadyDecidedTestCandidatesDto::testCaseId).collect(Collectors.toSet());
        List<Long> toRejectTestCaseIds = testCaseIds.stream().filter(id -> !alreadyRejectedIds.contains(id)).toList();
        if (toRejectTestCaseIds.isEmpty()) {
            LOGGER.debug("No undecided candidates to reject", new Object[0]);
            return alreadyDecidedTestCandidates;
        }
        this.testAutomationCandidateDao.rejectCandidates(toRejectTestCaseIds, UserContextHolder.getUsername());
        return alreadyDecidedTestCandidates;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void createTestAutomationCandidates(Map<Long, List<Long>> testCaseIdsByProject, TestCandidateAnalysis analysis, String evaluatedBy) {
        int totalTestCases = testCaseIdsByProject.values().stream().mapToInt(List::size).sum();
        LOGGER.debug("Creating test automation candidates for {} test cases across {} projects", new Object[]{totalTestCases, testCaseIdsByProject.size()});
        AtomicInteger globalProcessedCount = new AtomicInteger(0);
        for (Map.Entry<Long, List<Long>> entry : testCaseIdsByProject.entrySet()) {
            Long projectId = entry.getKey();
            List<Long> projectTestCaseIds = entry.getValue();
            LOGGER.info("Processing project {} with {} test cases", new Object[]{projectId, projectTestCaseIds.size()});
            this.processProject(projectId, projectTestCaseIds, analysis.getId(), evaluatedBy, globalProcessedCount, totalTestCases);
        }
        LOGGER.debug("Test automation candidates creation completed", new Object[0]);
    }

    private void processProject(Long projectId, List<Long> eligibleTestCaseIds, Long analysisId, String evaluatedBy, AtomicInteger globalProcessedCount, int totalTestCases) {
        Map<Long, Integer> executionCounts = this.testAutomationCandidateDao.countExecutionsByTestCasesForProject(projectId);
        Map<Long, Integer> successCountInLastExecutionsByTestCase = this.testAutomationCandidateDao.countSuccessfulExecutionsInLastRunsByTestCase(projectId, 10);
        ArrayList<Long> allTestCasesIds = new ArrayList<Long>(executionCounts.keySet());
        ExecutionStatistics projectStats = this.calculateExecutionStatistics(allTestCasesIds, executionCounts);
        Lists.partition(eligibleTestCaseIds, (int)500).forEach(batchIds -> {
            try {
                ProjectTestCasesExecutionsData executionData = new ProjectTestCasesExecutionsData((List<Long>)batchIds, executionCounts, successCountInLastExecutionsByTestCase, projectStats);
                AnalysisContext analysisContext = new AnalysisContext(analysisId, evaluatedBy, globalProcessedCount, totalTestCases);
                this.testAutomationScoringProcessor.processTestCaseBatch(executionData, analysisContext);
                LOGGER.debug("Successfully processed batch of {} test cases for project {}", new Object[]{batchIds.size(), projectId});
            }
            catch (Exception e) {
                LOGGER.error("Error processing batch for project {}: {}", new Object[]{projectId, e.getMessage(), e});
                throw e;
            }
        });
    }

    private void completeAnalysis(TestCandidateAnalysis analysis) {
        LOGGER.info("Completing analysis {}", new Object[]{analysis.getId()});
        analysis.setStatus(AnalysisStatus.COMPLETED);
        analysis.setTerminatedOn(new Date());
        analysis.setNbOfProcessedTestCases(analysis.getNbOfTotalTestCases());
        this.testCandidateAnalysisDao.save(analysis);
        TestCandidateAnalysisDto progressDto = this.createProgressDtoFromAnalysis(analysis, analysis.getNbOfTotalTestCases());
        this.serverEventService.sendLastEvent(analysis.getId().toString(), progressDto);
    }

    private TestCandidateAnalysisDto createProgressDtoFromAnalysis(TestCandidateAnalysis analysis, int nbProcessedTC) {
        List projectNames = analysis.getProjectNames();
        return TestCandidateAnalysisDto.builder().withAnalysisId(analysis.getId()).withProjectNames(projectNames).withNbTotalCandidates(analysis.getNbOfTotalTestCases()).withNbProcessedCandidates(nbProcessedTC).withStatus(analysis.getStatus()).withEvaluatedBy(analysis.getCreatedBy()).withCreatedOn(analysis.getCreatedOn()).withTerminatedOn(analysis.getTerminatedOn()).build();
    }

    private TestCandidateAnalysis createTestCandidateAnalysis(List<Long> projectIds, int totalTestCases, String currentUser) {
        TestCandidateAnalysis analysis = new TestCandidateAnalysis();
        analysis.setNbOfTotalTestCases(totalTestCases);
        analysis.setCreatedBy(currentUser);
        Set<Project> projects = this.testCandidateAnalysisDao.findProjectsByIds(projectIds);
        analysis.setProjects(projects);
        return analysis;
    }

    protected boolean hasPermissionOnProjects(List<Long> projectIds) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            return true;
        }
        return this.testAutomationCandidateDao.findOneTestCaseIdPerProject(projectIds).values().stream().allMatch(this::hasPermissionOnTestCaseById);
    }

    protected boolean hasNoPermissionOnTestCases(List<Long> testCaseIds) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            return false;
        }
        for (Long testCaseId : testCaseIds) {
            boolean hasAutomationPermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE_AS_AUTOMATION.name(), testCaseId, TestCase.class.getName());
            boolean hasWritePermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE.name(), testCaseId, TestCase.class.getName());
            if (hasWritePermission || hasAutomationPermission) continue;
            LOGGER.debug("Permission denied on test case ID: {}", new Object[]{testCaseId});
            return true;
        }
        return false;
    }

    protected boolean hasPermissionOnTestCaseById(Long testCaseId) {
        boolean hasWritePermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE.name(), testCaseId, TestCase.class.getName());
        boolean hasAutomationPermission = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.WRITE_AS_AUTOMATION.name(), testCaseId, TestCase.class.getName());
        return hasWritePermission || hasAutomationPermission;
    }

    private AutomationRequest getOrCreateAutomationRequest(TestCase tc) {
        AutomationRequest ar = tc.getAutomationRequest();
        if (ar != null) {
            return ar;
        }
        ar = new AutomationRequest();
        ar.notifyAssociatedWithProject(tc.getProject());
        ar.setTestCase(tc);
        tc.setAutomationRequest(ar);
        this.entityManager.persist((Object)ar);
        return ar;
    }

    private void approve(TestAutomationCandidate candidate, String decidedBy, Date now, int finalPriority) {
        candidate.setSuggestionStatus(TestAutomationCandidate.SuggestionStatus.APPROVED);
        candidate.setDecidedBy(decidedBy);
        candidate.setDecidedOn(now);
        candidate.setDecidedPriority(Integer.valueOf(finalPriority));
    }

    protected ExecutionStatistics calculateExecutionStatistics(List<Long> testCasesIds, Map<Long, Integer> executionCounts) {
        int minCount = Integer.MAX_VALUE;
        int maxCount = 0;
        for (Long testCaseId : testCasesIds) {
            int execCount = executionCounts.getOrDefault(testCaseId, 0);
            if (execCount < 4) continue;
            minCount = Math.min(minCount, execCount);
            maxCount = Math.max(maxCount, execCount);
        }
        if (minCount == Integer.MAX_VALUE) {
            minCount = 0;
        }
        LOGGER.debug("Execution statistics: min={}, max={}, range={}", new Object[]{minCount, maxCount, maxCount - minCount});
        return new ExecutionStatistics(minCount, maxCount, maxCount - minCount);
    }
}

