/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.Sprint;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.display.CampaignSearchDisplayDao;

@Repository
public class CampaignSearchDisplayDaoImpl
implements CampaignSearchDisplayDao {
    private static final String EXECUTION_MODE = "EXECUTION_EXECUTION_MODE";
    private static final String CLN_FROM_CAMPAIGN = "CLN_FROM_CAMPAIGN";
    private static final String CLN_FROM_SPRINT = "CLN_FROM_SPRINT";
    private static final String CLN_ID = "CLN_ID";
    private static final String NAME = "NAME";
    private final Project aliasProject = Tables.PROJECT.as("aliasProject");
    private final DSLContext jooq;

    public CampaignSearchDisplayDaoImpl(DSLContext jooq) {
        this.jooq = jooq;
    }

    @Override
    public GridResponse getRows(List<Long> itpiIds, GridRequest gridRequest) {
        GridResponse gridResponse = new GridResponse();
        this.jooq.select(this.getFields()).from(this.getTable()).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(itpiIds)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, this.getClnFromCampaignTable().field(CLN_ID, Long.class), this.getClnFromCampaignTable().field("CAMPAIGN_NAME", String.class), this.getClnFromCampaignTable().field("ITERATION_ID", Long.class), this.getClnFromCampaignTable().field("ITERATION_NAME", String.class), this.getClnFromSprintTable().field(CLN_ID, Long.class), this.getClnFromSprintTable().field(NAME, String.class), Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE.TCLN_ID, Tables.DATASET.DATASET_ID, Tables.PROJECT.PROJECT_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, DSL.field((String)EXECUTION_MODE), Tables.TEST_CASE.AUTOMATABLE, Tables.AUTOMATION_REQUEST.REQUEST_STATUS, Tables.CORE_USER.FIRST_NAME, Tables.CORE_USER.LAST_NAME, Tables.CORE_USER.LOGIN, Tables.CORE_USER.PARTY_ID}).stream().forEach(record -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(((Long)record.get(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ID"))).toString());
            dataRow.setProjectId((Long)record.get((Field)Tables.PROJECT.PROJECT_ID));
            Map rawData = record.intoMap();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry entry : rawData.entrySet()) {
                data.put(this.convertField((String)entry.getKey()), entry.getValue());
            }
            dataRow.setData(data);
            gridResponse.addDataRow(dataRow);
        });
        return gridResponse;
    }

    private List<Field<?>> getFields() {
        return Arrays.asList(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ID"), Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, this.getClnFromCampaignTable().field(CLN_ID, Long.class), this.getClnFromCampaignTable().field("CAMPAIGN_NAME", String.class), this.getClnFromCampaignTable().field("ITERATION_NAME", String.class), this.getClnFromCampaignTable().field("ITERATION_ID", Long.class), this.getClnFromSprintTable().field(CLN_ID, Long.class).as("SPRINT_ID"), this.getClnFromSprintTable().field(NAME, String.class).as("SPRINT_NAME"), Tables.TEST_CASE_LIBRARY_NODE.NAME.as("LABEL"), Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.AUTOMATABLE, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.TCLN_ID, DSL.groupConcat((Field)Tables.MILESTONE.LABEL).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_LABELS"), DSL.groupConcat((Field)Tables.MILESTONE.STATUS).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_STATUS"), DSL.groupConcat((Field)Tables.MILESTONE.END_DATE).orderBy(new OrderField[]{Tables.MILESTONE.LABEL}).separator(", ").as("MILESTONE_END_DATE"), Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, this.hasBlockingMilestone().as("HAS_BLOCKING_MILESTONE"), this.getAutomationFields().as(EXECUTION_MODE), Tables.DATASET.NAME.as("DATASET_NAME"), Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME.as("PROJECT_NAME"), DSL.when((Condition)Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()), (Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS).otherwise((Object)"").as("REQUEST_STATUS"), DSL.concat((Field[])new Field[]{Tables.CORE_USER.FIRST_NAME, DSL.inline((String)" "), Tables.CORE_USER.LAST_NAME, DSL.inline((String)" ("), Tables.CORE_USER.LOGIN, DSL.inline((String)")")}).as("ASSIGNEE_LOGIN"), Tables.CORE_USER.PARTY_ID.as("ASSIGNEE_ID"), DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.TEST_SUITE.NAME)).from((TableLike)Tables.TEST_SUITE).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).asField("TEST_SUITES"));
    }

    private Table<?> getClnFromCampaignTable() {
        return DSL.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("CAMPAIGN_NAME"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME.as("ITERATION_NAME"), (SelectField)Tables.ITERATION.TEST_PLAN_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).asTable(CLN_FROM_CAMPAIGN);
    }

    private Table<?> getClnFromSprintTable() {
        return DSL.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Sprint.SPRINT).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Sprint.SPRINT.CLN_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Sprint.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).asTable(CLN_FROM_SPRINT);
    }

    private Table<?> getTable() {
        return Tables.TEST_PLAN_ITEM.leftJoin(this.getClnFromCampaignTable()).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq(this.getClnFromCampaignTable().field((Field)Tables.ITERATION.TEST_PLAN_ID))).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).leftJoin((TableLike)this.aliasProject).on(this.aliasProject.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)this.aliasProject.TA_SERVER_ID)).leftJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).leftJoin(this.getClnFromSprintTable()).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq(this.getClnFromSprintTable().field((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID))).leftJoin((TableLike)Tables.PROJECT).on(DSL.coalesce((Field)this.getClnFromCampaignTable().field((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID), (Field[])new Field[]{this.getClnFromSprintTable().field((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)}).eq((Field)Tables.PROJECT.PROJECT_ID));
    }

    private String convertField(String fieldName) {
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        return (String)converter.convert((Object)fieldName);
    }

    private Field<Boolean> hasBlockingMilestone() {
        return DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.MILESTONE_CAMPAIGN).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq(this.getClnFromCampaignTable().field(CLN_ID, Long.class))).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name())));
    }

    private Field<?> getAutomationFields() {
        return DSL.when((Condition)Tables.TEST_CASE.EXECUTION_MODE.eq((Object)TestCaseExecutionMode.EXPLORATORY.name()), (Object)TestCaseExecutionMode.EXPLORATORY.name()).otherwise(DSL.when((Condition)this.aliasProject.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name()).or(this.aliasProject.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()))).and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull()).or(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()))), (Object)TestCaseExecutionMode.AUTOMATED.name()).otherwise((Object)TestCaseExecutionMode.MANUAL.name()));
    }
}

