/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.customfield.CustomCustomFieldManagerService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomFieldPivotImporterService;

@Service
public class CustomFieldPivotImporterServiceImpl
extends AbstractPivotImport
implements CustomFieldPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldPivotImporterService.class);
    private final CustomCustomFieldManagerService customFieldManagerService;
    private final AdminPivotConverterService adminPivotConverterService;
    @PersistenceContext
    private EntityManager entityManager;

    public CustomFieldPivotImporterServiceImpl(CustomCustomFieldManagerService customFieldManagerService, AdminPivotConverterService adminPivotConverterService) {
        super(LOGGER);
        this.customFieldManagerService = customFieldManagerService;
        this.adminPivotConverterService = adminPivotConverterService;
    }

    @Override
    public void importCustomFieldsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CUSTOM_FIELDS, pivotFormatImport, pivotImportMetadata, "custom fields", "custom field", this.getCustomFieldImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CustomFieldPivot> getCustomFieldImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CustomFieldPivot>(){

            @Override
            public Class<CustomFieldPivot> getPivotClazz() {
                return CustomFieldPivot.class;
            }

            @Override
            public void create(List<CustomFieldPivot> entities) {
                CustomFieldPivotImporterServiceImpl.this.createCustomFields(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createCustomFields(List<CustomFieldPivot> customFieldPivotList, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        List<String> customFieldCodes = customFieldPivotList.stream().map(CustomFieldPivot::getCode).toList();
        List<CustomField> existingCustomFields = this.customFieldManagerService.findByCodes(customFieldCodes);
        for (CustomFieldPivot customFieldPivot : customFieldPivotList) {
            CustomField existingCustomField = existingCustomFields.stream().filter(customField -> customField.getCode().equals(customFieldPivot.getCode()) && customField.getInputType().equals((Object)customFieldPivot.getInputType())).findFirst().orElse(null);
            if (Objects.nonNull(existingCustomField)) {
                CustomFieldPivotImporterServiceImpl.logCustomFieldAlreadyExistsInSquash(customFieldPivot, pivotFormatImport);
                pivotImportMetadata.getCustomFieldIdsMap().put(customFieldPivot.getPivotId(), new SquashCustomFieldInfo(existingCustomField.getId(), existingCustomField.getInputType()));
                continue;
            }
            this.createCustomField(customFieldPivot, pivotFormatImport, pivotImportMetadata);
        }
        customFieldPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCustomField(CustomFieldPivot customFieldPivot, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "custom field", customFieldPivot.getPivotId(), pivotFormatImport);
        try {
            CustomField customField = this.adminPivotConverterService.pivotToCustomField(customFieldPivot);
            this.customFieldManagerService.persistUnsecured(customField);
            pivotImportMetadata.getCustomFieldIdsMap().put(customFieldPivot.getPivotId(), new SquashCustomFieldInfo(customField.getId(), customField.getInputType()));
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "custom field", customFieldPivot.getName(), customFieldPivot.getPivotId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "custom field", customFieldPivot.getName(), customFieldPivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private static void logCustomFieldAlreadyExistsInSquash(CustomFieldPivot customFieldPivot, PivotFormatImport pivotFormatImport) {
        LOGGER.info("Import id {} - Custom field \"{}\" with internal id {} already exists in Squash. Import will use the existing custom field.", new Object[]{pivotFormatImport.getId(), customFieldPivot.getName(), customFieldPivot.getPivotId()});
    }
}

