/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.CouldNotImportFileException;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;

public abstract class AbstractPivotImport {
    private final Logger logger;

    protected AbstractPivotImport(Logger logger) {
        this.logger = logger;
    }

    /*
     * Unable to fully structure code
     */
    protected <IS extends InputStream, P extends AbstractPivotObject> void parseEntities(IS is, JsonImportFile jsonImportFile, String entityKind, Class<P> pivotClazz, Consumer<P> parsingStrategy) throws IOException {
        objectMapper = new ObjectMapper();
        var7_7 = null;
        var8_9 = null;
        try {
            jsonParser = objectMapper.createParser(is);
            try {
                jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                while (jsonParser.nextToken() != null) {
                    if (jsonImportFile.getJsonFieldKind().equals(jsonParser.currentName())) ** GOTO lbl13
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        this.parseEntity(objectMapper, jsonParser, entityKind, pivotClazz, parsingStrategy);
lbl13:
                        // 2 sources

                        ** while (jsonParser.nextToken() != null)
                    }
lbl14:
                    // 1 sources

                }
            }
            finally {
                if (jsonParser != null) {
                    jsonParser.close();
                }
            }
        }
        catch (Throwable var8_10) {
            if (var7_7 == null) {
                var7_7 = var8_10;
            } else if (var7_7 != var8_10) {
                var7_7.addSuppressed(var8_10);
            }
            throw var7_7;
        }
    }

    private <P extends AbstractPivotObject> void parseEntity(ObjectMapper objectMapper, JsonParser jsonParser, String entityKind, Class<P> pivotClazz, Consumer<P> parsingStrategy) throws IOException {
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            return;
        }
        JsonNode node = (JsonNode)objectMapper.readTree(jsonParser);
        JsonNode pivotIdNode = node.get("id");
        try {
            AbstractPivotObject pivotObject = (AbstractPivotObject)objectMapper.treeToValue((TreeNode)node, pivotClazz);
            PivotFormatLoggerHelper.logParsingSuccessForEntity(this.logger, entityKind, pivotObject.getPivotId());
            parsingStrategy.accept(pivotObject);
        }
        catch (Exception e) {
            String pivotId = null;
            if (pivotIdNode != null) {
                pivotId = pivotIdNode.asText();
            }
            PivotFormatLoggerHelper.handleParsingErrorForEntity(this.logger, entityKind, pivotId, e);
        }
    }

    protected <P extends AbstractPivotObject> void importEntitiesFromZipArchive(ZipFile zipFile, JsonImportFile jsonImportFile, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata, String entitiesKind, String entityKind, PivotImportStrategy<P> pivotImportStrategy) {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(this.logger, zipFile.getName(), entitiesKind, pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(jsonImportFile.getFileName());
        if (Objects.isNull(entry)) {
            pivotImportStrategy.onMissingFile();
            return;
        }
        pivotImportMetadata.setAtLeastOneData(true);
        ArrayList entities = new ArrayList();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                this.parseEntities(jsonInputStream, jsonImportFile, entityKind, pivotImportStrategy.getPivotClazz(), entity -> {
                    entities.add(entity);
                    if (entities.size() == 50) {
                        pivotImportStrategy.create(entities);
                    }
                });
                if (!entities.isEmpty()) {
                    pivotImportStrategy.create(entities);
                }
                pivotImportStrategy.postCreate();
                PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(this.logger, entitiesKind, pivotFormatImport);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.logImportFailureForEntitiesKind(this.logger, entitiesKind, pivotFormatImport);
            throw new CouldNotImportFileException("Could not import file %s".formatted(jsonImportFile.getFileName()), e);
        }
    }
}

