/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.iteration;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.planning.StandardWorkloadCalendar;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.statistics.CountOnEnum;
import org.squashtest.tm.service.statistics.campaign.TestInventoryStatistics;

public class TestSuiteTestInventoryStatistics {
    private String testsuiteName = "";
    private Date scheduledStart;
    private Date scheduledEnd;
    private final CountOnEnum<ExecutionStatus> statusStatistics = new CountOnEnum<ExecutionStatus>(TestInventoryStatistics.getHandledStatuses());
    private final CountOnEnum<TestCaseImportance> importanceStatistics = new CountOnEnum<TestCaseImportance>(TestCaseImportance.class);

    public String getTestsuiteName() {
        return this.testsuiteName;
    }

    public void setTestsuiteName(String testsuiteName) {
        this.testsuiteName = testsuiteName;
    }

    public int getNbTotal() {
        return this.statusStatistics.calculateTotal();
    }

    public int getNbToExecute() {
        return this.statusStatistics.keep(ExecutionStatus.getNonTerminatedStatusSet()).calculateTotal();
    }

    public int getNbExecuted() {
        return this.statusStatistics.keep(ExecutionStatus.getTerminatedStatusSet()).calculateTotal();
    }

    public float getPcProgress() {
        return (float)Math.round((float)this.getNbExecuted() / (float)this.getNbTotal() * 10000.0f) / 100.0f;
    }

    public float getPcSuccess() {
        int success = this.statusStatistics.keep(ExecutionStatus.getSuccessStatusSet()).calculateTotal();
        return (float)Math.round((float)success / (float)this.getNbExecuted() * 10000.0f) / 100.0f;
    }

    public float getPcFailure() {
        int failure = this.statusStatistics.keep(Collections.singleton(ExecutionStatus.FAILURE)).calculateTotal();
        return (float)Math.round((float)failure / (float)this.getNbExecuted() * 10000.0f) / 100.0f;
    }

    public float getPcPrevProgress() {
        float nbToExecuteToDate = this.nbOfTestsToExecuteToDate(this.scheduledStart, this.scheduledEnd, new Date(), this.getNbTotal());
        float pcPrevProgress = Float.floatToRawIntBits(nbToExecuteToDate) == 0 ? this.getPcProgress() : (float)Math.round((float)this.getNbExecuted() / this.nbOfTestsToExecuteToDate(this.scheduledStart, this.scheduledEnd, new Date(), this.getNbTotal()) * 10000.0f) / 100.0f;
        return Math.min(pcPrevProgress, 100.0f);
    }

    public int getNbPrevToExecute() {
        return (int)this.nbOfTestsToExecuteToDate(this.scheduledStart, this.scheduledEnd, new Date(), this.getNbTotal()) - this.getNbExecuted();
    }

    public LinkedHashMap<ExecutionStatus, Integer> getStatusStatistics() {
        return this.statusStatistics.getStatistics();
    }

    public LinkedHashMap<TestCaseImportance, Integer> getImportanceStatistics() {
        return this.importanceStatistics.getStatistics();
    }

    private float nbOfTestsToExecuteToDate(Date scheduledStart, Date scheduledEnd, Date currentDate, int nbTests) {
        float result;
        if (scheduledStart == null || scheduledEnd == null || currentDate.before(scheduledStart)) {
            result = 0.0f;
        } else if (currentDate.after(scheduledEnd)) {
            result = nbTests;
        } else {
            StandardWorkloadCalendar workloadCalendar = new StandardWorkloadCalendar();
            float totalNumberOfBusinessDays = workloadCalendar.getWorkload(scheduledStart, scheduledEnd);
            float numberOfSpentBusinessDays = workloadCalendar.getWorkload(scheduledStart, currentDate);
            float spentTime = numberOfSpentBusinessDays / totalNumberOfBusinessDays;
            result = (float)nbTests * spentTime;
        }
        return result;
    }

    public Date getScheduledStart() {
        return this.scheduledStart;
    }

    public void setScheduledStart(Date scheduledStart) {
        this.scheduledStart = scheduledStart;
    }

    public Date getScheduledEnd() {
        return this.scheduledEnd;
    }

    public void setScheduledEnd(Date scheduledEnd) {
        this.scheduledEnd = scheduledEnd;
    }

    public void addExecutionCount(int nb, ExecutionStatus status, TestCaseImportance importance) {
        this.statusStatistics.add(status, nb);
        if (!status.isTerminatedStatus()) {
            this.importanceStatistics.add(importance, nb);
        }
    }
}

