/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter.topivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.ImportXrayException;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.AbstractPivotEntityWithScheduled;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayImportModel;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayItemStatus;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.SquashRules;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.AbstractImporterXrayHelper;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot.ExecutionWorkspaceToPivotImporterService;

@Service
public class ExecutionWorkspaceToPivotImporterServiceImpl
extends AbstractImporterXrayHelper
implements ExecutionWorkspaceToPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionWorkspaceToPivotImporterServiceImpl.class);
    private final XrayTablesDao xrayTablesDao;
    private final SquashRules squashRules;
    private final PivotFileManager pivotFileManager;

    public ExecutionWorkspaceToPivotImporterServiceImpl(XrayTablesDao xrayTablesDao, SquashRules squashRules, PivotFileManager pivotFileManager) {
        this.xrayTablesDao = xrayTablesDao;
        this.squashRules = squashRules;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void writeCampaign(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        logWriter.write(String.format("%sCampaign%s", System.lineSeparator(), System.lineSeparator()));
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyItemTable(XrayField.Type.TEST_PLAN, XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        if (isEmptyEntity) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleCampaign((JsonGenerator)jsonGenerator, logWriter, xrayImportModel, tpiPivotByTestCaseKey), JsonImportFile.CAMPAIGNS, archive);
    }

    @Override
    public void writeIteration(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        logWriter.write(String.format("%sIteration%s", System.lineSeparator(), System.lineSeparator()));
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyItemTable(XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        if (isEmptyEntity) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleIteration((JsonGenerator)jsonGenerator, logWriter, xrayImportModel, tpiPivotByTestCaseKey), JsonImportFile.ITERATIONS, archive);
    }

    private void handleCampaign(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        this.squashRules.handleDuplicateName(this.xrayTablesDao.selectDuplicateName(XrayField.Type.TEST_PLAN));
        this.squashRules.handleDuplicateName(this.xrayTablesDao.selectDuplicateNameOrphanTestExecution(XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION));
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.CAMPAIGN);
        this.xrayTablesDao.selectTestPlan(this.pivotFileManager.consumerThrowingIOException(itemXrayDto -> this.generateCampaign(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount, tpiPivotByTestCaseKey)), XrayField.Type.TEST_PLAN);
        this.xrayTablesDao.selectOrphanTestExecution(this.pivotFileManager.consumerThrowingIOException(itemXrayDto -> this.generateCampaign(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount, tpiPivotByTestCaseKey)), XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        xrayImportModel.getEntityCounts().add(entityCount);
    }

    private void generateCampaign(JsonGenerator jsonGenerator, PrintWriter logWriter, ItemXrayDto itemXrayDto, XrayImportModel.EntityCount entityCount, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        try {
            CampaignPivot campaignPivot = this.populateCampaign(itemXrayDto, tpiPivotByTestCaseKey);
            jsonGenerator.writeObject((Object)campaignPivot);
            this.squashRules.markWithSuccessIfStatusIsNull(itemXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            itemXrayDto.setItemStatus(XrayItemStatus.FAILURE);
        }
        entityCount.countEntity(itemXrayDto);
        this.writeLog(logWriter, itemXrayDto);
    }

    private CampaignPivot populateCampaign(ItemXrayDto itemXrayDto, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        this.squashRules.validateMandatoryCommonField(itemXrayDto);
        CampaignPivot campaignPivot = new CampaignPivot();
        campaignPivot.setPivotId(itemXrayDto.getPivotId());
        campaignPivot.setName(itemXrayDto.getSummary());
        campaignPivot.setReference(itemXrayDto.getKey());
        campaignPivot.setDescription(this.generateDescription(itemXrayDto, this::addLinkPriorityStatusLabelToDescription));
        campaignPivot.setStatus(this.squashRules.checkStatus(itemXrayDto, itemXrayDto.getStatus()).getCampaignStatus());
        campaignPivot.setParentType(EntityType.CAMPAIGN_LIBRARY);
        campaignPivot.addAllTestPlanItems(this.getTestPlanItem(itemXrayDto, tpiPivotByTestCaseKey));
        this.handleScheduleDate(campaignPivot, itemXrayDto);
        return campaignPivot;
    }

    private void handleScheduleDate(AbstractPivotEntityWithScheduled genericExecutionWorkspace, ItemXrayDto itemXrayDto) {
        String beginDate = itemXrayDto.getDateCufValue("Begin Date", XrayField.CustomFieldKey.DATE_TIME);
        String endDate = itemXrayDto.getDateCufValue("End Date", XrayField.CustomFieldKey.DATE_TIME);
        this.parseXrayDateToIsoDateIfNotNull(itemXrayDto, "Begin Date", beginDate, genericExecutionWorkspace::setScheduledStartDate);
        this.parseXrayDateToIsoDateIfNotNull(itemXrayDto, "End Date", endDate, genericExecutionWorkspace::setScheduledEndDate);
    }

    private void parseXrayDateToIsoDateIfNotNull(ItemXrayDto itemXrayDto, String dateType, String xrayDate, Consumer<Date> consumeDate) {
        if (Objects.nonNull(xrayDate)) {
            try {
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("EEE, ").appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(" MMM yyyy HH:mm:ss Z").toFormatter(Locale.ENGLISH);
                consumeDate.accept(Date.from(ZonedDateTime.parse(xrayDate, dateTimeFormatter).toInstant()));
            }
            catch (DateTimeParseException dateTimeParseException) {
                LOGGER.error("Error during the parsing of the date in xray import: ", (Throwable)dateTimeParseException);
                this.squashRules.markWithWarning(itemXrayDto, String.format("The date '%s' cannot be parsed with the pattern '%s'", xrayDate, "EEE, dd MMM yyyy HH:mm:ss Z"));
            }
        } else {
            this.squashRules.markWithWarning(itemXrayDto, String.format("The %s field is missing. The associated scheduling date has been ignored.", dateType));
        }
    }

    private List<TestPlanItemPivot> getTestPlanItem(ItemXrayDto itemXrayDto, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        ArrayList<String> missingTest = new ArrayList<String>();
        ArrayList<String> testCaseKeys = new ArrayList<String>();
        for (String testCaseKey : itemXrayDto.getAssociatedIssuesWithXrayKey().keySet()) {
            if (tpiPivotByTestCaseKey.containsKey(testCaseKey)) {
                testCaseKeys.add(testCaseKey);
                continue;
            }
            missingTest.add(testCaseKey);
        }
        if (!missingTest.isEmpty()) {
            this.squashRules.markWithWarning(itemXrayDto, String.format("The following test are missing: %s. They have been ignored.", String.join((CharSequence)", ", missingTest)));
        }
        return testCaseKeys.stream().map(tpiPivotByTestCaseKey::get).flatMap(Collection::stream).toList();
    }

    private void handleIteration(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        this.squashRules.handleDuplicateNameWithParentType(this.xrayTablesDao.selectDuplicateNameGroupBy(XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN, XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION));
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.ITERATION);
        this.xrayTablesDao.selectTestExecutionForIteration(this.pivotFileManager.consumerThrowingRecordAndId((itemXrayDto, id) -> this.generateIteration(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount, (AtomicInteger)id, tpiPivotByTestCaseKey)), XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        xrayImportModel.getEntityCounts().add(entityCount);
    }

    private void generateIteration(JsonGenerator jsonGenerator, PrintWriter logWriter, ItemXrayDto itemXrayDto, XrayImportModel.EntityCount entityCount, AtomicInteger id, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) throws IOException {
        try {
            IterationPivot iterationPivot = this.populateIteration(itemXrayDto, id, tpiPivotByTestCaseKey);
            jsonGenerator.writeObject((Object)iterationPivot);
            this.squashRules.markWithSuccessIfStatusIsNull(itemXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            itemXrayDto.setItemStatus(XrayItemStatus.FAILURE);
        }
        entityCount.countEntity(itemXrayDto);
        this.writeLog(logWriter, itemXrayDto);
    }

    private IterationPivot populateIteration(ItemXrayDto itemXrayDto, AtomicInteger id, Map<String, List<TestPlanItemPivot>> tpiPivotByTestCaseKey) {
        this.squashRules.validateMandatoryCommonField(itemXrayDto);
        IterationPivot iterationPivot = new IterationPivot();
        iterationPivot.setPivotId(id.incrementAndGet());
        iterationPivot.setName(itemXrayDto.getSummary());
        iterationPivot.setReference(itemXrayDto.getKey());
        iterationPivot.setDescription(this.generateDescription(itemXrayDto, this::addLinkPriorityStatusLabelToDescription));
        iterationPivot.setStatus(this.squashRules.checkStatus(itemXrayDto, itemXrayDto.getStatus()).getIterationStatus());
        iterationPivot.addAllTestPlanItems(this.getTestPlanItem(itemXrayDto, tpiPivotByTestCaseKey));
        this.handleScheduleDate(iterationPivot, itemXrayDto);
        this.addIterationParentId(itemXrayDto, iterationPivot);
        return iterationPivot;
    }

    private void addIterationParentId(ItemXrayDto itemXrayDto, IterationPivot iterationPivot) {
        if (!itemXrayDto.getTestPlanPivotIds().isEmpty()) {
            if (itemXrayDto.getTestPlanPivotIds().size() > 1) {
                this.squashRules.markWithWarning(itemXrayDto, "Multiple Test Plan associations found. Only the first one has been taken into account.");
            }
            iterationPivot.setParentId(itemXrayDto.getTestPlanPivotIds().getFirst());
        } else if (Objects.nonNull(itemXrayDto.getPivotId())) {
            iterationPivot.setParentId(itemXrayDto.getPivotId());
        } else {
            this.squashRules.markWithErrorAndThrow(itemXrayDto, "The issue is linked to a Test Plan, but the Test Plan is not found in the export.");
        }
    }
}

