/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.DatabaseVersionMismatchException;
import org.squashtest.tm.service.configuration.ConfigurationService;

@Service
public class DatabaseVersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseVersionChecker.class);
    public static final String DATABASE_SQUASH_VERSION = "11.0.0";
    @Inject
    ConfigurationService configurationService;

    @PostConstruct
    public void checkDatabaseVersion() {
        String databaseVersion = this.configurationService.findConfiguration("squashtest.tm.database.version");
        if (databaseVersion == null) {
            throw new DatabaseVersionMismatchException("Unable to find the database version.");
        }
        if (!DATABASE_SQUASH_VERSION.equals(databaseVersion)) {
            String message = String.format("The database version is not compatible. Required version : %s, current version : %s", DATABASE_SQUASH_VERSION, databaseVersion);
            throw new DatabaseVersionMismatchException(message);
        }
        LOGGER.info("The database version is compliant.", new Object[0]);
    }
}

