/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.servers;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.internal.servers.ServerOAuth2Conf;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

public class Oauth2Tokens
implements ManageableCredentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oauth2Tokens.class);
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    private Long expiresIn;
    @JsonProperty(value="expiration_date")
    private Long expirationDate;

    public Oauth2Tokens() {
    }

    public Oauth2Tokens(String accessToken, String refreshToken, String tokenType, Long expireIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expireIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate() {
        this.expirationDate = System.currentTimeMillis() + this.getExpiresIn() * 1000L;
    }

    boolean isValid() {
        return !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.accessToken, this.refreshToken});
    }

    @Override
    public AuthenticationProtocol getImplementedProtocol() {
        return AuthenticationProtocol.OAUTH_2;
    }

    @Override
    public boolean allowsUserLevelStorage() {
        return true;
    }

    @Override
    public boolean allowsAppLevelStorage() {
        return true;
    }

    @Override
    public boolean allowsProjectLevelStorage() {
        return false;
    }

    @Override
    public Credentials build(StoredCredentialsManager storeManager, ThirdPartyServer server, String username) {
        LOGGER.debug("Building OAuth2Credentials", new Object[0]);
        ServerAuthConfiguration conf = storeManager.unsecuredFindServerAuthConfiguration(server.getId());
        if (!this.isValid()) {
            LOGGER.debug("Attempted to build OAuth2 credentials for user '{}' but user tokens were invalidated and need to be recreated", new Object[]{username});
        } else if (!this.canBuildWith(conf)) {
            LOGGER.error("Attempted to build OAuth2 credentials for user '{}' but could only find the user tokens. The rest of the configuration, usually held as app-level credentials, is absent or invalid.", new Object[]{username});
        }
        return new OAuth2Credentials(this.accessToken, this.refreshToken, this.tokenType, this.expirationDate);
    }

    private boolean canBuildWith(ServerAuthConfiguration serverConf) {
        return serverConf != null && ServerOAuth2Conf.class.isAssignableFrom(serverConf.getClass());
    }
}

