/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class RobotSyntaxHelpers {
    public static final char NEW_LINE_CHAR = '\n';
    public static final String NEW_LINE = String.valueOf('\n');
    public static final String SETTING_SECTION_TITLE = "*** Settings ***";
    public static final String TEST_CASE_SECTION_TITLE = "*** Test Cases ***";
    public static final String KEYWORD_SECTION_TITLE = "*** Keywords ***";
    public static final String RETURN_RESERVED_WORD = "RETURN";
    public static final String CREATE_DICTIONARY_BUILTIN_KEYWORD = "Create Dictionary";
    public static final String CREATE_LIST_BUILTIN_KEYWORD = "Create List";
    public static final String SET_VARIABLE_BUILTIN_KEYWORD = "Set Variable";

    private RobotSyntaxHelpers() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated.");
    }

    public static String scalarVariable(String name) {
        return String.format("${%s}", name);
    }

    public static String listVariable(String name) {
        return String.format("@{%s}", name);
    }

    public static String dictionaryVariable(String name) {
        return String.format("&{%s}", name);
    }

    public static String assignment(String assignee) {
        return String.format("%s =", assignee);
    }

    private static String wrappedIntoSquareBrackets(String value) {
        return String.format("[%s]", value);
    }

    public static String memberAccess(String settingName) {
        return RobotSyntaxHelpers.wrappedIntoSquareBrackets(settingName);
    }

    public static String setting(String settingName) {
        return RobotSyntaxHelpers.wrappedIntoSquareBrackets(settingName);
    }

    public static String setupSetting() {
        return RobotSyntaxHelpers.setting("Setup");
    }

    public static String teardownSetting() {
        return RobotSyntaxHelpers.setting("Teardown");
    }

    public static String documentationSetting() {
        return RobotSyntaxHelpers.setting("Documentation");
    }

    public static List<List<String>> buildMultilineEntry(String firstColFirstRowContent, List<String> content) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        int i = 0;
        while (i < content.size()) {
            ArrayList<String> cells = new ArrayList<String>();
            cells.add(i == 0 ? firstColFirstRowContent : "...");
            if (StringUtils.isNotBlank((CharSequence)content.get(i))) {
                cells.add(content.get(i));
            }
            rows.add(cells);
            ++i;
        }
        return rows;
    }
}

