/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.resultimport.ImportTestPlanItemDto;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;

@Repository
public class IterationTestPlanDaoImpl
implements IterationTestPlanDao {
    private static final Condition TEST_CASE_HAS_AUTOMATED_STATUS = Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()));
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;

    @Override
    public List<TestPlanItem> findAllByIterationIdWithTCAutomated(Long iterationId) {
        TypedQuery q = this.entityManager.createQuery("select distinct item\nfrom Iteration it\njoin it.testPlan.testPlanItems item\njoin item.referencedTestCase tc\njoin tc.automationRequest ar\njoin tc.project project\nwhere it.id = :iterationId\nand tc.automatable = 'Y'\nand tc.automatedTest is not null\nand ar.requestStatus = 'AUTOMATED'\nand project.allowAutomationWorkflow = true\n", TestPlanItem.class);
        q.setParameter("iterationId", (Object)iterationId);
        return q.getResultList();
    }

    @Override
    public List<TestPlanItem> findAllByTestSuiteIdWithTCAutomated(Long testSuiteId) {
        TypedQuery q = this.entityManager.createQuery(" select distinct item\n from TestSuite ts\n join ts.testPlanItems item\n join item.referencedTestCase tc\n join tc.automationRequest ar\n join tc.project project\n where ts.id = :testSuiteId\n and tc.automatable = 'Y'\n and tc.automatedTest is not null\n and ar.requestStatus = 'AUTOMATED'\n and project.allowAutomationWorkflow = true\n", TestPlanItem.class);
        q.setParameter("testSuiteId", (Object)testSuiteId);
        return q.getResultList();
    }

    @Override
    public List<TestPlanItem> findAllByItemsIdWithTCAutomated(List<Long> itemsIds) {
        TypedQuery q = this.entityManager.createQuery("select distinct item\nfrom TestPlanItem item\njoin item.referencedTestCase tc\njoin tc.automationRequest ar\njoin tc.project project\nwhere item.id in(:itemsIds)\nand tc.automatable = 'Y'\nand tc.automatedTest is not null\nand ar.requestStatus = 'AUTOMATED'\nand project.allowAutomationWorkflow = true\n", TestPlanItem.class);
        q.setParameter("itemsIds", itemsIds);
        return q.getResultList();
    }

    @Override
    public List<TestPlanItem> fetchForAutomatedExecutionCreation(Collection<Long> itemTestPlanIds) {
        List<TestPlanItem> testPlanItems = this.fetchTestPlanItems(itemTestPlanIds);
        Map<Long, TestPlanItem> itemMap = testPlanItems.stream().collect(Collectors.toMap(TestPlanItem::getId, item -> item));
        return itemTestPlanIds.stream().map(itemMap::get).toList();
    }

    private List<TestPlanItem> fetchTestPlanItems(Collection<Long> itemTestPlanIds) {
        List<TestPlanItem> items = new EntityGraphQueryBuilder<TestPlanItem>(this.entityManager, TestPlanItem.class, "SELECT DISTINCT itpi FROM TestPlanItem itpi WHERE itpi.id IN :ids ORDER BY itpi.id").addAttributeNodes("testSuites").executeDistinctList(Collections.singletonMap("ids", itemTestPlanIds));
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        this.loadItemsAttributes(items);
        return items;
    }

    private void loadItemsAttributes(List<TestPlanItem> items) {
        Set<Long> tcIds = items.stream().map(item -> item.getReferencedTestCase().getId()).collect(Collectors.toSet());
        Set datasetIds = items.stream().filter(item -> item.getReferencedDataset() != null).map(item -> item.getReferencedDataset().getId()).collect(Collectors.toSet());
        new EntityGraphQueryBuilder<TestCase>(this.entityManager, TestCase.class, "SELECT DISTINCT tc FROM TestCase tc WHERE tc.id IN :ids").addAttributeNodes("parameters", "automationRequest", "automatedTest", "nature", "type", "attachmentList", "automatedTestReference", "automatedTestTechnology", "datasets", "scmRepository", "steps").addSubGraph("attachmentList", "attachments").addSubGraph("scmRepository", "scmServer").executeDistinctList(Collections.singletonMap("ids", tcIds));
        new EntityGraphQueryBuilder<Dataset>(this.entityManager, Dataset.class, "SELECT DISTINCT ds FROM Dataset ds WHERE ds.id IN :ids").addAttributeNodes("parameterValues").addSubGraph("parameterValues", "dataset", "parameter").executeDistinctList(Collections.singletonMap("ids", datasetIds));
        this.fetchTestStepsForAutomatedExecutionCreation(tcIds);
    }

    private void fetchTestStepsForAutomatedExecutionCreation(Set<Long> testCaseIds) {
        this.entityManager.createNamedQuery("ActionTestSteps.fetchWithAttachmentReferences").setParameter("testCaseIds", testCaseIds).getResultList();
    }

    @Override
    public List<Long> findAllByIterationIdAndLogin(Long iterationId, String login) {
        TypedQuery q = this.entityManager.createQuery("select item.id from Iteration it\njoin it.testPlan.testPlanItems item\njoin item.referencedTestCase tc\nwhere it.id = :iterationId and item.assignee.login = :login\norder by index(item)", Long.class);
        q.setParameter("iterationId", (Object)iterationId);
        q.setParameter("login", (Object)login);
        return q.getResultList();
    }

    @Override
    public List<Long> findAllByTestSuiteId(Long testSuiteId) {
        TypedQuery q = this.entityManager.createQuery("select item.id from TestSuite ts\njoin ts.testPlanItems item\nwhere ts.id = :testSuiteId\norder by index(item)", Long.class);
        q.setParameter("testSuiteId", (Object)testSuiteId);
        return q.getResultList();
    }

    @Override
    public List<Long> findTestPlanItemsToRemoveInDeleteTestSuite(List<Long> suites, List<Long> targetIds) {
        return this.entityManager.createQuery("    SELECT DISTINCT itpi.id\n    FROM TestSuite suite\n    JOIN suite.testPlanItems itpi\n    JOIN itpi.testSuites ts\n    WHERE suite IN (:suites)\n    GROUP BY itpi.id, itpi.testPlan\n    HAVING SUM(CASE WHEN ts.id NOT IN (:targetIds) THEN 1 ELSE 0 END) = 0\n", Long.class).setParameter("suites", suites).setParameter("targetIds", targetIds).getResultList();
    }

    @Override
    public List<TestPlanItem> fetchWithServerByIds(Collection<Long> itemIds) {
        return new NestedEntityGraphQueryBuilder<TestPlanItem>(this.entityManager, TestPlanItem.class, "SELECT DISTINCT itpi FROM TestPlanItem itpi WHERE itpi.id IN :ids ORDER BY itpi.id", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("referencedTestCase"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("testSuites"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("exploratorySessionOverview"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("referencedTestCase", NestedEntityGraphQueryBuilder.GraphDefinition.sub("scmRepository", NestedEntityGraphQueryBuilder.GraphDefinition.attr("scmServer"))), NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlan", NestedEntityGraphQueryBuilder.GraphDefinition.attr("parentIteration")))).executeDistinctList(Map.of("ids", itemIds));
    }

    @Override
    public List<Long> getITPIsByIterationUUIDAndIsAutomated(String iterationUUID) {
        return this.entityManager.createQuery("select itpi.id from Iteration it join it.testPlan.testPlanItems itpi join itpi.referencedTestCase tc left join tc.automationRequest ar WHERE it.uuid = :uuid AND ((tc.project.allowAutomationWorkflow = TRUE AND tc.automatable = 'Y' AND ar.id = tc.automationRequest.id AND ar.requestStatus = 'AUTOMATED') OR tc.project.allowAutomationWorkflow = FALSE )AND (tc.scmRepository IS NOT NULL AND tc.automatedTestReference IS NOT NULL AND tc.automatedTestReference != '' AND tc.automatedTestTechnology IS NOT NULL) ORDER BY itpi.itemOrder", Long.class).setParameter("uuid", (Object)iterationUUID).getResultList();
    }

    @Override
    public List<Long> getITPIsByTestSuiteUUIDAndIsAutomated(String testSuiteUUID) {
        return this.entityManager.createQuery("SELECT itpi.id FROM TestSuite ts JOIN ts.testPlanItems itpi JOIN itpi.referencedTestCase tc LEFT JOIN tc.automationRequest ar WHERE ts.uuid = :uuid AND ((tc.project.allowAutomationWorkflow = TRUE AND tc.automatable = 'Y' AND ar.id = tc.automationRequest.id AND ar.requestStatus = 'AUTOMATED') OR tc.project.allowAutomationWorkflow = FALSE )AND (tc.scmRepository IS NOT NULL AND tc.automatedTestReference IS NOT NULL AND tc.automatedTestReference != '' AND tc.automatedTestTechnology IS NOT NULL)ORDER BY index(itpi)", Long.class).setParameter("uuid", (Object)testSuiteUUID).getResultList();
    }

    @Override
    public List<Long> filterSquashTfItemIds(List<Long> itemIds) {
        Condition isSquashTFAutomated = Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull());
        Condition condition = Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.TRUE).and(TEST_CASE_HAS_AUTOMATED_STATUS).and(isSquashTFAutomated).or(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.FALSE).and(isSquashTFAutomated));
        return this.filterItemIds(itemIds, condition);
    }

    @Override
    public List<Long> filterSquashOrchestratorItemIds(List<Long> itemIds) {
        Condition isSquashOrchestratorAutomated = Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull().and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.ne((Object)"")).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()));
        Condition condition = Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.TRUE).and(TEST_CASE_HAS_AUTOMATED_STATUS).and(isSquashOrchestratorAutomated).or(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)Boolean.FALSE).and(isSquashOrchestratorAutomated));
        return this.filterItemIds(itemIds, condition);
    }

    private List<Long> filterItemIds(List<Long> itemIds, Condition condition) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(itemIds).and(condition)).fetchInto(Long.class);
    }

    @Override
    public Map<Long, Integer> getNextExecutionOrders(Collection<Long> testPlanItemIds) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.coalesce((Field)DSL.max((Field)Tables.EXECUTION.EXECUTION_ORDER).plus((Number)1), (Object)0).as("EXECUTION_ORDER")).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanItemIds)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID}).fetchMap((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, DSL.field((String)"EXECUTION_ORDER", Integer.class));
    }

    @Override
    public Map<Long, List<Long>> getTestPlanItemIdsGroupByTestCaseId(Collection<Long> testPlanItemIds) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanItemIds).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull())).fetchGroups((Field)Tables.TEST_PLAN_ITEM.TCLN_ID, (Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
    }

    @Override
    public List<ImportTestPlanItemDto> findImportTestPlanItemDtosByIterationId(Long iterationId) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).join((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchInto(ImportTestPlanItemDto.class);
    }
}

