/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateTestCaseFolderDao
extends HibernateEntityDao<TestCaseFolder>
implements TestCaseFolderDao {
    @Inject
    private DSLContext dsl;

    @Override
    public TestCaseFolder findByContent(TestCaseLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (TestCaseFolder)this.executeEntityNamedQuery("testCaseFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("testCaseFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<Long> findAllTestCaseIdsFromFolderIds(List<Long> folderIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(folderIds)).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.notIn((Select)this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID).from((TableLike)Tables.TEST_CASE_FOLDER))).fetch((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List results = this.entityManager.createNativeQuery("select * from TCLN_RELATIONSHIP where ancestor_id in (:folderIds)").setParameter("folderIds", ids).getResultList();
        return results.stream().map(row -> ((Number)row[1]).longValue()).toList();
    }

    @Override
    public TestCaseFolder findParentOf(final Long id) {
        SetQueryParametersCallback newCallBack = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("contentId", (Object)id);
            }
        };
        return (TestCaseFolder)this.executeEntityNamedQuery("testCaseFolder.findParentOf", newCallBack);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByFolderIds(Collection<Long> folderIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TEST_CASE_FOLDER).join((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.in(folderIds)).fetchGroups((Field)Tables.TEST_CASE_FOLDER.TCLN_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }

    @Override
    public TestCaseFolder loadForNodeAddition(Long folderId) {
        return (TestCaseFolder)this.entityManager.createQuery("select folder from TestCaseFolder folder\njoin fetch folder.project project\njoin fetch project.testCaseNatures\njoin fetch project.testCaseTypes\nleft join fetch folder.content\nwhere folder.id = :id", TestCaseFolder.class).setParameter("id", (Object)folderId).getSingleResult();
    }

    @Override
    public List<TestCaseFolder> loadForNodeAddition(Collection<Long> folderIds) {
        return this.entityManager.createQuery("select distinct folder from TestCaseFolder folder\njoin fetch folder.project project\njoin fetch project.testCaseNatures\njoin fetch project.testCaseTypes\nleft join fetch folder.content\nwhere folder.id in :ids", TestCaseFolder.class).setParameter("ids", folderIds).getResultList();
    }
}

