/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.QuerydslToolbox;

class FilterPlanner {
    private InternalQueryModel definition;
    private QuerydslToolbox utils;
    private ExtendedHibernateQuery<?> query;

    FilterPlanner(InternalQueryModel definition, ExtendedHibernateQuery<?> query) {
        this.definition = definition;
        this.query = query;
        this.utils = new QuerydslToolbox();
    }

    FilterPlanner(InternalQueryModel definition, ExtendedHibernateQuery<?> query, QuerydslToolbox utils) {
        this.definition = definition;
        this.query = query;
        this.utils = utils;
    }

    void modifyQuery() {
        this.addWhereClauses();
        this.addHavingClauses();
    }

    private void addWhereClauses() {
        Map<Long, Collection<QueryFilterColumn>> whereFilters = this.findWhereFilters();
        BooleanBuilder wherebuilder = this.makeBuilder(whereFilters);
        this.query.where((com.querydsl.core.types.Predicate)wherebuilder);
    }

    private void addHavingClauses() {
        Map<Long, Collection<QueryFilterColumn>> havingFilters = this.findHavingFilters();
        BooleanBuilder havingbuilder = this.makeBuilder(havingFilters);
        this.query.having((com.querydsl.core.types.Predicate)havingbuilder);
    }

    private BooleanBuilder makeBuilder(Map<Long, Collection<QueryFilterColumn>> sortedFilters) {
        BooleanBuilder mainBuilder = new BooleanBuilder();
        for (Map.Entry<Long, Collection<QueryFilterColumn>> entry : sortedFilters.entrySet()) {
            BooleanBuilder orBuilder = new BooleanBuilder();
            for (QueryFilterColumn filter : entry.getValue()) {
                if (filter.getOperation() == Operation.NONE) continue;
                BooleanExpression comparison = this.utils.createAsPredicate(filter);
                orBuilder.or((com.querydsl.core.types.Predicate)comparison);
            }
            mainBuilder.and((com.querydsl.core.types.Predicate)orBuilder);
        }
        return mainBuilder;
    }

    private Map<Long, Collection<QueryFilterColumn>> findWhereFilters() {
        Collection filters = this.definition.getFilterColumns().stream().filter(x -> !"CAMPAIGN_ID".equals(x.getColumn().getLabel()) || "CAMPAIGN_ID".equals(x.getColumn().getLabel()) && x.getValues() != null && !x.getValues().isEmpty() && x.getValues().get(0) != null).collect(Collectors.toList());
        CollectionUtils.filter((Collection)filters, (Predicate)new Predicate(){

            public boolean evaluate(Object filter) {
                return FilterPlanner.this.utils.isWhereClauseComponent((QueryFilterColumn)filter);
            }
        });
        return this.sortFilters(filters);
    }

    private Map<Long, Collection<QueryFilterColumn>> findHavingFilters() {
        ArrayList<QueryFilterColumn> filters = new ArrayList<QueryFilterColumn>(this.definition.getFilterColumns());
        CollectionUtils.filter(filters, (Predicate)new Predicate(){

            public boolean evaluate(Object filter) {
                return FilterPlanner.this.utils.isHavingClauseComponent((QueryFilterColumn)filter);
            }
        });
        return this.sortFilters(filters);
    }

    private Map<Long, Collection<QueryFilterColumn>> sortFilters(Collection<QueryFilterColumn> filters) {
        HashMap<Long, Collection<QueryFilterColumn>> res = new HashMap<Long, Collection<QueryFilterColumn>>();
        for (QueryFilterColumn filter : filters) {
            Long id;
            Long l = id = filter.getColumn().getColumnType() == ColumnType.CUF ? filter.getCufId() : filter.getColumn().getId();
            if (!res.containsKey(id)) {
                res.put(id, new ArrayList());
            }
            ((Collection)res.get(id)).add(filter);
        }
        return res;
    }
}

